Page_Comments_Reports $reports The object that generates WordPress-friendly results.
	 */
	public function __construct(
		Page_Comments_Runner $runner,
		Page_Comments_Reports $reports
	) {
		$this->runner  = $runner;
		$this->reports = $reports;
		$this->reports->set_test_identifier( $this->get_test_identifier() );

		$this->set_runner( $this->runner );
	}

	/**
	 * Returns a human-readable label for this health check.
	 *
	 * @return string The human-readable label.
	 */
	public function get_test_label() {
		return \__( 'Page comments', 'wordpress-seo' );
	}

	/**
	 * Returns the WordPress-friendly health check result.
	 *
	 * @return string[] The WordPress-friendly health check result.
	 */
	protected function get_result() {
		if ( $this->runner->is_successful() ) {
			return $this->reports->get_success_result();
		}

		return $this->reports->get_has_comments_on_multiple_pages_result();
	}
}
                                                                                                                    plugins/wordpress-seo-extended/src/services/health-check/page-comments-reports.php                  0000644                 00000004611 15122266560 0024544 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Services\Health_Check;

/**
 * Presents a set of different messages for the Page_Comments health check.
 */
class Page_Comments_Reports {

	use Reports_Trait;

	/**
	 * Constructor.
	 *
	 * @param  Report_Builder_Factory $report_builder_factory The factory for result builder objects.
	 *                                                        This class uses the report builder to generate WordPress-friendly
	 *                                                        health check results.
	 */
	public function __construct( Report_Builder_Factory $report_builder_factory ) {
		$this->report_builder_factory = $report_builder_factory;
	}

	/**
	 * Returns the report for when comments are set to be all on one page.
	 *
	 * @return string[] The message as a WordPress site status report.
	 */
	public function get_success_result() {
		return $this->get_report_builder()
			->set_label( \esc_html__( 'Comments are displayed on a single page', 'wordpress-seo' ) )
			->set_status_good()
			->set_description( \__( 'Comments on your posts are displayed on a single page. This is just like we\'d suggest it. You\'re doing well!', 'wordpress-seo' ) )
			->build();
	}

	/**
	 * Returns the report for when comments are set to be broken up across multiple pages.
	 *
	 * @return string[] The message as a WordPress site status report.
	 */
	public function get_has_comments_on_multiple_pages_result() {
		return $this->get_report_builder()
			->set_label( \__( 'Comments break into multiple pages', 'wordpress-seo' ) )
			->set_status_recommended()
			->set_description( \__( 'Comments on your posts break into multiple pages. As this is not needed in 999 out of 1000 cases, we recommend you disable it. To fix this, uncheck "Break comments into pages..." on the Discussion Settings page.', 'wordpress-seo' ) )
			->set_actions( $this->get_has_comments_on_multiple_pages_actions() )
			->build();
	}

	/**
	 * Returns the actions for when the comments are set to be broken up across multiple pages.
	 *
	 * @return string The actions as a string.
	 */
	private function get_has_comments_on_multiple_pages_actions() {
		return \sprintf(
			/* translators: 1: Opening tag of the link to the discussion settings page, 2: Link closing tag. */
			\esc_html__( '%1$sGo to the Discussion Settings page%2$s', 'wordpress-seo' ),
			'<a href="' . \esc_url( \admin_url( 'options-discussion.php' ) ) . '">',
			'</a>'
		);
	}
}
                                                                                                                       plugins/wordpress-seo-extended/src/services/health-check/page-comments-runner.php                   0000644                 00000001503 15122266560 0024354 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Services\Health_Check;

/**
 * Runs the Page_Comments health check.
 */
class Page_Comments_Runner implements Runner_Interface {

	/**
	 * Is set to true when comments are set to display on a single page.
	 *
	 * @var bool
	 */
	private $comments_on_single_page;

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->comments_on_single_page = false;
	}

	/**
	 * Runs the health check. Checks if comments are displayed on a single page.
	 *
	 * @return void
	 */
	public function run() {
		$this->comments_on_single_page = \get_option( 'page_comments' ) !== '1';
	}

	/**
	 * Returns true if comments are displayed on a single page.
	 *
	 * @return bool True if comments are displayed on a single page.
	 */
	public function is_successful() {
		return $this->comments_on_single_page;
	}
}
                                                                                                                                                                                             plugins/wordpress-seo-extended/src/services/health-check/postname-permalink-check.php               0000644                 00000002666 15122266560 0025202 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Services\Health_Check;

