You are using a custom tagline or an empty one.', 'wordpress-seo' ) )
			->build();
	}

	/**
	 * Returns the message for a failed health check. In this case, when the user still has the default WordPress tagline set.
	 *
	 * @return string[] The message as a WordPress site status report.
	 */
	public function get_has_default_tagline_result() {
		return $this->get_report_builder()
			->set_label( \__( 'You should change the default WordPress tagline', 'wordpress-seo' ) )
			->set_status_recommended()
			->set_description( \__( 'You still have the default WordPress tagline. Even an empty one is probably better.', 'wordpress-seo' ) )
			->set_actions( $this->get_actions() )
			->build();
	}

	/**
	 * Returns the actions that the user should take when his tagline is still set to the WordPress default.
	 *
	 * @return string The actions as an HTML string.
	 */
	private function get_actions() {
		$query_args    = [
			'autofocus[control]' => 'blogdescription',
		];
		$customize_url = \add_query_arg( $query_args, \wp_customize_url() );

		return \sprintf(
			/* translators: 1: link open tag; 2: link close tag. */
			\esc_html__( '%1$sYou can change the tagline in the customizer%2$s.', 'wordpress-seo' ),
			'<a href="' . \esc_url( $customize_url ) . '">',
			'</a>'
		);
	}
}
                                                                                                                                                                                                                                                        plugins/wordpress-seo-extended/src/services/health-check/default-tagline-runner.php                 0000644                 00000002165 15122266560 0024667 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Services\Health_Check;

/**
 * Runs the Default_Tagline health check.
 */
class Default_Tagline_Runner implements Runner_Interface {

	/**
	 * The default WordPress tagline.
	 */
	public const DEFAULT_BLOG_DESCRIPTION = 'Just another WordPress site';

	/**
	 * Is set to true when the default tagline is set.
	 *
	 * @var bool
	 */
	private $has_default_tagline = true;

	/**
	 * Runs the health check. Checks if the tagline is set to WordPress' default tagline, or to its set translation.
	 *
	 * @return void
	 */
	public function run() {
		$blog_description = \get_option( 'blogdescription' );

		// We are using the WordPress internal translation.
		$translated_blog_description = \__( 'Just another WordPress site', 'default' );

		$this->has_default_tagline = $translated_blog_description === $blog_description || $blog_description === self::DEFAULT_BLOG_DESCRIPTION;
	}

	/**
	 * Returns true if the tagline is set to