esponse The response.
	 */
	public function check_limit() {
		$data = $this->account_action->check_limit();
		return new WP_REST_Response( $data, $data->status );
	}

	/**
	 * Gets the upgrade campaign.
	 * If it's not a free user, no campaign is returned.
	 *
	 * @return WP_REST_Response The response.
	 */
	public function get_upgrade_campaign() {
		$data = $this->account_action->get_upgrade_campaign();
		return new WP_REST_Response( $data, $data->status );
	}

	/**
	 * Checks if a valid code was returned.
	 *
	 * @param string $code The code to check.
	 *
	 * @return bool Whether the code is valid.
	 */
	public function has_valid_code( $code ) {
		return $code !== '';
	}

	/**
	 * Checks if a valid website_id was returned.
	 *
	 * @param int $website_id The website_id to check.
	 *
	 * @return bool Whether the website_id is valid.
	 */
	public function has_valid_website_id( $website_id ) {
		return ! empty( $website_id ) && \is_int( $website_id );
	}

	/**
	 * Whether the current user is allowed to publish post/pages and thus use the Wincher integration.
	 *
	 * @return bool Whether the current user is allowed to use Wincher.
	 */
	public function can_use_wincher() {
		return \current_user_can( 'publish_posts' ) || \current_user_can( 'publish_pages' );
	}
}
                                                                                                                                                                                                                                                                plugins/wordpress-seo-extended/src/routes/workouts-route.php                                        0000644                 00000006150 15122266560 0020520 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Routes;

use WP_REST_Request;
use WP_REST_Response;
use Yoast\WP\SEO\Conditionals\No_Conditionals;
use Yoast\WP\SEO\Helpers\Options_Helper;
use Yoast\WP\SEO\Main;

/**
 * Workouts_Route class.
 */
class Workouts_Route implements Route_Interface {

	use No_Conditionals;

	/**
	 * Represents workouts route.
	 *
	 * @var string
	 */
	public const WORKOUTS_ROUTE = '/workouts';

	/**
	 * The Options helper.
	 *
	 * @var Options_Helper
	 */
	private $options_helper;

	/**
	 * Workouts_Route constructor.
	 *
	 * @param Options_Helper $options_helper The options helper.
	 */
	public function __construct(
		Options_Helper $options_helper
	) {
		$this->options_helper = $options_helper;
	}

	/**
	 * Registers routes with WordPress.
	 *
	 * @return void
	 */
	public function register_routes() {
		$edit_others_posts = static function () {
			return \current_user_can( 'edit_others_posts' );
		};

		$workouts_route = [
			[
				'methods'             => 'GET',
				'callback'            => [ $this, 'get_workouts' ],
				'permission_callback' => $edit_others_posts,
			],
			[
				'methods'             => 'POST',
				'callback'            => [ $this, 'set_workouts' ],
				'permission_callback' => $edit_others_posts,
				'args'                => $this->get_workouts_routes_args(),
			],
		];

		\register_rest_route( Main::API_V1_NAMESPACE, self::WORKOUTS_ROUTE, $workouts_route );
	}

	/**
	 * Returns the workouts as configured for the site.
	 *
	 * @return WP_REST_Response the configuration of the workouts.
	 */
	public function get_workouts() {
		$workouts_option = $this->options_helper->get( 'workouts_data' );

		/**
		 * Filter: 'Yoast\WP\SEO\workouts_options' - Allows adding workouts options by the add-ons.
		 *
		 * @param array $workouts_option The content of the `workouts_data` option in Free.
		 */
		$workouts_option = \apply_filters( 'Yoast\WP\SEO\workouts_options', $workouts_option );

		return new WP_REST_Response(
			[ 'json' => $workouts_option ]
		);
	}

	/**
	 * Sets the workout configuration.
	 *
	 * @param WP_REST_Request $request The request object.
	 *
	 * @return WP_REST_Response the configuration of the workouts.
	 */
	public function set_workouts( $request ) {
		$workouts_data = $request->get_json_params();

		/**
		 * Filter: 'Yoast\WP\SEO\workouts_route_save' - Allows the add-ons to save the options data in their own options.
		 *
		 * @param mixed|null $result The result of the previous saving operation.
		 *
		 * @param array $workouts_data The full set of workouts option data to save.
		 */
		$result = \apply_filters( 'Yoast\WP\SEO\workouts_route_save', null, $workouts_data );

		return new WP_REST_Response(
			[ 'json' => $result ]
		);
	}

	/**
	 * Gets the args for all the registered workouts.
	 *
	 * @return array
	 */
	private function get_workouts_routes_args() {
		$args_array = [];

		/**
		 * Filter: 'Yoast\WP\SEO\workouts_route_args' - Allows the add-ons add their own arguments to the route registration.
		 *
		 * @param array $args_array The array of arguments for the route registration.
		 */
		return \apply_filters( 'Yoast\WP\SEO\workouts_route_args', $args_array );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                        plugins/wordpress-seo-extended/src/routes/yoast-head-rest-field.php                                 0000644                 00000013456 15122266560 0021570 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php // phpcs:ignore Yoast.Files.FileName.InvalidClassFileName -- Reason: this explicitly concerns the Yoast head fields.

namespace Yoast\WP\SEO\Routes;

use Yoast\WP\SEO\Actions\Indexables\Indexable_Head_Action;
use Yoast\WP\SEO\Conditionals\Headless_Rest_Endpoints_Enabled_Conditional;
use Yoast\WP\SEO\Helpers\Post_Helper;
use Yoast\WP\SEO\Helpers\Post_Type_Helper;
use Yoast\WP\SEO\Helpers\Taxonomy_Helper;

/**
 * Yoast_Head_REST_Field class.
 *
 * Registers the yoast head REST field.
 * Not technically a route but behaves the same so is included here.
 */
class Yoast_Head_REST_Field implements Route_Interface {

	/**
	 * The name of the Yoast head field.
	 *
	 * @var string
	 */
	public const YOAST_HEAD_ATTRIBUTE_NAME = 'yoast_head';

	/**
	 * The name of the Yoast head JSON field.
	 *
	 * @var string
	 */
	public const YOAST_JSON_HEAD_ATTRIBUTE_NAME = 'yoast_head_json';

	/**
	 * The post type helper.
	 *
	 * @var Post_Type_Helper
	 */
	protected $post_type_helper;

	/**
	 * The taxonomy helper.
	 *
	 * @var Taxonomy_Helper
	 */
	protected $taxonomy_helper;

	/**
	 * The post helper.
	 *
	 * @var Post_Helper
	 */
	protected $post_helper;

	/**
	 * The head action.
	 *
	 * @var Indexable_Head_Action
	 */
	protected $head_action;

	/**
	 * Returns the conditionals based in which this loadable should be active.
	 *
	 * @return array
	 */
	public static function get_conditionals() {
		return [ Headless_Rest_Endpoints_Enabled_Conditional::class ];
	}

	/**
	 * Yoast_Head_REST_Field constructor.
	 *
	 * @param Post_Type_Helper      $post_type_helper The post type helper.
	 * @param Taxonomy_Helper       $taxonomy_helper  The taxonomy helper.
	 * @param Post_Helper           $post_helper      The post helper.
	 * @param Indexable_Head_Action $head_action      The head action.
	 */
	public function __construct(
		Post_Type_Helper $post_type_helper,
		Taxonomy_Helper $taxonomy_helper,
		Post_Helper $post_helper,
		Indexable_Head_Action $head_action
	) {
		$this->post_type_helper = $post_type_helper;
		$this->taxonomy_helper  = $taxonomy_helper;
		$this->post_helper      = $post_helper;
		$this->h