llback'            => [ $this, 'untrack_keyphrase' ],
			'permission_callback' => [ $this, 'can_use_wincher' ],
		];

		\register_rest_route( Main::API_V1_NAMESPACE, self::UNTRACK_KEYPHRASE_ROUTE, $delete_keyphrase_route_args );

		$check_limit_route_args = [
			'methods'             => 'GET',
			'callback'            => [ $this, 'check_limit' ],
			'permission_callback' => [ $this, 'can_use_wincher' ],
		];

		\register_rest_route( Main::API_V1_NAMESPACE, self::CHECK_LIMIT_ROUTE, $check_limit_route_args );

		$get_upgrade_campaign_route_args = [
			'methods'             => 'GET',
			'callback'            => [ $this, 'get_upgrade_campaign' ],
			'permission_callback' => [ $this, 'can_use_wincher' ],
		];

		\register_rest_route( Main::API_V1_NAMESPACE, self::UPGRADE_CAMPAIGN_ROUTE, $get_upgrade_campaign_route_args );
	}

	/**
	 * Returns the authorization URL.
	 *
	 * @return WP_REST_Response The response.
	 */
	public function get_authorization_url() {
		$data = $this->login_action->get_authorization_url();
		return new WP_REST_Response( $data, $data->status );
	}

	/**
	 * Authenticates with Wincher.
	 *
	 * @param WP_REST_Request $request The request. This request should have a code param set.
	 *
	 * @return WP_REST_Response The response.
	 */
	public function authenticate( WP_REST_Request $request ) {
		$data = $this
			->login_action
			->authenticate( $request['code'], (string) $request['websiteId'] );

		return new WP_REST_Response( $data, $data->status );
	}

	/**
	 * Posts keyphrases to track.
	 *
	 * @param WP_REST_Request $request The request. This request should have a code param set.
	 *
	 * @return WP_REST_Response The response.
	 */
	public function track_keyphrases( WP_REST_Request $request ) {
		$limits = $this->account_action->check_limit();

		if ( $limits->status !== 200 ) {
			return new WP_REST_Response( $limits, $limits->status );
		}

		$data = $this->keyphrases_action->track_keyphrases( $request['keyphrases'], $limits );

		return new WP_REST_Response( $data, $data->status );
	}

	/**
	 * Gets the tracked ke