t ) {
		\_deprecated_function( __METHOD__, 'Yoast SEO 20.2' );

		$data = $this
			->first_time_configuration_action
			->set_person_social_profiles( $request->get_json_params() );

		return new WP_REST_Response(
			[ 'json' => $data ]
		);
	}
}
                                                                                                                                                                                                                                                                          plugins/wordpress-seo-extended/src/routes/importing-route.php                                       0000644                 00000010106 15122266560 0020627 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Routes;

use Exception;
use WP_Error;
use WP_REST_Response;
use Yoast\WP\SEO\Actions\Importing\Importing_Action_Interface;
use Yoast\WP\SEO\Conditionals\No_Conditionals;
use Yoast\WP\SEO\Exceptions\Importing\Aioseo_Validation_Exception;
use Yoast\WP\SEO\Main;
use Yoast\WP\SEO\Services\Importing\Importable_Detector_Service;

/**
 * Importing_Route class.
 *
 * Importing route for importing from other SEO plugins.
 */
class Importing_Route extends Abstract_Action_Route {

	use No_Conditionals;

	/**
	 * The import route constant.
	 *
	 * @var string
	 */
	public const ROUTE = '/import/(?P<plugin>[\w-]+)/(?P<type>[\w-]+)';

	/**
	 * List of available importers.
	 *
	 * @var Importing_Action_Interface[]
	 */
	protected $importers = [];

	/**
	 * The importable detector service.
	 *
	 * @var Importable_Detector_Service
	 */
	protected $importable_detector;

	/**
	 * Importing_Route constructor.
	 *
	 * @param Importable_Detector_Service $importable_detector The importable detector service.
	 * @param Importing_Action_Interface  ...$importers        All available importers.
	 */
	public function __construct(
		Importable_Detector_Service $importable_detector,
		Importing_Action_Interface ...$importers
	) {
		$this->importable_detector = $importable_detector;
		$this->importers           = $importers;
	}

	/**
	 * Registers routes with WordPress.
	 *
	 * @return void
	 */
	public function register_routes() {
		\register_rest_route(
			Main::API_V1_NAMESPACE,
			self::ROUTE,
			[
				'callback'            => [ $this, 'execute' ],
				'permission_callback' => [ $this, 'is_user_permitted_to_import' ],
				'methods'             => [ 'POST' ],
			]
		);
	}

	/**
	 * Executes the rest request, but only if the respective action is enabled.
	 *
	 * @param mixed $data The request parameters.
	 *
	 * @return WP_REST_Response|false Response or false on non-existent route.
	 */
	public function execute( $data ) {
		$plugin = (string) $data['plugin'];
		$type   = (string) $data['type'];

		$next_url = $this->get_endpoint( $plugin, $type );

		try {
			$importer = $this->get_importer( $plugin, $type );

			if ( $importer === false || ! $importer->is_enabled() ) {
				return new WP_Error(
					'rest_no_route',
					'Requested importer not found',
					[
						'status' => 404,
					]
				);
			}

			$result = $importer->index();

			if ( $result === false || \count( $result ) === 0 ) {
				$next_url = false;
			}

			return $this->respond_with(
				$result,
				$next_url
			);
		} catch ( Exception $exception ) {
			if ( $exception instanceof Aioseo_Validation_Exception ) {
				return new WP_Error(
					'wpseo_error_validation',
					$exception->getMessage(),
					[ 'stackTrace' => $exception->getTraceAsString() ]
				);
			}

			return new WP_Error(
				'wpseo_error_indexing',
				$exception->getMessage(),
				[ 'stackTrace' => $exception->getTraceAsString() ]
			);
		}
	}

	/**
	 * Gets the right importer for the given arguments.
	 *
	 * @param string $plugin The plugin to import from.
	 * @param string $type   The type of entity to import.
	 *
	 * @return Importing_Action_Interface|false The importer, or false if no importer was found.
	 */
	protected function get_importer( $plugin, $type ) {
		$importers = $this->importable_detector->filter_actions( $this->importers, $plugin, $type );

		if ( \count( $importers ) !== 1 ) {
			return false;
		}

		return \current( $importers );
	}

	/**
	 * Gets the right endpoint for the given arguments.
	 *
	 * @param string $plugin The plugin to import from.
	 * @param string $type   The type of entity to import.
	 *
	 * @return string|false The endpoint for the given action or false on failure of finding the one.
	 */
	public function get_endpoint( $plugin, $type ) {
		if ( empty( $plugin ) || empty( $type ) ) {
			return false;
		}

		return Main::API_V1_NAMESPACE . "/import/{$plugin}/{$type}";
	}

	/**
	 * Whether or not the current user is allowed to import.
	 *
	 * @return bool Whether or not the current user is allowed to import.
	 */
	public function is_user_permitted_to_import() {
		return \current_user_can( 'activate_plugins' );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                          plugins/wordpress-seo-extended/src/routes/indexables-head-route.php                                 0000644                 00000004622 15122266560 0021642 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Routes;

use WP_REST_Request;
use WP_REST_Response;
use WPSEO_Utils;
use Yoast\WP\SEO\Actions\Indexables\Indexable_Head_Action;
use Yoast\WP\SEO\Conditionals\Headless_Rest_Endpoints_Enabled_Conditional;
use Yoast\WP\SEO\Main;

/**
 * Head route for indexables.
 */
class Indexables_Head_Route implements Route_Interface {

	/**
	 * The posts route constant.
	 *
	 * @var string
	 */
	public const HEAD_FOR_URL_ROUTE = 'get_head';

	/**
	 * The full posts route constant.
	 *
	 * @var string
	 */
	public const FULL_HEAD_FOR_URL_ROUTE = Main::API_V1_NAMESPACE . '/' . self::HEAD_FOR_URL_ROUTE;

	/**
	 * The head action.
	 *
	 * @var Indexable_Head_Action
	 */
	private $head_action;

	/**
	 * Indexable_Indexation_Route constructor.
	 *
	 * @param Indexable_Head_Action $head_action The head action.
	 */
	public function __construct( Indexable_Head_Action $head_action ) {
		$this->head_action = $head_action;
	}

	/**
	 * Returns the conditionals based in which this loadable should be active.
	 *
	 * @return array<string>
	 */
	public static function get_conditionals() {
		return [ Headless_Rest_Endpoints_Enabled_Conditional::class ];
	}

	/**
	 * Registers routes with WordPress.
	 *
	 * @return void
	 */
	public function register_routes() {
		$route_args = [
			'methods'             => 'GET',
			'callback'            => [ $this, 'get_head' ],
			'permission_callback' => '__return_true',
			'args'                => [
				'url' => [
					'validate_callback' => [ $this, 'is_valid_url' ],
					'required'          => true,
				],
			],
		];
		\register_rest_route( Main::API_V1_NAMESPACE, self::HEAD_FOR_URL_ROUTE, $route_args );
	}

	/**
	 * Gets the head of a page for a given URL.
	 *
	 * @param WP_REST_Request $request The request. This request should have a url param set.
	 *
	 * @return WP_REST_Response The response.
	 */
	public function get_head( WP_REST_Request $request ) {
		$url  = \esc_url_raw( \utf8_uri_encode( $request['url'] ) );
		$data = $this->head_action->for_url( $url );

		return new WP_REST_Response( $data, $data->status );
	}

	/**
	 * Checks if a url is a valid url.
	 *
	 * @param string $url The url to check.
	 *
	 * @return bool Whether or not the url is valid.
	 */
	public function is_valid_url( $url ) {
		$url = WPSEO_Utils::sanitize_url( \utf8_uri_encode( $url ) );
		if ( \filter_var( $url, \FILTER_VALIDATE_URL ) === false ) {
			return false;
		}
		return true;
	}
}
                                                                                                              plugins/wordpress-seo-extended/src/routes/indexing-route.php                                        0000644                 00000030522 15122266560 0020430 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Routes;

use Exception;
use WP_Error;
use WP_REST_Response;
use Yoast\WP\SEO\Actions\Indexing\Indexable_General_Indexation_Action;
use Yoast\WP\SEO\Actions\Indexing\Indexable_Indexing_Complete_Action;
use Yoast\WP\SEO\Actions\Indexing\Indexable_Post_Indexation_Action;
use Yoast\WP\SEO\Actions\Indexing\Indexable_Post_Type_Archive_Indexation_Action;
use Yoast\WP\SEO\Actions\Indexing\Indexable_Term_Indexation_Action;
use Yoast\WP\SEO\Actions\Indexing\Indexation_Action_Interface;
use Yoast\WP\SEO\Actions\Indexing\Indexing_Complete_Action;
use Yoast\WP\SEO\Actions\Indexing\Indexing_Prepare_Action;
use Yoast\WP\SEO\Actions\Indexing\Post_Link_Indexing_Action;
use Yoast\WP\SEO\Actions\Indexing\Term_Link_Indexing_Action;
use Yoast\WP\SEO\Conditionals\No_Conditionals;
use Yoast\WP\SEO\Helpers\Indexing_Helper;
use Yoast\WP\SEO\Helpers\Options_Helper;
use Yoast\WP\SEO\Main;

/**
 * Indexing_Route class.
 *
 * Indexing route for indexables.
 */
class Indexing_Route extends Abstract_Indexation_Route {

	use No_Conditionals;

	/**
	 * The indexing complete route constant.
	 *
	 * @var string
	 */
	public const COMPLETE_ROUTE = 'indexing/complete';

	/**
	 * The full indexing complete route constant.
	 *
	 * @var string
	 */
	public const FULL_COMPLETE_ROUTE = Main::API_V1_NAMESPACE . '/' . self::COMPLETE_ROUTE;

	/**
	 * The indexables complete route constant.
	 *
	 * @var string
	 */
	public const INDEXABLES_COMPLETE_ROUTE = 'indexing/indexables-complete';

	/**
	 * The full indexing complete route constant.
	 *
	 * @var string
	 */
	public const FULL_INDEXABLES_COMPLETE_ROUTE = Main::API_V1_NAMESPACE . '/' . self::INDEXABLES_COMPLETE_ROUTE;

	/**
	 * The indexing prepare route constant.
	 *
	 * @var string
	 */
	public const PREPARE_ROUTE = 'indexing/prepare';

	/**
	 * The full indexing prepare route constant.
	 *
	 * @var string
	 */
	public const FULL_PREPARE_ROUTE = Main::API_V1_NAMESPACE . '/' . self::PREPARE_ROUTE;

	/**
	 * The posts route constant.
	 *
	 * @var string
	 */
	public const POSTS_ROUTE = 'indexing