 post ID.
	 *
	 * @param int $post_id The post ID.
	 *
	 * @return bool Whether or not the delete was succesfull.
	 */
	public function delete_all_by_post_id( $post_id ) {
		return $this->query()
			->where( 'post_id', $post_id )
			->delete_many();
	}

	/**
	 * Clears all SEO Links by post ID where the indexable id is null.
	 *
	 * @param int $post_id The post ID.
	 *
	 * @return bool Whether or not the delete was succesfull.
	 */
	public function delete_all_by_post_id_where_indexable_id_null( $post_id ) {
		return $this->query()
			->where( 'post_id', $post_id )
			->where_null( 'indexable_id' )
			->delete_many();
	}

	/**
	 * Clears all SEO Links by indexable ID.
	 *
	 * @param int $indexable_id The indexable ID.
	 *
	 * @return bool Whether or not the delete was succesfull.
	 */
	public function delete_all_by_indexable_id( $indexable_id ) {
		return $this->query()
			->where( 'indexable_id', $indexable_id )
			->delete_many();
	}

	/**
	 * Returns incoming link counts for a number of posts.
	 *
	 * @param array $post_ids The post IDs.
	 *
	 * @return array An array of associative arrays, each containing a post id and incoming property.
	 */
	public function get_incoming_link_counts_for_post_ids( $post_ids ) {
		return $this->query()
			->select_expr( 'COUNT( id )', 'incoming' )
			->select( 'target_post_id', 'post_id' )
			->where_in( 'target_post_id', $post_ids )
			->group_by( 'target_post_id' )
			->find_array();
	}

	/**
	 * Returns incoming link counts for a number of indexables.
	 *
	 * @param array $indexable_ids The indexable IDs.
	 *
	 * @return array An array of associative arrays, each containing a indexable id and incoming property.
	 */
	public function get_incoming_link_counts_for_indexable_ids( $indexable_ids ) {
		if ( empty( $indexable_ids ) ) {
			return [];
		}

		// This query only returns ID's with an incoming count > 0. We need to restore any ID's with 0 incoming links later.
		$indexable_counts = $this->query()
			->select_expr( 'COUNT( id )', 'incoming' )
			->select( 'target_indexable_id' )
			->where_in( 'target_indexable_id', $indexable_ids )
			->group_by( 'target_indexable_id' )
			->find_array();

		// If the above query fails, do not update anything.
		if ( ! \is_array( $indexable_counts ) ) {
			return [];
		}

		// Get all ID's returned from the query and set them as keys for easy access.
		$returned_ids = \array_flip( \array_column( $indexable_counts, 'target_indexable_id' ) );

		// Loop over the original ID's and search them in the returned ID's. If they don't exist, add them with an incoming count of 0.
		foreach ( $indexable_ids as $id ) {
			// Cast the ID to string, as the arrays only contain stringified versions of the ID.
			$id = \strval( $id );
			if ( isset( $returned_ids[ $id ] ) === false ) {
				$indexable_counts[] = [
					'incoming'            => '0',
					'target_indexable_id' => $id,
				];
			}
		}

		return $indexable_counts;
	}

	/**
	 * Deletes all seo links for the given ids.
	 *
	 * @param int[] $ids The seo link ids.
	 *
	 * @return bool Whether or not the delete was succesfull.
	 */
	public function delete_many_by_id( $ids ) {
		return $this->query()
			->where_in( 'id', $ids )
			->delete_many();
	}

	/**
	 * Insert multiple seo links.
	 *
	 * @param SEO_Links[] $links The seo links to be inserted.
	 *
	 * @return bool Whether or not the insert was succesfull.
	 */
	public function insert_many( $links ) {
		return $this->query()
			->insert_many( $links );
	}
}
                                                                                              plugins/wordpress-seo-extended/src/routes/abstract-action-route.php                                 0000644                 00000001172 15122266560 0021700 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Routes;

use WP_REST_Response;

/**
 * Abstract_Action_Route class.
 *
 * Abstract class for action routes.
 */
abstract class Abstract_Action_Route implements Route_Interface {

	/**
	 * Responds to an indexing request.
	 *
	 * @param array  $objects  The objects that have been indexed.
	 * @param string $next_url The url that should be called to continue reindexing. False if done.
	 *
	 * @return WP_REST_Response The response.
	 */
	protected function respond_with( $objects, $next_url ) {
		return new WP_REST_Response(
			[
				'objects'  => $objects,
				'next_url' => $next_url,
			]
		);
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                      plugins/wordpress-seo-extended/src/routes/abstract-indexation-route.php                             0000644                 00000001604 15122266560 0022565 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Routes;

use WP_REST_Response;
use Yoast\WP\SEO\Actions\Indexing\Indexation_Action_Interface;

/**
 * Abstract_Indexation_Route class.
 *
 * Reindexing route for indexables.
 */
abstract class Abstract_Indexation_Route extends Abstract_Action_Route {

	/**
	 * Runs an indexing action and returns the response.
	 *
	 * @param Indexation_Action_Interface $indexation_action The indexing action.
	 * @param string                      $url               The url of the indexing route.
	 *
	 * @return WP_REST_Response The response.
	 */
	protected function run_indexation_action( Indexation_Action_Interface $indexation_action, $url ) {
		$indexables = $indexation_action->index();

		$next_url = false;
		if ( \count( $indexables ) >= $indexation_action->get_limit() ) {
			$next_url = \rest_url( $url );
		}

		return $this->respond_with( $indexables, $next_url );
	}
}
                                                                                                                            plugins/wordpress-seo-extended/src/routes/alert-dismissal-route.php                                 0000644                 00000004521 15122266560 0021720 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Routes;

use WP_REST_Request;
use WP_REST_Response;
use Yoast\WP\SEO\Actions\Alert_Dismissal_Action;
use Yoast\WP\SEO\Conditionals\No_Conditionals;
use Yoast\WP\SEO\Main;

/**
 * Class Alert_Dismissal_Route.
 */
class Alert_Dismissal_Route implements Route_Interface {

	use No_Conditionals;

	/**
	 * Represents the alerts route prefix.
	 *
	 * @var string
	 */
	public const ROUTE_PREFIX = 'alerts';

	/**
	 * Represents the dismiss route.
	 *
	 * @var string
	 */
	public const DISMISS_ROUTE = self::ROUTE_PREFIX . '/dismiss';

	/**
	 * Represents the full dismiss route.
	 *
	 * @var string
	 */
	public const FULL_DI