<?php

namespace Yoast\WP\SEO\Presenters\Webmaster;

use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Google Search Console verification setting.
 */
class Google_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'google-site-verification';

	/**
	 * Retrieves the webmaster tool site verification value from the settings.
	 *
	 * @return string The webmaster tool site verification value.
	 */
	public function get() {
		return $this->helpers->options->get( 'googleverify', '' );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                   plugins/wordpress-seo-extended/src/presenters/webmaster/pinterest-presenter.php                     0000644                 00000001130 15122266560 0024344 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Webmaster;

use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Pinterest Webmaster verification setting.
 */
class Pinterest_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'p:domain_verify';

	/**
	 * Retrieves the webmaster tool site verification value from the settings.
	 *
	 * @return string The webmaster tool site verification value.
	 */
	public function get() {
		return $this->helpers->options->get( 'pinterestverify', '' );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                        plugins/wordpress-seo-extended/src/presenters/webmaster/yandex-presenter.php                        0000644                 00000001123 15122266560 0023621 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Webmaster;

use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Yandex Webmaster verification setting.
 */
class Yandex_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'yandex-verification';

	/**
	 * Retrieves the webmaster tool site verification value from the settings.
	 *
	 * @return string The webmaster tool site verification value.
	 */
	public function get() {
		return $this->helpers->options->get( 'yandexverify', '' );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                             plugins/wordpress-seo-extended/src/promotions/application/promotion-manager-interface.php           0000644                 00000000773 15122266560 0026263 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Promotions\Application;

/**
 * Interface for the promotion manager.
 */
interface Promotion_Manager_Interface {

	/**
	 * Whether the promotion is effective.
	 *
	 * @param string $promotion_name The name of the promotion.
	 *
	 * @return bool Whether the promotion is effective.
	 */
	public function is( string $promotion_name ): bool;

	/**
	 * Get the list of promotions.
	 *
	 * @return array The list of promotions.
	 */
	public function get_promotions_list(): array;
}
     plugins/wordpress-se