value = $this->get();

		if ( \is_string( $value ) && $value !== '' ) {
			return \sprintf( $this->tag_format, $this->escape_value( $value ) );
		}

		return '';
	}

	/**
	 * Returns the presentation title.
	 *
	 * @return string The title.
	 */
	public function get_title() {
		$title = $this->replace_vars( $this->presentation->title );

		/**
		 * Filter: 'wpseo_title' - Allow changing the Yoast SEO generated title.
		 *
		 * @param string                 $title        The title.
		 * @param Indexable_Presentation $presentation The presentation of an indexable.
		 */
		$title = \apply_filters( 'wpseo_title', $title, $this->presentation );
		$title = $this->helpers->string->strip_all_tags( $title );
		return \trim( $title );
	}
}
                                                                                                                                                                                                                                                                                            plugins/wordpress-seo-extended/src/presenters/twitter/card-presenter.php                            0000644                 00000001551 15122266560 0022760 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Twitter;

use Yoast\WP\SEO\Presentations\Indexable_Presentation;
use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Twitter Card tag.
 */
class Card_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'twitter:card';

	/**
	 * Runs the card type through the `wpseo_twitter_card_type` filter.
	 *
	 * @return string The filtered card type.
	 */
	public function get() {
		/**
		 * Filter: 'wpseo_twitter_card_type' - Allow changing the Twitter card type.
		 *
		 * @param string $card_type The card type.
		 * @param Indexable_Presentation $presentation The presentation of an indexable.
		 */
		return \trim( \apply_filters( 'wpseo_twitter_card_type', $this->presentation->twitter_card, $this->presentation ) );
	}
}
                                                                                                                                                       plugins/wordpress-seo-extended/src/presenters/twitter/creator-presenter.php                         0000644                 00000000753 15122266560 0023511 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Twitter;

use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Twitter creator.
 */
class Creator_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'twitter:creator';

	/**
	 * Gets the raw value of a presentation.
	 *
	 * @return string The raw value.
	 */
	public function get() {
		return $this->presentation->twitter_creator;
	}
}
                     plugins/wordpress-seo-extended/src/presenters/twitter/description-presenter.php                     0000644                 00000002020 15122266560 0024362 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Twitter;

use Yoast\WP\SEO\Presentations\Indexable_Presentation;
use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Twitter description.
 */
class Description_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'twitter:description';

	/**
	 * Run the Twitter description through replace vars and the `wpseo_twitter_description` filter.
	 *
	 * @return string The filtered Twitter description.
	 */
	public function get() {
		/**
		 * Filter: 'wpseo_twitter_description' - Allow changing the Twitter description as output in the Twitter card by Yoast SEO.
		 *
		 * @param string                 $twitter_description The description string.
		 * @param Indexable_Presentation $presentation        The presentation of an indexable.
		 */
		return \apply_filters( 'wpseo_twitter_description', $this->replace_vars( $this->presentation->twitter_description ), $this->presentation );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                plugins/wordpress-seo-extended/src/presenters/twitter/image-presenter.php                           0000644                 00000001743 15122266560 0023134 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Twitter;

use Yoast\WP\SEO\Presentations\Indexable_Presentation;
use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Twitter image.
 */
class Image_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'twitter:image';

	/**
	 * The method of escaping to use.
	 *
	 * @var string
	 */
	protected $escaping = 'url';

	/**
	 * Run the Twitter image value through the `wpseo_twitter_image` filter.
	 *
	 * @return string The filtered Twitter image.
	 */
	public function get() {
		/**
		 * Filter: 'wpseo_twitter_image' - Allow changing the Twitter Card image.
		 *
		 * @param string                 $twitter_image Image URL string.
		 * @param Indexable_Presentation $presentation  The presentation of an indexable.
		 */
		return (string) \apply_filters( 'wpseo_twitter_image', $this->presentation->twitter_image, $this->presentation );
	}
}
                             plugins/wordpress-seo-extended/src/presenters/twitter/site-presenter.php                            0000644                 00000003223 15122266560 0023011 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Twitter;

use Yoast\WP\SEO\Presentations\Indexable_Presentation;
use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Twitter site tag.
 */
class Site_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'twitter:site';

	/**
	 * Run the Twitter site through the `wpseo_twitter_site` filter.
	 *
	 * @return string The filtered Twitter site.
	 */
	public function get() {
		/**
		 * Filter: 'wpseo_twitter_site' - Allow changing the Twitter site account as output in the Twitter card by Yoast SEO.
		 *
		 * @param string                 $twitter_site Twitter site account string.
		 * @param Indexable_Presentation $presentation The presentation of an indexable.
		 */
		$twitter_site = \apply_filters( 'wpseo_twitter_site', $this->presentation->twitter_site, $this->presentation );
		$twitter_site = $this->get_twitter_id( $twitter_site );

		if ( ! \is_string( $twitter_site ) || $twitter_site === '' ) {
			return '';
		}

		return '@' . $twitter_site;
	}

	/**
	 * Checks if the given id is actually an id or a url and if url, distills the id from it.
	 *
	 * Solves issues with filters returning urls and theme's/other plugins also adding a user meta
	 * twitter field which expects url rather than an id (which is what we expect).
	 *
	 * @param string $id Twitter ID or url.
	 *
	 * @return string|bool Twitter ID or false if it failed to get a valid Twitter ID.
	 */
	private function get_twitter_id( $id ) {
		if ( \preg_match( '`([A-Za-z0-9_]{1,25})$`', $id, $match ) ) {
			return $match[1];
		}

		return false;
	}
}
                                                                                                                                                                                                                                                                                                                                                                             plugins/wordpress-seo-extended/src/presenters/twitter/title-presenter.php                           0000644                 00000001641 15122266560 0023170 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Twitter;

use Yoast\WP\SEO\Presentations\Indexable_Presentation;
use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Twitter title.
 */
class Title_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'twitter:title';

	/**
	 * Run the Twitter title through replace vars and the `wpseo_twitter_title` filter.
	 *
	 * @return string The filtered Twitter title.
	 */
	public function get() {
		/**
		 * Filter: 'wpseo_twitter_title' - Allow changing the Twitter title.
		 *
		 * @param string                 $twitter_title The Twitter title.
		 * @param Indexable_Presentation $presentation  The presentation of an indexable.
		 */
		return \trim( \apply_filters( 'wpseo_twitter_title', $this->replace_vars( $this->presentation->twitter_title ), $this->presentation ) );
	}
}
                                                                                               plugins/wordpress-seo-extended/src/presenters/url-list-presenter.php                                0000644                 00000001727 15122266560 0022125 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters;

/**
 * Presenter class for the URL list.
 */
class Url_List_Presenter extends Abstract_Presenter {

	/**
	 * A list of arrays containing titles and URLs.
	 *
	 * @var array
	 */
	private $links;

	/**
	 * Classname for the URL list.
	 *
	 * @var string
	 */
	private $class_name;

	/**
	 * Url_List_Presenter constructor.
	 *
	 * @param array  $links      A list of arrays containing titles and urls.
	 * @param string $class_name Classname for the url list.
	 */
	public function __construct( $links, $class_name = 'yoast-url-list' ) {
		$this->links      = $links;
		$this->class_name = $class_name;
	}

	/**
	 * Presents the URL list.
	 *
	 * @return string The URL list.
	 */
	public function present() {
		$output = '<ul class="' . $this->class_name . '">';
		foreach ( $this->links as $link ) {
			$output .= '<li><a href="' . $link['permalink'] . '">' . $link['title'] . '</a></li>';
		}
		$output .= '</ul>';
		return $output;
	}
}
                                         plugins/wordpress-seo-extended/src/presenters/webmaster/baidu-presenter.php                         0000644                 00000001132 15122266560 0023415 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Webmaster;

use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Baidu Webmaster Tools verification setting.
 */
class Baidu_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'baidu-site-verification';

	/**
	 * Retrieves the webmaster tool site verification value from the settings.
	 *
	 * @return string The webmaster tool site verification value.
	 */
	public function get() {
		return $this->helpers->options->get( 'baiduverify', '' );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                      plugins/wordpress-seo-extended/src/presenters/webmaster/bing-presenter.php                          0000644                 00000001105 15122266560 0023250 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Webmaster;

use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Bing Webmaster verification setting.
 */
class Bing_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'msvalidate.01';

	/**
	 * Retrieves the webmaster tool site verification value from the settings.
	 *
	 * @return string The webmaster tool site verification value.
	 */
	public function get() {
		return $this->helpers->options->get( 'msverify', '' );
	}
}
                                                                             