.',
		];

		/**
		 * Filter: 'wpseo_json_ld_output' - Allows disabling Yoast's schema output entirely.
		 *
		 * @param mixed  $deprecated If false or an empty array is returned, disable our output.
		 * @param string $empty
		 */
		$return = \apply_filters( 'wpseo_json_ld_output', $deprecated_data, '' );
		if ( $return === [] || $return === false ) {
			return '';
		}

		/**
		 * Action: 'wpseo_json_ld' - Output Schema before the main schema from Yoast SEO is output.
		 */
		\do_action( 'wpseo_json_ld' );

		$schema = $this->get();
		if ( \is_array( $schema ) ) {
			$output = WPSEO_Utils::format_json_encode( $schema );
			$output = \str_replace( "\n", \PHP_EOL . "\t", $output );
			return '<script type="application/ld+json" class="yoast-schema-graph">' . $output . '</script>';
		}

		return '';
	}

	/**
	 * Gets the raw value of a presentation.
	 *
	 * @return array The raw value.
	 */
	public function get() {
		return $this->presentation->schema;
	}
}
                                                        plugins/wordpress-seo-extended/src/presenters/score-icon-presenter.php                              0000644                 00000001660 15122266560 0022407 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters;

/**
 * Presenter class for a score icon.
 */
class Score_Icon_Presenter extends Abstract_Presenter {

	/**
	 * Holds the title.
	 *
	 * @var string
	 */
	protected $title;

	/**
	 * Holds the CSS class.
	 *
	 * @var string
	 */
	protected $css_class;

	/**
	 * Constructs a Score_Icon_Presenter.
	 *
	 * @param string $title     The title and screen reader text.
	 * @param string $css_class The CSS class.
	 */
	public function __construct( $title, $css_class ) {
		$this->title     = $title;
		$this->css_class = $css_class;
	}

	/**
	 * Presents the score icon.
	 *
	 * @return string The score icon.
	 */
	public function present() {
		return \sprintf(
			'<div aria-hidden="true" title="%1$s" class="wpseo-score-icon %3$s"><span class="wpseo-score-text screen-reader-text">%2$s</span></div>',
			\esc_attr( $this->title ),
			\esc_html( $this->title ),
			\esc_attr( $this->css_class )
		);
	}
}
                                                                                plugins/wordpress-seo-extended/src/presenters/slack/enhanced-data-presenter.php                     0000644                 00000004164 15122266560 0024121 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Slack;

use Yoast\WP\SEO\Presentations\Indexable_Presentation;
use Yoast\WP\SEO\Presenters\Abstract_Indexable_Presenter;

/**
 * Presenter class for the Slack enhanced data.
 */
class Enhanced_Data_Presenter extends Abstract_Indexable_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'twitter:misc';

	/**
	 * Presents the enhanced data for Slack
	 *
	 * @return string The Twitter tags for Slack.
	 */
	public function present() {
		$enhanced_data = $this->get();
		$twitter_tags  = '';
		$i             = 1;
		$class         = \is_admin_bar_showing() ? ' class="yoast-seo-meta-tag"' : '';
		foreach ( $enhanced_data as $label => $value ) {
			$twitter_tags .= \sprintf( "\t" . '<meta name="twitter:label%1$d" content="%2$s"' . $class . ' />' . "\n", $i, $label );
			$twitter_tags .= \sprintf( "\t" . '<meta name="twitter:data%1$d" content="%2$s"' . $class . ' />' . "\n", $i, $value );
			++$i;
		}

		return \trim( $twitter_tags );
	}

	/**
	 * Gets the enhanced data array.
	 *
	 * @return array The enhanced data array
	 */
	public function get() {
		$data                   = [];
		$author_id              = $this->presentation->source->post_author;
		$estimated_reading_time = $this-