hod of escaping to use.
	 *
	 * @var string
	 */
	protected $escaping = 'attribute';

	/**
	 * Run the url content through the `wpseo_opengraph_url` filter.
	 *
	 * @return string The filtered url.
	 */
	public function get() {
		/**
		 * Filter: 'wpseo_opengraph_url' - Allow changing the Yoast SEO generated open graph URL.
		 *
		 * @param string                 $url          The open graph URL.
		 * @param Indexable_Presentation $presentation The presentation of an indexable.
		 */
		return \urldecode( (string) \apply_filters( 'wpseo_opengraph_url', $this->presentation->open_graph_url, $this->presentation ) );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                               plugins/wordpress-seo-extended/src/presenters/rel-next-presenter.php                                0000644                 00000003203 15122266560 0022077 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters;

use Yoast\WP\SEO\Presentations\Indexable_Presentation;

/**
 * Presenter class for the rel next meta tag.
 */
class Rel_Next_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'next';

	/**
	 * The tag format including placeholders.
	 *
	 * @var string
	 */
	protected $tag_format = self::LINK_REL_HREF;

	/**
	 * The method of escaping to use.
	 *
	 * @var string
	 */
	protected $escaping = 'url';

	/**
	 * Returns the rel next meta tag.
	 *
	 * @return string The rel next tag.
	 */
	public function present() {
		$output = parent::present();

		if ( ! empty( $output ) ) {
			/**
			 * Filter: 'wpseo_next_rel_link' - Allow changing link rel output by Yoast SEO.
			 *
			 * @param string $unsigned The full `<link` element.
			 */
			return \apply_filters( 'wpseo_next_rel_link', $output );
		}

		return '';
	}

	/**
	 * Run the canonical content through the `wpseo_adjacent_rel_url` filter.
	 *
	 * @return string The filtered adjacent link.
	 */
	public function get() {
		if ( \in_array( 'noindex', $this->presentation->robots, true ) ) {
			return '';
		}

		/**
		 * Filter: 'wpseo_adjacent_rel_url' - Allow filtering of the rel next URL put out by Yoast SEO.
		 *
		 * @param string                 $rel_next     The rel next URL.
		 * @param string                 $rel          Link relationship, prev or next.
		 * @param Indexable_Presentation $presentation The presentation of an indexable.
		 */
		return (string) \trim( \apply_filters( 'wpseo_adjacent_rel_url', $this->presentation->rel_next, 'next', $this->presentation ) );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                             plugins/wordpress-seo-extended/src/presenters/rel-prev-presenter.php                                0000644                 00000003301 15122266560 0022074 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters;

/**
 * Presenter class for the rel prev meta tag.
 */
class Rel_Prev_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'prev';

	/**
	 * The tag format including placeholders.
	 *
	 * @var string
	 */
	protected $tag_format = self::LINK_REL_HREF;

	/**
	 * The method of escaping to use.
	 *
	 * @var string
	 */
	protected $escaping = 'url';

	/**
	 * Returns the rel prev meta tag.
	 *
	 * @param bool $output_tag Optional. Whether or not to output the HTML tag. Defaults to true.
	 *
	 * @return string The rel prev tag.
	 */
	public function present( $output_tag = true ) {
		$output = parent::present();

		if ( ! empty( $output ) ) {
			/**
			 * Filter: 'wpseo_prev_rel_link' - Allow changing link rel output by Yoast SEO.
			 *
			 * @param string $unsigned The full `<link` element.
			 */
			return \apply_filters( 'wpseo_prev_rel_link', $output );
		}

		return '';
	}

	/**
	 * Run the rel prev content through the `wpseo_adjacent_rel_url` filter.
	 *
	 * @return string The filtered adjacent link.
	 */
	public function get() {
		if ( \in_array( 'noindex', $this->presentation->robots, true ) ) {
			return '';
		}

		/**
		 * Filter: 'wpseo_adjacent_rel_url' - Allow filtering of the rel prev URL put out by Yoast SEO.
		 *
		 * @param string                 $canonical    The rel prev URL.
		 * @param string                 $rel          Link relationship, prev or next.
		 * @param Indexable_Presentation $presentation The presentation of an indexable.
		 */
		return (string) \trim( \apply_filters( 'wpseo_adjacent_rel_url', $this->presentation->rel_prev, 'prev', $this->presentation ) );
	}
}
                                                                                                                                                                                                                                                                                                                               plugins/wordpress-seo-extended/src/presenters/robots-presenter.php                                  0000644                 00000001307 15122266560 0021654 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters;

/**
 * Presenter class for the robots output.
 */
class Robots_Presenter extends Abstract_Indexable_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'robots';

	/**
	 * Returns the robots output.
	 *
	 * @return string The robots output tag.
	 */
	public function present() {
		$robots = \implode( ', ', $this->get() );

		if ( \is_string( $robots ) && $robots !== '' ) {
			return \sprintf( '<meta name="robots" content="%s" />', \esc_attr( $robots ) );
		}

		return '';
	}

	/**
	 * Gets the raw value of a presentation.
	 *
	 * @return array The raw value.
	 */
	public function get() {
		return $this->presentation->robots;
	}
}
                                                                                                                                                                                                                                                                                                                         plugins/wordpress-seo-extended/src/presenters/robots-txt-presenter.php                              0000644                 00000010267 15122266560 0022476 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters;

use Yoast\WP\SEO\Helpers\Robots_Txt_Helper;

/**
 * Presenter class for the robots.txt file helper.
 */
class Robots_Txt_Presenter extends Abstract_Presenter {

	public const YOAST_OUTPUT_BEFORE_COMMENT = '# START YOAST BLOCK' . \PHP_EOL . '# ---------------------------' . \PHP_EOL;

	public const YOAST_OUTPUT_AFTER_COMMENT = '# ---------------------------' . \PHP_EOL . '# END YOAST BLOCK';

	/**
	 * Text to be outputted for the allow directive.
	 *
	 * @var string
	 */
	public const ALLOW_DIRECTIVE = 'Allow';

	/**
	 * Text to be outputted for the disallow directive.
	 *
	 * @var string
	 */
	public const DISALLOW_DIRECTIVE = 'Disallow';

	/**
	 * Text to be outputted for the user-agent rule.
	 *
	 * @var string
	 */
	public const USER_AGENT_FIELD = 'User-agent';

	/**
	 * Text to be outputted for the sitemap rule.
	 *
	 * @var string
	 */
	public const SITEMAP_FIELD = 'Sitemap';

	/**
	 * Holds the Robots_Txt_Helper.
	 *
	 * @var Robots_Txt_Helper
	 */
	protected $robots_txt_helper;

	/**
	 * Constructor.
	 *
	 * @param Robots_Txt_Helper $robots_txt_helper The robots txt helper.
	 */
	public function __construct( Robots_Txt_Helper $robots_txt_helper ) {
		$this->robots_txt_helper = $robots_txt_helper;
	}

	/**
	 * Generate content to be placed in a robots.txt file.
	 *
	 * @return string Content to be placed in a robots.txt file.
	 */
	public function present() {
		$robots_txt_content = self::YOAST_OUTPUT_BEFORE_COMMENT;
		$robots_txt_content = $this->handle_user_agents( $robots_txt_content );

		$robots_txt_content = $this->handle_site_maps( $robots_txt_content );

		return $robots_txt_content . self::YOAST_OUTPUT_AFTER_COMMENT;
	}

	/**
	 * Adds user agent directives to the robots txt output string.
	 *
	 * @param array  $user_agents        The list if available user agents.
	 * @param string $robots_txt_content The current working robots txt string.
	 *
	 * @return string
	 */
	private function add_user_agent_directives( $user_agents, $robots_txt_content ) {
		foreach ( $user_agents as $user_agent ) {
			$robots_txt_content .= self::USER_AGENT_FIELD . ': ' . $user_agent->get_user_agent() . \PHP_EOL;

			$robots_txt_content = $this->add_directive_path( $robots_txt_content, $user_agent->get_disallow_paths(), self::DISALLOW_DIRECTIVE );
			$robots_txt_content = $this->add_directive_path( $robots_txt_content, $user_agent->get_allow_paths(), self::ALLOW_DIRECTIVE );

			$robots_txt_content .= \PHP_EOL;
		}

		return $robots_txt_content;
	}

	/**
	 *  Adds user agent directives path content to the robots txt output string.
	 *
	 * @param string $robots_txt_content   The current working robots txt string.
	 * @param array  $paths                The list of paths for which to add a txt entry.
	 * @param string $directive_identifier The identifier for the directives. (Disallow of Allow).
	 *
	 * @return string
	 */
	private function add_directive_path( $robots_txt_content, $paths, $directive_identifier ) {
		if ( \count( $paths ) > 0 ) {
			foreach ( $paths as $path ) {
				$robots_txt_content .= $directive_identifier . ': ' . $path . \PHP_EOL;
			}
		}

		return $robots_txt_content;
	}

	/**
	 * Handles adding user agent content to the robots txt content if there is any.
	 *
	 * @param string $robots