	return $output;
		}

		if ( \current_user_can( 'wpseo_manage_options' ) ) {
			return '<!-- '
				. \sprintf(
					/* translators: %1$s resolves to Yoast SEO, %2$s resolves to the Settings submenu item. */
					\esc_html__( 'Admin only notice: this page does not show a meta description because it does not have one, either write it for this page specifically or go into the [%1$s - %2$s] menu and set up a template.', 'wordpress-seo' ),
					\esc_html__( 'Yoast SEO', 'wordpress-seo' ),
					\esc_html__( 'Settings', 'wordpress-seo' )
				)
				. ' -->';
		}

		return '';
	}

	/**
	 * Run the meta description content through replace vars, the `wpseo_metadesc` filter and sanitization.
	 *
	 * @return string The filtered meta description.
	 */
	public function get() {
		$meta_description = $this->replace_vars( $this->presentation->meta_description );

		/**
		 * Filter: 'wpseo_metadesc' - Allow changing the Yoast SEO meta description sentence.
		 *
		 * @param string                 $meta_description The description sentence.
		 * @param Indexable_Presentation $presentation     The presentation of an indexable.
		 */
		$meta_description = \apply_filters( 'wpseo_metadesc', $meta_description, $this->presentation );
		$meta_description = $this->helpers->string->strip_all_tags( \stripslashes( $meta_description ) );
		return \trim( $meta_description );
	}
}
                                                                                                                                                                       plugins/wordpress-seo-extended/src/presenters/open-graph/article-author-presenter.php               0000644                 00000002251 15122266560 0025326 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Open_Graph;

use Yoast\WP\SEO\Presentations\Indexable_Presentation;
use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Open Graph article author.
 */
class Article_Author_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'article:author';

	/**
	 * The tag format including placeholders.
	 *
	 * @var string
	 */
	protected $tag_format = self::META_PROPERTY_CONTENT;

	/**
	 * Run the article author's Facebook URL through the `wpseo_opengraph_author_facebook` filter.
	 *
	 * @return string The filtered article author's Facebook URL.
	 */
	public function get() {
		/**
		 * Filter: 'wpseo_opengraph_author_facebook' - Allow developers to filter the article author's Facebook URL.
		 *
		 * @param bool|string            $article_author The article author's Facebook URL, return false to disable.
		 * @param Indexable_Presentation $presentation   The presentation of an indexable.
		 */
		return \trim( \apply_filters( 'wpseo_opengraph_author_facebook', $this->presentation->open_graph_article_author, $this->presentation ) );
	}
}
                                                                                                                                                                                                                                                                                                                                                       plugins/wordpress-seo-extended/src/presenters/open-graph/article-modified-time-presenter.php        0000644                 00000001244 15122266560 0026541 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Open_Graph;

use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Open Graph article modified time.
 */
class Article_Modified_Time_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'article:modified_time';

	/**
	 * The tag format including placeholders.
	 *
	 * @var string
	 */
	protected $tag_format = self::META_PROPERTY_CONTENT;

	/**
	 * Gets the raw value of a presentation.
	 *
	 * @return string The raw value.
	 */
	public function get() {
		return $this->presentation->open_graph_article_modified_time;
	}
}
                                                                                                                                                                                                                                                                                                                                                            plugins/wordpress-seo-extended/src/presenters/open-graph/article-published-time-presenter.php       0000644                 00000001250 15122266560 0026735 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Open_Graph;

use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Open Graph article published time.
 */
class Article_Published_Time_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'article:published_time';

	/**
	 * The tag format including placeholders.
	 *
	 * @var string
	 */
	protected $tag_format = self::META_PROPERTY_CONTENT;

	/**
	 * Gets the raw value of a presentation.
	 *
	 * @return string The raw value.
	 */
	public function get() {
		return $this->presentation->open_graph_article_published_time;
	}
}
                                                                                                                                                                                                                                                                                                                                                        plugins/wordpress-seo-extended/src/presenters/open-graph/article-publisher-presenter.php            0000644                 00000002270 15122266560 0026022 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Open_Graph;

use Yoast\WP\SEO\Presentations\Indexable_Presentation;
use Yoast\WP\SEO\Presenters\Abstract_Indexable_Tag_Presenter;

/**
 * Presenter class for the Open Graph article publisher.
 */
class Article_Publisher_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'article:publisher';

	/**
	 * The tag format including placeholders.
	 *
	 * @var string
	 */
	protected $tag_format = self::META_PROPERTY_CONTENT;

	/**
	 * Run the article publisher's Facebook URL through the `wpseo_og_art