<?php

namespace Yoast\WP\SEO\Presenters\Debug;

use Yoast\WP\SEO\Presenters\Abstract_Indexable_Presenter;

/**
 * Presenter class for the debug close marker.
 */
final class Marker_Close_Presenter extends Abstract_Indexable_Presenter {

	/**
	 * Returns the debug close marker.
	 *
	 * @return string The debug close marker.
	 */
	public function present() {
		/**
		 * Filter: 'wpseo_debug_markers' - Allow disabling the debug markers.
		 *
		 * @param bool $show_markers True when the debug markers should be shown.
		 */
		if ( ! \apply_filters( 'wpseo_debug_markers', true ) ) {
			return '';
		}

		return \sprintf(
			'<!-- / %s. -->',
			\esc_html( $this->helpers->product->get_name() )
		);
	}

	/**
	 * Gets the raw value of a presentation.
	 *
	 * @return string The raw value.
	 */
	public function get() {
		return '';
	}
}
                                                                                                                                                                                           plugins/wordpress-seo-extended/src/presenters/debug/marker-open-presenter.php                       0000644                 00000003132 15122266560 0023650 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Debug;

use Yoast\WP\SEO\Presenters\Abstract_Indexable_Presenter;

/**
 * Presenter class for the debug open marker.
 */
final class Marker_Open_Presenter extends Abstract_Indexable_Presenter {

	/**
	 * Returns the debug close marker.
	 *
	 * @return string The debug close marker.
	 */
	public function present() {
		/**
		 * Filter: 'wpseo_debug_markers' - Allow disabling the debug markers.
		 *
		 * @param bool $show_markers True when the debug markers should be shown.
		 */
		if ( ! \apply_filters( 'wpseo_debug_markers', true ) ) {
			return '';
		}
		$version_info = 'v' . \WPSEO_VERSION;

		if ( $this->helpers->product->is_premium() ) {
			$version_info = $this->construct_version_info();
		}

		return \sprintf(
			'<!-- This site is optimized with the %1$s %2$s - https://yoast.com/wordpress/plugins/seo/ -->',
			\esc_html( $this->helpers->product->get_name() ),
			$version_info
		);
	}

	/**
	 * Gets the plugin version information, including the free version if Premium is used.
	 *
	 * @return string The constructed version information.
	 */
	private function construct_version_info() {
		/**
		 * Filter: 'wpseo_hide_version' - can be used to hide the Yoast SEO version in the debug marker (only available in Yoast SEO Premium).
		 *
		 * @param bool $hide_version
		 */
		if ( \apply_filters( 'wpseo_hide_version', false ) ) {
			return '';
		}

		return 'v' . \WPSEO_PREMIUM_VERSION . ' (Yoast SEO v' . \WPSEO_VERSION . ')';
	}

	/**
	 * Gets the raw value of a presentation.
	 *
	 * @return string The raw value.
	 */
	public function get() {
		return '';
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                      plugins/wordpress-seo-extended/src/presenters/meta-author-presenter.php                             0000644                 00000002541 15122266560 0022573 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters;

use WP_User;
use Yoast\WP\SEO\Presentations\Indexable_Presentation;

/**
 * Presenter class for the meta author tag.
 */
class Meta_Author_Presenter extends Abstract_Indexable_Tag_Presenter {

	/**
	 * The tag key name.
	 *
	 * @var string
	 */
	protected $key = 'author';

	/**
	 * Returns the author for a post in a meta author tag.
	 *
	 * @return string The meta author tag.
	 */
	public function present() {
		$output = parent::present();

		if ( ! empty( $output ) ) {
			return $output;
		}

		return '';
	}

	/**
	 * Get the author's display name.
	 *
	 * @return string The author's display name.
	 */
	public function get() {
		if ( $this->presentation->model->object_sub_type !== 'post' ) {
			return '';
		}

		$user_data = \get_userdata( $this->presentation->context->post->post_author );

		if ( ! $user_data instanceof WP_User ) {
			return '';
		}

		/**
		 * Filter: 'wpseo_meta_author' - Allow developers to filter the article's author meta tag.
		 *
		 * @param string                 $author_name  The article author's display name. Return empty to disable the tag.
		 * @param Indexable_Presentation $presentation The presentation of an indexable.
		 */
		return \trim( $this->helpers->schema->html->smart_strip_tags( \apply_filters( 'wpseo_meta_author', $user_data->display_name, $this->presentation ) ) );
	}
}
                                                                                                                                                               plugins/wordpress-seo-extended/src/presenters/meta-description-presenter.php                        0000644                 00000003531 15122266560 0023614 0                                                                                                    ustar 00                                                                                                                                                                                    