 '">';
		$out .= '<div class="notice-yoast__container">';

		// Header.
		$out .= '<div>';
		$out .= '<div class="notice-yoast__header">';
		$out .= '<span class="yoast-icon"></span>';
		$out .= \sprintf(
			'<h2 class="notice-yoast__header-heading">%s</h2>',
			\esc_html( $this->title )
		);
		$out .= '</div>';
		$out .= '<p>' . $this->content . '</p>';
		if ( ! \is_null( $this->button ) ) {
			$out .= '<p>' . $this->button . '</p>';
		}
		$out .= '</div>';

		if ( ! \is_null( $this->image_filename ) ) {
			$out .= '<img src="' . \esc_url( \plugin_dir_url( \WPSEO_FILE ) . 'images/' . $this->image_filename ) . '" alt="" height="60" width="75"/>';
		}

		$out .= '</div>';
		$out .= '</div>';

		return $out;
	}
}
                                                                                                                                                                                                                                                                                                               plugins/wordpress-seo-extended/src/presenters/admin/premium-badge-presenter.php                     0000644                 00000002510 15122266560 0024147 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Admin;

use Yoast\WP\SEO\Presenters\Abstract_Presenter;

/**
 * Represents the presenter class for "Premium" badges.
 */
class Premium_Badge_Presenter extends Abstract_Presenter {

	/**
	 * Identifier of the badge.
	 *
	 * @var string
	 */
	private $id;

	/**
	 * Optional link of the badge.
	 *
	 * @var string
	 */
	private $link;

	/**
	 * Premium_Badge_Presenter constructor.
	 *
	 * @param string $id   Id of the badge.
	 * @param string $link Optional link of the badge.
	 */
	public function __construct( $id, $link = '' ) {
		$this->id   = $id;
		$this->link = $link;
	}

	/**
	 * Presents the Premium Badge. If a link has been passed, the badge is presented with the link.
	 * Otherwise a static badge is presented.
	 *
	 * @return string The styled Premium Badge.
	 */
	public function present() {
		if ( $this->link !== '' ) {
			return \sprintf(
				'<a class="yoast-badge yoast-badge__is-link yoast-premium-badge" id="%1$s-premium-badge" href="%2$s">%3$s</a>',
				\esc_attr( $this->id ),
				\esc_url( $this->link ),
				'Premium' // We don't want this string to be translatable.
			);
		}

		return \sprintf(
			'<span class="yoast-badge yoast-premium-badge" id="%1$s-premium-badge">%2$s</span>',
			\esc_attr( $this->id ),
			'Premium' // We don't want this string to be translatable.
		);
	}
}
                                                 