<?php

namespace Yoast\WP\SEO\Presenters\Admin;

use WP_Post;
use WPSEO_Meta;
use Yoast\WP\SEO\Presenters\Abstract_Presenter;

/**
 * Presenter class for meta fields in the post editor.
 *
 * Outputs the hidden fields for a particular field group and post.
 */
class Meta_Fields_Presenter extends Abstract_Presenter {

	/**
	 * The meta fields for which we are going to output hidden input.
	 *
	 * @var array
	 */
	private $meta_fields;

	/**
	 * The metabox post.
	 *
	 * @var WP_Post The metabox post.
	 */
	private $post;

	/**
	 * Meta_Fields_Presenter constructor.
	 *
	 * @param WP_Post $post        The metabox post.
	 * @param string  $field_group The key under which a group of fields is grouped.
	 * @param string  $post_type   The post type.
	 */
	public function __construct( $post, $field_group, $post_type = 'post' ) {
		$this->post        = $post;
		$this->meta_fields = WPSEO_Meta::get_meta_field_defs( $field_group, $post_