k_attribute = '';
		$new_tab_message        = '';

		if ( $this->opens_in_new_browser_tab ) {
			$target_blank_attribute = ' target="_blank"';
			/* translators: Hidden accessibility text. */
			$new_tab_message = ' ' . \__( '(Opens in a new browser tab)', 'wordpress-seo' );
		}

		return \sprintf(
			'<a href="%1$s"%2$s class="yoast_help yoast-help-link dashicons"><span class="yoast-help-icon" aria-hidden="true"></span><span class="screen-reader-text">%3$s</span></a>',
			\esc_url( $this->link ),
			$target_blank_attribute,
			\esc_html( $this->link_text . $new_tab_message )
		);
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                               plugins/wordpress-seo-extended/src/presenters/admin/indexing-error-presenter.php                    0000644                 00000010463 15122266560 0024373 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Admin;

use WPSEO_Addon_Manager;
use Yoast\WP\SEO\Helpers\Product_Helper;
use Yoast\WP\SEO\Helpers\Short_Link_Helper;
use Yoast\WP\SEO\Presenters\Abstract_Presenter;

/**
 * An error that should be shown when indexation has failed.
 */
class Indexing_Error_Presenter extends Abstract_Presenter {

	/**
	 * The short link helper.
	 *
	 * @var Short_Link_Helper
	 */
	protected $short_link_helper;

	/**
	 * The product helper
	 *
	 * @var Product_Helper
	 */
	protected $product_helper;

	/**
	 * The addon manager.
	 *
	 * @var WPSEO_Addon_Manager
	 */
	protected $addon_manager;

	/**
	 * Indexing_Error_Presenter constructor.
	 *
	 * @param Short_Link_Helper   $short_link_helper Represents the short link helper.
	 * @param Product_Helper      $product_helper    The product helper.
	 * @param WPSEO_Addon_Manager $addon_manager     The addon manager.
	 */
	public function __construct(
		Short_Link_Helper $short_link_helper,
		Product_Helper $product_helper,
		WPSEO_Addon_Manager $addon_manager
	) {
		$this->short_link_helper = $short_link_helper;
		$this->product_helper    = $product_helper;
		$this->addon_manager     = $addon_manager;
	}

	/**
	 * Generates the first paragraph of the error message to show when indexing failed.
	 *
	 * The contents of the paragraph varies based on whether WordPress SEO Premium has a valid, activated subscription or not.
	 *
	 * @param bool $is_premium                     Whether WordPress SEO Premium is currently active.
	 * @param bool $has_valid_premium_subscription Whether WordPress SEO Premium currently has a valid subscription.
	 *
	 * @return string
	 */
	protected function generate_first_paragraph( $is_premium, $has_valid_premium_subscription ) {
		$message = \__(
			'Oops, something has gone wrong and we couldn\'t complete the optimization of your SEO data. Please click the button again to re-start the process. ',
			'wordpress-seo'
		);

		if ( $is_premium ) {
			if ( $has_valid_premium_subscription ) {
				$message .= \__( 'If the problem persists, please contact support.', 'wordpress-seo' );
			}
			else {
				$message = \sprintf(
					/* translators: %1$s expands to an opening anchor tag for a link leading to the Premium installation page, %2$s expands to a closing anchor tag. */
					\__(
						'Oops, something has gone wrong and we couldn\'t complete the optimization of your SEO data. Please make sure to activate your subscription in MyYoast by completing %1$sthese steps%2$s.',
						'wordpress-seo'
					),
					'<a href="' . \esc_url( $this->short_link_helper->get( 'https://yoa.st/3wv' ) ) . '">',
					'</a>'
				);
			}
		}

		return $message;
	}

	/**
	 * Generates the second paragraph of the error message to show when indexing failed.
	 *
	 * The error message varies based on whether WordPress SEO Premium has a valid, activated subscription or not.
	 *
	 * @param bool $is_premium                     Whether WordPress SEO Premium is currently active.
	 * @param bool $has_valid_premium_subscription Whether WordPress SEO Premium currently has a valid subscription.
	 *
	 * @return string The second paragraph of the error message.
	 */
	protected function generate_second_paragraph( $is_premium, $has_valid_premium_subscription ) {
		return \sprintf(
			/* translators: %1$s expands to an opening anchor tag for a link leading to the Premium installation page, %2$s expands to a closing anchor tag. */
			\__(
				'Below are the technical details for the error. See %1$sthis page%2$s for a more detailed explanation.',
				'wordpress-seo'
			),
			'<a href="' . \esc_url( $this->short_link_helper->get( 'https://yoa.st/4f3' ) ) . '">',
			'</a>'
		);
	}

	/**
	 * Presents the error message to show if SEO optimization failed.
	 *
	 * The error message varies based on whether WordPress SEO Premium has a valid, activated subscription or not.
	 *
	 * @return string The error message to show.
	 */
	public function present() {
		$is_premium                     = $this->product_helper->is_premium();
		$has_valid_premium_subscription = $this->addon_manager->has_valid_subscription( WPSEO_Addon_Manager::PREMIUM_SLUG );

		$output  = '<p>' . $this->generate_first_paragraph( $is_premium, $has_valid_premium_subscription ) . '</p>';
		$output .= '<p>' . $this->generate_second_paragraph( $is_premium, $has_valid_premium_subscription ) . '</p>';

		return $output;
	}
}
                                                                                                                                                                                                             plugins/wordpress-seo-extended/src/presenters/admin/indexing-failed-notification-presenter.php      0000644                 00000005764 15122266560 0027162 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presenters\Admin;

use WPSEO_Addon_Manager;
use Yoast\WP\SEO\Helpers\Product_Helper;
use Yoast\WP\SEO\Helpers\Short_Link_Helper;
use Yoast\WP\SEO\Presenters\Abstract_Presenter;

/**
 * Class Indexing_Failed_Notification_Presenter.
 *
 * @package Yoast\WP\SEO\Presenters\Notifications
 */
class Indexing_Failed_Notification_Presenter extends Abstract_Presenter {

	/**
	 * The product helper.
	 *
	 * @var Product_Helper
	 */
	protected $product_helper;

	/**
	 * The addon manager.
	 *
	 * @var WPSEO_Addon_Manager
	 */
	protected $class_addon_manager;

	/**
	 * The short link helper.
	 *
	 * @var Short_Link_Helper
	 */
	protected $short_link_helper;

	/**
	 * Indexing_Failed_Notification_Presenter constructor.
	 *
	 * @param Product_Helper      $product_helper      The product helper.
	 * @param Short_Link_Helper   $short_link_helper   The addon manager.
	 * @param WPSEO_Addon_Manager $class_addon_manager The addon manager.
	 */
	public function __construct( $product_helper, $short_link_helper, $class_addon_manager ) {
		$this->class_addon_manager = $class_addon_manager;
		$this->short_link_helper   = $short_link_helper;
		$this->product_helper      = $product_helper;
	}

	/**
	 * Returns the notification as an HTML string.
	 *
	 * @return string The notification in an HTML string representation.
	 */
	public function present() {
		$notification_text = \sprintf(
			/* Translators: %1$s expands to an opening anchor tag for a link leading to the Yoast SEO tools page, %2$s expands to a closing anchor tag. */
			\esc_html__(
				'Something has gone wrong and we couldn\'t complete the optimization of your SEO data. Please %1$sre-start the process%2$s.',
				'wordpress-seo'
			),
			'<a href="' . \get_admin_url( null, 'admin.p