led === true ) {
			$social_template_description = $this->values_helper->get_open_graph_description( '', $this->model->object_type, $this->model->object_sub_type );
			$open_graph_description      = $this->open_graph_description;

			// If the helper returns a value and it's different from the OG value in the indexable,
			// output it in a twitter: tag.
			if ( ! empty( $social_template_description ) && $social_template_description !== $open_graph_description ) {
				return $social_template_description;
			}

			// If the OG description is set, let og: tag take care of this.
			if ( ! empty( $open_graph_description ) ) {
				return '';
			}
		}

		if ( $this->meta_description ) {
			return $this->meta_description;
		}

		return '';
	}

	/**
	 * Generates the Twitter image.
	 *
	 * @return string The Twitter image.
	 */
	public function generate_twitter_image() {
		$images = $this->twitter_image_generator->generate( $this->context );
		$image  = \reset( $images );

		// Use a user-defined Twitter image, if present.
		if ( $image && $this->context->indexable->twitter_image_source === 'set-by-user' ) {
			return $image['url'];
		}

		// Let the Open Graph tags, if enabled, handle the rest of the fallback hierarchy.
		if ( $this->context->open_graph_enabled === true && $this->open_graph_images ) {
			return '';
		}

		// Set a Twitter tag with the featured image, or a prominent image from the content, if present.
		if ( $image ) {
			return $image['url'];
		}

		return '';
	}

	/**
	 * Generates the Twitter creator.
	 *
	 * @return string The Twitter creator.
	 */
	public function generate_twitter_creator() {
		return '';
	}

	/**
	 * Generates the Twitter site.
	 *
	 * @return string The Twitter site.
	 */
	public function generate_twitter_site() {
		switch ( $this->context->site_represents ) {
			case 'person':
				$twitter = $this->user->get_the_author_meta( 'twitter', (int) $this->context->site_user_id );
				if ( empty( $twitter ) ) {
					$twitter = $this->options->get( 'twitter_site' );
				}
				break;
			case 'company':
			default:
				$twitter = $this->options->get( 'twitter_site' );
				break;
		}

		return $twitter;
	}

	/**
	 * Generates the source.
	 *
	 * @return array The source.
	 */
	public function generate_source() {
		return [];
	}

	/**
	 * Generates the schema for the page.
	 *
	 * @codeCoverageIgnore Wrapper method.
	 *
	 * @return array The Schema object.
	 */
	public function generate_schema() {
		return $this->schema_generator->generate( $this->context );
	}

	/**
	 * Generates the breadcrumbs for the page.
	 *
	 * @codeCoverageIgnore Wrapper method.
	 *
	 * @return array The breadcrumbs.
	 */
	public function generate_breadcrumbs() {
		return $this->breadcrumbs_generator->generate( $this->context );
	}

	/**
	 * Generates the estimated reading time.
	 *
	 * @codeCoverage