scription = $this->values_helper->get_open_graph_description( '', $this->model->object_type, $this->model->object_sub_type );
		}

		if ( empty( $open_graph_description ) ) {
			$open_graph_description = $this->meta_description;
		}

		return $open_graph_description;
	}

	/**
	 * Generates the open graph images.
	 *
	 * @return array The open graph images.
	 */
	public function generate_open_graph_images() {
		if ( $this->context->open_graph_enabled === false ) {
			return [];
		}

		return $this->open_graph_image_generator->generate( $this->context );
	}

	/**
	 * Generates the open graph image ID.
	 *
	 * @return string The open graph image ID.
	 */
	public function generate_open_graph_image_id() {
		if ( $this->model->open_graph_image_id ) {
			return $this->model->open_graph_image_id;
		}

		return $this->values_helper->get_open_graph_image_id( 0, $this->model->object_type, $this->model->object_sub_type );
	}

	/**
	 * Generates the open graph image URL.
	 *
	 * @return string The open graph image URL.
	 */
	public function generate_open_graph_image() {
		if ( $this->model->open_graph_image ) {
			return $this->model->open_graph_image;
		}

		return $this->values_helper->get_open_graph_image( '', $this->model->object_type, $this->model->object_sub_type );
	}

	/**
	 * Generates the open graph url.
	 *
	 * @return string The open graph url.
	 */
	public function generate_open_graph_url() {
		if ( $this->model->canonical ) {
			return $this->model->canonical;
		}

		return $this->permalink;
	}

	/**
	 * Generates the open graph article publisher.
	 *
	 * @return string The open graph article publisher.
	 */
	public function generate_open_graph_article_publisher() {
		return '';
	}

	/**
	 * Generates the open graph article author.
	 *
	 * @return string The open graph article author.
	 */
	public function generate_open_graph_article_author() {
		return '';
	}

	/**
	 * Generates the open graph article published time.
	 *
	 * @return string The open graph article published time.
	 */
	public function generate_open_graph_article_published_time() {
		return '';
	}

	/**
	 * Generates the open graph article modified time.
	 *
	 * @return string The open graph article modified time.
	 */
	public function generate_open_graph_article_modified_time() {
		return '';
	}

	/**
	 * Generates the open graph locale.
	 *
	 * @return string The open graph locale.
	 */
	public function generate_open_graph_locale() {
		return $this->open_graph_locale_generator->generate( $this->context );
	}

	/**
	 * Generates the open graph site name.
	 *
	 * @return string The open graph site name.
	 */
	public function generate_open_graph_site_name() {
		return $this->context->wordpress_site_name;
	}

	/**
	 * Generates the Twitter card type.
	 *
	 * @return string The Twitter card type.
	 */
	public function generate_twitter_card() {
		return $this->context->twitter_card;
	}

	/**
	 * Generates the Twitter title.
	 *
	 * @return string The Twitter title.
	 */
	public function generate_twitter_title() {
		if ( $this->model->twitter_title ) {
			return $this->model->twitter_title;
		}

		if ( $this->context->open_graph_enabled === true ) {
			$social_template_title = $this->values_helper->get_open_graph_title( '', $this->model->object_type, $this->model->object_sub_type );
			$open_graph_title      = $this->open_graph_title;

			// If the helper returns a value and it's different from the OG value in the indexable,
			// output it in a twitter: tag.
			if ( ! empty( $social_template_title ) && $social_template_title !== $open_graph_titl