nt_page ) {
			return '';
		}

		return $this->get_paginated_url( $this->model->permalink, ( $current_page + 1 ) );
	}

	/**
	 * Generates the open graph title.
	 *
	 * @return string The open graph title.
	 */
	public function generate_title() {
		if ( $this->model->title ) {
			return $this->model->title;
		}

		// Get SEO title as entered in Search appearance.
		$post_type = $this->model->object_sub_type;
		$title     = $this->options->get( 'title-' . $this->model->object_sub_type );
		if ( $title ) {
			return $title;
		}

		// Get installation default title.
		return $this->options->get_title_default( 'title-' . $post_type );
	}

	/**
	 * Generates the meta description.
	 *
	 * @return string The meta description.
	 */
	public function generate_meta_description() {
		if ( $this->model->description ) {
			return $this->model->description;
		}

		return $this->options->get( 'metadesc-' . $this->model->object_sub_type );
	}

	/**
	 * Generates the open graph description.
	 *
	 * @return string The open graph description.
	 */
	public function generate_open_graph_description() {
		if ( $this->model->open_graph_description ) {
			$open_graph_description = $this->model->open_graph_description;
		}

		if ( empty( $open_graph_description ) ) {
			// The helper applies a filter, but we don't have a default value at this stage so we pass an empty string.
			$open_graph_description = $this->values_helper->get_open_graph_description( '', $this->model->object_type, $this->model->object_sub_type );
		}

		if ( empty( $open_graph_description ) ) {
			$open_graph_description = $this->meta_description;
		}

		if ( empty( $open_graph_description ) ) {
			$open_graph_description = $this->post->get_the_excerpt( $this->model->object_id );
			$open_graph_description = $this->post->strip_shortcodes( $open_graph_description );
		}

		return $open_graph_description;
	}

	/**
	 * Generates the open graph images.
	 *
	 * @return array The open graph images.
	 */
	public function generate_open_graph_images() {
		if ( \post_password_required() ) {
			return [];
		}

		return parent::generate_open_graph_images();
	}

	/**
	 * Generates the Open Graph type.
	 *
	 * @return string The Open Graph type.
	 */
	public function generate_open_graph_type() {
		return 'article';
	}

	/**
	 * Generates the open graph article author.
	 *
	 * @return string The open graph article author.
	 */
	public function generate_open_graph_article_author() {
		if ( $this->model->object_sub_type !== 'post' ) {
			return '';
		}

		$post = $this->source;

		$open_graph_article_author = $this->user->get_the_author_meta( 'facebook', $post->post_author );

		if ( $open_graph_article_author ) {
			return $open_graph_article_aut