instance.
	 *
	 * @var Date_Helper
	 */
	protected $date;

	/**
	 * Holds the Pagination_Helper instance.
	 *
	 * @var Pagination_Helper
	 */
	protected $pagination;

	/**
	 * Holds the Post_Helper instance.
	 *
	 * @var Post_Helper
	 */
	protected $post;

	/**
	 * Indexable_Post_Type_Presentation constructor.
	 *
	 * @codeCoverageIgnore
	 *
	 * @param Post_Type_Helper  $post_type  The post type helper.
	 * @param Date_Helper       $date       The date helper.
	 * @param Pagination_Helper $pagination The pagination helper.
	 * @param Post_Helper       $post       The post helper.
	 */
	public function __construct(
		Post_Type_Helper $post_type,
		Date_Helper $date,
		Pagination_Helper $pagination,
		Post_Helper $post
	) {
		$this->post_type  = $post_type;
		$this->date       = $date;
		$this->pagination = $pagination;
		$this->post       = $post;
	}

	/**
	 * Generates the canonical.
	 *
	 * @return string The canonical.
	 */
	public function generate_canonical() {
		if ( $this->model->canonical ) {
			return $this->model->canonical;
		}

		$permalink = $this->permalink;

		// Fix paginated pages canonical, but only if the page is truly paginated.
		$current_page = $this->pagination->get_current_post_page_number();
		if ( $current_page > 1 ) {
			$number_of_pages = $this->model->number_of_pages;
			if ( $number_of_pages && $current_page <= $number_of_pages ) {
				$permalink = $this->get_paginated_url( $permalink, $current_page );
			}
		}

		return $this->url->ensure_absolute_url( $permalink );
	}

	/**
	 * Generates the rel prev.
	 *
	 * @return string The rel prev value.
	 */
	public function generate_rel_prev() {
		if ( $this->model->number_of_pages === null ) {
			return '';
		}

		if ( $this->pagination->is_rel_adjacent_disabled() ) {
			return '