 set.
	 *
	 * @var array
	 */
	public $parsed_url;

	/**
	 * Which columns contain int values.
	 *
	 * @var array
	 */
	protected $int_columns = [
		'id',
		'post_id',
		'target_post_id',
		'indexable_id',
		'target_indexable_id',
		'height',
		'width',
		'size',
	];
}
                                                                                                                                                                                                                                                  plugins/wordpress-seo-extended/src/models/seo-meta.php                                              0000644                 00000001030 15122266560 0017133 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Models;

use Yoast\WP\Lib\Model;

/**
 * Table definition for the SEO Meta table.
 *
 * @property int $object_id
 * @property int $internal_link_count
 * @property int $incoming_link_count
 */
class SEO_Meta extends Model {

	/**
	 * Overwrites the default ID column name.
	 *
	 * @var string
	 */
	public static $id_column = 'object_id';

	/**
	 * Which columns contain int values.
	 *
	 * @var array
	 */
	protected $int_columns = [
		'object_id',
		'internal_link_count',
		'incoming_link_count',
	];
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        plugins/wordpress-seo-extended/src/presentations/abstract-presentation.php                          0000644                 00000004530 15122266560 0023360 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Presentations;

use AllowDynamicProperties;
use Exception;

/**
 * The abstract presentation class.
 */
#[AllowDynamicProperties]
class Abstract_Presentation {

	/**
	 * The model.
	 *
	 * @var mixed
	 */
	public $model;

	/**
	 * Whether or not there is a presentation prototype.
	 *
	 * @var bool
	 */
	private $is_prototype = true;

	/**
	 * Creates a model presentation.
	 *
	 * @param array $data The data that this is a presentation of.
	 *
	 * @return static A model presentation.
	 *
	 * @throws Exception If attempting to create a model presentation from another model presentation.
	 */
	public function of( $data ) {
		if ( ! $this->is_prototype() ) {
			throw new Exception( 'Attempting to create a model presentation from another model presentation. Use the prototype presentation gained from DI instead.' );
		}

		// Clone self to allow stateful services that do benefit from DI.
		$presentation = clone $this;
		foreach ( $data as $key => $value ) {
			$presentation->{$key} = $value;
		}
		$presentation->is_prototype = false;
		return $presentation;
	}

	/**
	 * Magic getter for lazy loading of generate functions.
	 *
	 * @param string $name The property to get.
	 *
	 * @return mixed The value if it could be generated.
	 *
	 * @throws Exception If there is no generator for the property.
	 */
	public function __get( $name ) {
		if ( $this->is_prototype() ) {
			throw new Exception( 'Attempting property access on prototype presentation. Use Presentation::of( $data ) to get a model presentation.' );
		}
		$generator = "generate_$name";
		if ( \method_exists( $this, $generator ) ) {
			$this->{$name} = $this->$generator();
			return $this->{$name};
		}
		throw new Exception( "Property $name has no generator. Expected function $generator." );
	}

	/**
	 * Magic isset for ensuring methods that have a generator are recognised.
	 *
	 * @codeCoverageIgnore Wrapper method.
	 *
	 * @param string $name The property to get.
	 *
	 * @return bool Whether or not there is a generator for the requested property.
	 */
	public function __isset( $name ) {
		return \method_exists( $this, "generate_$name" );
	}

	/**
	 * Returns `true` if this class is a prototype.
	 *
	 * @codeCoverageIgnore Wrapper method.
	 *
	 * @return bool If this class is a prototype or not.
	 */
	protected function is_prototype() {
		return $this->is_prototype;
	}
}
                                                                                                                                                                        plugins/wordpress-seo-extended/src/presentations/archive-adjacent-trait.php                         0000644                 00000003235 15122266560 0023356 0                                                                                                    ustar 00                                                                                                                                                                             