

			if ( ! $presentation ) {
				$presentation = $this->container->get( Indexable_Presentation::class );
			}

			$context->presentation = $presentation->of(
				[
					'model'   => $indexable,
					'context' => $context,
				]
			);

			$this->cache[ $indexable->id ] = $context->presentation;
		}

		return $this->cache[ $indexable->id ];
	}

	/**
	 * Clears the memoization of either a specific indexable or all indexables.
	 *
	 * @param Indexable|int|null $indexable Optional. The indexable or indexable id to clear the memoization of.
	 *
	 * @return void
	 */
	public function clear( $indexable = null ) {
		if ( $indexable instanceof Indexable ) {
			unset( $this->cache[ $indexable->id ] );
			return;
		}
		if ( \is_int( $indexable ) ) {
			unset( $this->cache[ $indexable ] );
			return;
		}
		if ( $indexable === null ) {
			$this->cache = [];
		}
	}
}
                                                                                                                                                              plugins/wordpress-seo-extended/src/models/indexable-extension.php                                   0000644                 00000001065 15122266560 0021376 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Models;

use Yoast\WP\Lib\Model;

/**
 * Abstract class for indexable extensions.
 */
abstract class Indexable_Extension extends Model {

	/**
	 * Holds the Indexable instance.
	 *
	 * @var Indexable
	 */
	protected $indexable = null;

	/**
	 * Returns the indexable this extension belongs to.
	 *
	 * @return Indexable The indexable.
	 */
	public function indexable() {
		if ( $this->indexable === null ) {
			$this->indexable = $this->belongs_to( 'Indexable', 'indexable_id', 'id' )->find_one();
		}

		return $this->indexable;
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                           plugins/wordpress-seo-extended/src/models/indexable-hierarchy.php                                   0000644                 00000001111 15122266560 0021330 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Models;

use Yoast\WP\Lib\Model;

/**
 * Indexable Hierarchy model definition.
 *
 * @property int $indexable_id The ID of the indexable.
 * @property int $ancestor_id  The ID of the indexable's ancestor.
 * @property int $depth        The depth of the ancestry. 1 being a parent, 2 being a grandparent etc.
 * @property int $blog_id      Blog ID.
 */
class Indexable_Hierarchy extends Model {

	/**
	 * Which columns contain int values.
	 *
	 * @var array
	 */
	protected $int_columns = [
		'indexable_id',
		'ancestor_id',
		'depth',
		'blog_id',
	];
}
                                                                                                                                                                                                                                                                                                                  