tinue;
			}

			WP_CLI::add_command( $class::get_namespace(), $command );
		}
	}

	/**
	 * Loads all registered initializers if their conditionals are met.
	 *
	 * @return void
	 */
	protected function load_initializers() {
		foreach ( $this->initializers as $class ) {
			if ( ! $this->conditionals_are_met( $class ) ) {
				continue;
			}

			$initializer = $this->get_class( $class );

			if ( $initializer === null ) {
				continue;
			}

			$initializer->initialize();
		}
	}

	/**
	 * Loads all registered integrations if their conditionals are met.
	 *
	 * @return void
	 */
	public function load_integrations() {
		foreach ( $this->integrations as $class ) {
			if ( ! $this->conditionals_are_met( $class ) ) {
				continue;
			}

			$integration = $this->get_class( $class );

			if ( $integration === null ) {
				continue;
			}

			$integration->register_hooks();
		}
	}

	/**
	 * Loads all registered routes if their conditionals are met.
	 *
	 * @return void
	 */
	public function load_routes() {
		foreach ( $this->routes as $class ) {
			if ( ! $this->conditionals_are_met( $class ) ) {
				continue;
			}

			$route = $this->get_class( $class );

			if ( $route === null ) {
				continue;
			}

			$route->register_routes();
		}
	}

	/**
	 * Checks if all conditionals of a given loadable are met.
	 *
	 * @param string $loadable_class The class name of the loadable.
	 *
	 * @return bool Whether all conditionals of the loadable are met.
	 */
	protected function conditionals_are_met( $loadable_class ) {
		// In production environments do not fatal if the class does not exist but log and fail gracefully.
		if ( \YOAST_ENVIRONMENT === 'production' && ! \class_exists( $loadable_class ) ) {
			if ( \defined( 'WP_DEBUG' ) && \WP_DEBUG ) {
				// phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
				\error_log(
					\sprintf(
						/* translators: %1$s expands to Yoast SEO, %2$s expands to the name of the class that could not be found. */
						\__( '%1$s attempted to load the class %2$s but it could not be found.', 'wordpress-seo' ),
						'Yoast SEO',
						$loadable_class
					)
				);
			}
			return false;
		}

		$conditionals = $loadable_class::get_conditionals();
		foreach ( $conditionals as $class ) {
			$conditional = $this->get_class( $class );
			if ( $conditional === null || ! $conditional->is_met() ) {
				return false;
			}
		}

		return true;
	}

	/**
	 * Gets a class from the container.
	 *
	 * @param string $class_name The class name.
	 *
	 * @return object|null The class or, in production environments, null if it does not exist.
	 *
	 * @throws Throwable If the class does not exist in development environments.
	 */
	protected function get_class( 