r = $product_helper;
		$this->options_helper = $options_helper;
	}

	/**
	 * Returns the ID.
	 *
	 * @return string
	 */
	public function get_id() {
		return 'ai-generate-titles-and-descriptions-upsell';
	}

	/**
	 * Returns the unique name.
	 *
	 * @deprecated 21.6
	 * @codeCoverageIgnore
	 *
	 * @return string
	 */
	public function get_name() {
		\_deprecated_function( __METHOD__, 'Yoast SEO 21.6', 'Please use get_id() instead' );

		return $this->get_id();
	}

	/**
	 * Returns the requested pagination priority. Lower means earlier.
	 *
	 * @return int
	 */
	public function get_priority() {
		return 10;
	}

	/**
	 * Returns whether this introduction should show.
	 *
	 * @return bool
	 */
	public function should_show() {
		if ( $this->product_helper->is_premium() ) {
			return false;
		}

		if ( $this->options_helper->get( 'previous_version', '' ) === '' ) {
			// The current installation is a new one (not upgraded yet).
			return false;
		}

		if ( ! $this->is_user_allowed( [ 'edit_posts' ] ) ) {
			return false;
		}

		return true;
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                plugins/wordpress-seo-extended/src/introductions/application/current-page-trait.php                 0000644                 00000002512 15122266560 0025070 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Introductions\Application;

trait Current_Page_Trait {

	/**
	 * Determines whether the current page is applicable.
	 *
	 * @param string[] $pages The applicable pages.
	 *
	 * @return bool Whether the current page is applicable.
	 */
	private function is_on_yoast_page( $pages ) {
		return \in_array( $this->get_page(), $pages, true );
	}

	/**
	 * Determines whether the current page is one of our installation pages.
	 *
	 * @return bool Whether the current page is one of our installation pages.
	 */
	private function is_on_installation_page() {
		return $this->is_on_yoast_page( [ 'wpseo_installation_successful_free', 'wpseo_installation_successful' ] );
	}

	/**
	 * Retrieve the page variable.
	 *
	 * Note: the result is not safe to use in anything than strict comparisons!
	 *
	 * @return string The page variable.
	 */
	private function get_page() {
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Reason: We are not processing form information.
		if ( isset( $_GET['page'] ) && \is_string( $_GET['page'] ) ) {
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended,WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Reason: We are not processing form information, only using it in strict comparison.
			return \wp_unslash( $_GET['page'] );
		}

		return '';
	}
}
                                                                                                                                                                                      plugins/wordpress-seo-extended/src/introductions/application/introductions-collector.php            0000644                 00000006613 15122266560 0026251 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Introductions\Application;

use Yoast\WP\SEO\Introductions\Domain\Introduction_Interface;
use Yoast\WP\SEO\Introductions\Domain\Introduction_Item;
use Yoast\WP\SEO\Introductions\Domain\Introductions_Bucket;
use Yoast\WP\SEO\Introductions\Infrastructure\Introductions_Seen_Repository;

/**
 * Manages the collection of introductions.
 */
class Introductions_Collector {

	/**
	 * Holds all the introductions.
	 *
	 * @var Introduction_Interface[]
	 */
	private $introductions;

	/**
	 * Constructs the collector.
	 *
	 * @param Introduction_Interface ...$introductions All the introductions.
	 */
	public function __construct( Introduction_Interface ...$introductions ) {
		$this->introductions = $this->add_introductions( ...$introductions );
	}

	/**
	 * Gets the data for the introductions.
	 *
	 * @param int $user_id The user ID.
	 *
	 * @return array The list of introductions.
	 */
	public function get_for( $user_id ) {
		$bucket   = new Introductions_Bucket();
		$metadata = $this->get_metadata( $user_id );

		foreach ( $this->introductions as $introduction ) {
			if ( ! $introduction->should_show() ) {
				continue;
			}
			if ( $this->is_seen( $introduction->get_id(), $metadata ) ) {
				continue;
			}
			$bucket->add_introduction(
				new Introduction_Item( $introduction->get_id(), $introduction->get_priority() )
			);
		}

		return $bucket->to_array();
	}

	/**
	 * Filters introductions with the 'wpseo_introductions' filter.
	 *
	 * @param Introduction_Interface ...$introductions The introductions.
	 *
	 * @return Introduction_Interface[]
	 */
	private function add_introductions( Introduction_Interface ...$introductions ) {
		/**
		 * Filter: Adds the possibility to add additional introductions to be included.
		 *
		 * @internal
		 *
		 * @param Introduction_Interface $introductions This filter expects a list of Introduction_Interface instances and
		 *                                              expects only Introduction_Interface implementations to be added to the list.
		 */
		$filtered_introductions = (array) \apply_filters( 'wpseo_introductions', $introductions );

		return \array_filter(
			$filtered_introductions,
			static function ( $introduction ) {
				return \is_a( $introduction, Introduction_Interface::class );
			}
		);
	}

	/**
	 * Retrieves the introductions metadata for the user.
	 *
	 * @param int $user_id The user ID.
	 *
	 * @return array The introductions' metadata.
	 */
	private function get_metadata( $user_id ) {
		$metadata = \get_user_meta( $user_id, Introductions_Seen_Repository::USER_META_KEY, true );
		if ( \is_array( $metadata ) ) {
			return $metadata;
		}

		return [];
	}

	/**
	 * Determines whether the user has seen the introduction.
	 *
	 * @param string   $name     The name.
	 * @param string[] $metadata The metadata.
	 *
	 * @return bool Whether the user has seen the introduction.
	 */
	private function is_seen( $name, $metadata ) {
		if ( \array_key_exists( $name, $metadata ) ) {
			return (bool) $metadata[ $name ];
		}

		return false;
	}

	/**
	 * Checks if the given introduction ID is a known ID to the system.
	 *
	 * @param string $introduction_id The introduction ID to check.
	 *
	 * @return bool
	 */
	public function is_available_introduction( string $introduction_id ): bool {
		foreach ( $this->introductions as $introduction ) {
			if ( $introduction->get_id() === $introduction_id ) {
				return true;
			}
		}

		return false;
	}
}
                                                                                                                     plugins/wordpress-seo-extended/src/introductions/application/user-allowed-trait.php                 0000644                 00000000746 15122266560 0025106 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Introductions\Application;

trait User_Allowed_Trait {

	/**
	 * Determines whether the user has the required capabilities.
	 *
	 * @param string[] $capabilities The required capabilities.
	 *
	 * @return bool Whether the user has the required capabilities.
	 */
	private function is_user_allowed( $capabilities ) {
		foreach ( $capabilities as $capability ) {
			if ( ! \current_user_can( $capability ) ) {
				return false;
			}
		}

		return true;
	}
}
                          plugins/wordpress-seo-extended/src/introductions/application/version-trait.php                      0000644                 00000001141 15122266560 0024156 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Introductions\Application;

trait Version_Trait {

	/**
	 * Determines whether the version is between a min (inclusive) and max (exclusive).
	 *
	 * @param string $version     The version to compare.
	 * @param string $min_version The minimum version.
	 * @param string $max_version The maximum version.
	 *
	 * @return bool Whether the version is between a min and max.
	 */
	private function is_version_between( $version, $min_version, $max_version ) {
		return ( \version_compare( $version, $min_version, '>=' )
			&& \version_compare( $version, $max_version, '<' )
		);
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                               plugins/wordpress-seo-extended/src/introductions/domain/introduction-interface.php                  0000644                 00000001126 15122266560 0024776 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Introductions\Domain;

/**
 * Represents an introduction.
 */
interface Introduction_Interface {

	/**
	 * Returns the ID.
	 *
	 * @return string
	 */
	public function get_id();

	/**
	 * Returns the unique name.
	 *
	 * @deprecated 21.6
	 * @codeCoverageIgnore
	 *
	 * @return string
	 */
	public function get_name();

	/**
	 * Returns the requested pagination priority. Lower means earlier.
	 *
	 * @return int
	 */
	public function get_priority();

	/**
	 * Returns whether this introduction should show.
	 *
	 * @return bool
	 */
	public function should_show();
}
                                                                                                                                                                                                                                                                                                                                                                                                                                          plugins/wordpress-seo-extended/src/introductions/domain/introduction-item.php                       0000644                 00000001745 15122266560 0024003 0                                   