Notification_Helper
	 */
	protected $notification_helper;

	/**
	 * The WooCommerce conditional.
	 *
	 * @var WooCommerce_Conditional
	 */
	protected $woocommerce_conditional;

	/**
	 * The Woocommerce beta editor presenter.
	 *
	 * @var Woocommerce_Beta_Editor_Presenter
	 */
	protected $presenter;

	/**
	 * Woocommerce_Beta_Editor_Watcher constructor.
	 *
	 * @param Yoast_Notification_Center $notification_center     The notification center.
	 * @param Notification_Helper       $notification_helper     The notification helper.
	 * @param Short_Link_Helper         $short_link_helper       The short link helper.
	 * @param WooCommerce_Conditional   $woocommerce_conditional The WooCommerce conditional.
	 */
	public function __construct(
		Yoast_Notification_Center $notification_center,
		Notification_Helper $notification_helper,
		Short_Link_Helper $short_link_helper,
		WooCommerce_Conditional $woocommerce_conditional
	) {
		$this->notification_center     = $notification_center;
		$this->notification_helper     = $notification_helper;
		$this->short_link_helper       = $short_link_helper;
		$this->woocommerce_conditional = $woocommerce_conditional;
		$this->presenter               = new Woocommerce_Beta_Editor_Presenter( $this->short_link_helper );
	}

	/**
	 * Returns the conditionals based on which this loadable should be active.
	 *
	 * @return string[] The conditionals.
	 */
	public static function get_conditionals() {
		return [ Admin_Conditional::class, Not_Admin_Ajax_Conditional::class ];
	}

	/**
	 * Initializes the integration.
	 *
	 * On admin_init, it is checked whether the notification about Woocommerce product beta editor enabled should be shown.
	 *
	 * @return void
	 */
	public function register_hooks() {
		\add_action( 'admin_init', [ $this, 'manage_woocommerce_beta_editor_notification' ] );
	}

	/**
	 * Manage the Woocommerce product beta editor notification.
	 *
	 * Shows the notification if needed and deletes it if needed.
	 *
	 * @return void
	 */
	public function manage_woocommerce_beta_editor_notification() {
		if ( \get_option( 'woocommerce_feature_product_block_editor_enabled' ) === 'yes' && $this->woocommerce_conditional->is_met() ) {
			$this->maybe_add_woocommerce_beta_editor_notification();
		}
		else {
			$this->notification_center->remove_notification_by_id( self::NOTIFICATION_ID );
		}
	}

	/**
	 * Add the Woocommerce product beta editor enabled notification if it does not exist yet.
	 *
	 * @return void
	 */
	public function maybe_add_woocommerce_beta_editor_notification() {
		if ( ! $this->notification_center->get_notification_by_id( self::NOTIFICATION_ID ) ) {
			$notification = $this->notification();
			$this->notification_helper->restore_notification( $notification );
			$this->notification_center->add_notification( $notification );
		}
	}

	/**
	 * Returns an instance of the notification.
	 *
	 * @return Yoast_Notification The notification to show.
	 */
	protected function notification() {
		return new Yoast_Notification(
			$this->presenter->present(),
			[
				'type'         => Yoast_Notification::ERROR,
				'id'           => self::NOTIFICATION_ID,
				'capabilities' => 'wpseo_manage_options',
				'priority'     => 1,
			]
		);
	}
}
                                                                                                                                                                                                                                                                                                                                                                     plugins/wordpress-seo-extended/src/integrations/xmlrpc.php                                          0000644                 00000002344 15122266560 0020162 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Integrations;

use Yoast\WP\SEO\Conditionals\XMLRPC_Conditional;

/**
 * Noindexes the xmlrpc.php file and all ways to request it.
 *
 * @phpcs:disable Yoast.NamingConventions.ObjectNameDepth.MaxExceeded -- Known false positive with acronyms. Fix expected in YoastCS 3.x.
 */
class XMLRPC implements Integration_Interface {

	/**
	 * Returns the conditionals based on which this loadable should be active.
	 *
	 * In this case when the current request is an XML-RPC request.
	 *
	 * @return array The conditionals based on which this class should be loaded.
	 */
	public static function get_conditionals() {
		return [ XMLRPC_Conditional::class ];
	}

	/**
	 * Initializes the integration.
	 *
	 * @return void
	 */
	public function register_hoo