e version.
	 */
	public function get_version() {
		return \WPSEO_VERSION;
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                 plugins/wordpress-seo-extended/src/helpers/redirect-helper.php                                      0000644                 00000003344 15122266560 0020670 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

/**
 * A helper object for redirects.
 */
class Redirect_Helper {

	/**
	 * Wraps wp_redirect to allow testing for redirects.
	 *
	 * @codeCoverageIgnore It only wraps a WordPress function.
	 *
	 * @param string $location The path to redirect to.
	 * @param int    $status   The status code to use.
	 * @param string $reason   The reason for the redirect.
	 *
	 * @return void
	 */
	public function do_unsafe_redirect( $location, $status = 302, $reason = 'Yoast SEO' ) {
		// phpcs:ignore WordPress.Security.SafeRedirect -- intentional, function has been renamed to make unsafe more clear.
		\wp_redirect( $location, $status, $reason );
		exit;
	}

	/**
	 * Wraps wp_safe_redirect to allow testing for safe redirects.
	 *
	 * @codeCoverageIgnore It only wraps a WordPress function.
	 *
	 * @param string $location The path to redirect to.
	 * @param int    $status   The status code to use.
	 * @param string $reason   The reason for the redirect.
	 *
	 * @return void
	 */
	public function do_safe_redirect( $location, $status = 302, $reason = 'Yoast SEO' ) {
		\wp_safe_redirect( $location, $status, $reason );
		exit;
	}

	/**
	 * Sets a header.
	 * This is a tiny helper function to enable better testing.
	 *
	 * @codeCoverageIgnore It only wraps a WordPress function.
	 *
	 * @param string $header The header to set.
	 *
	 * @return void
	 */
	public function set_header( $header ) {
		\header( $header );
	}

	/**
	 * Removes a header.
	 * This is a tiny helper function to enable better testing.
	 *
	 * @codeCoverageIgnore It only wraps a WordPress function.
	 *
	 * @param string $header The header to remove.
	 *
	 * @return void
	 */
	public function remove_header( $header ) {
		\header_remove( $header );
	}
}
                                                                                                                                                                                                                                                                                            plugins/wordpress-seo-extended/src/helpers/request-helper.php                                       0000644                 00000000540 15122266560 0020552 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

/**
 * A helper object for the request state.
 */
class Request_Helper {

	/**
	 * Checks if the current request is a REST request.
	 *
	 * @return bool True when the current request is a REST request.
	 */
	public function is_rest_request() {
		return \defined( 'REST_REQUEST' ) && \REST_REQUEST === true;
	}
}
                                                                                                                                                                plugins/wordpress-seo-extended/src/helpers/require-file-helper.php                                  0000644                 00000000461 15122266560 0021455 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

/**
 * Represents a file helper.
 */
class Require_File_Helper {

	/**
	 * Activates the plugin based on the given plugin file.
	 *
	 * @param string $path The path to the required file.
	 */
	public function require_file_once( $path ) {
		require_once $path;
	}
}
                                                                                                                                                                                                               plugins/wordpress-seo-extended/src/helpers/robots-helper.php                                        0000644                 00000003366 15122266560 0020403 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

use Yoast\WP\SEO\Models\Indexable;

/**
 * A helper object for the robots meta tag.
 */
class Robots_Helper {

	/**
	 * Holds the Post_Type_Helper.
	 *
	 * @var Post_Type_Helper
	 */
	protected $post_type_helper;

	/**
	 * Holds the Taxonomy_Helper.
	 *
	 * @var Taxonomy_Helper
	 */
	protected $taxonomy_helper;

	/**
	 * Constructs a Score_Helper.
	 *
	 * @param Post_Type_Helper $post_type_helper The Post_Type_Helper.
	 * @param Taxonomy_Helper  $taxonomy_helper  The Taxonomy_Helper.
	 */
	public function __construct(
		Post_Type_Helper $post_type_helper,
		Taxonomy_Helper $taxonomy_helper
	) {
		$this->post_type_helper = $post_type_helper;
		$this->taxonomy_helper  = $taxonomy_helper;
	}

	/**
	 * Retrieves whether the Indexable is indexable.
	 *
	 * @param Indexable $indexable The Indexable.
	 *
	 * @return bool Whether the Indexable is indexable.
	 */
	public function is_indexable( Indexable $indexable ) {
		if ( $indexable->is_robots_noindex === null ) {
			// No individual value set, check the global setting.
			switch ( $indexable->object_type ) {
				case 'post':
					return $this->post_type_helper->is_indexable( $indexable->object_sub_type );
				case 'term':
					return $this->taxonomy_helper->is_indexable( $indexable->object_sub_type );
			}
		}

		return $indexable->is_robots_noindex === false;
	}

	/**
	 * Sets the robots index to noindex.
	 *
	 * @param array $robots The current robots value.
	 *
	 * @return array The altered robots string.
	 */
	public function set_robots_no_index( $robots ) {
		if ( ! \is_array( $robots ) ) {
			\_deprecated_argument( __METHOD__, '14.1', '$robots has to be a key-value paired array.' );
			return $robots;
		}

		$robots['index'] = 'noindex';

		return $robots;
	}
}
                                                                                                                                                                                                                                                                          plugins/wordpress-seo-extended/src/helpers/robots-txt-helper.php                                    0000644                 00000005242 15122266560 0021213 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

use Yoast\WP\SEO\Values\Robots\User_Agent_List;

/**
 * A helper object for the robots txt file.
 */
class Robots_Txt_Helper {

	/**
	 * Holds a list of user agents with directives.
	 *
	 * @var User_Agent_List
	 */
	protected $robots_txt_user_agents;

	/**
	 * Holds an array with absolute URLs of sitemaps.
	 *
	 * @var array
	 */
	protected $robots_txt_sitemaps;

	/**
	 * Constructor for Robots_Txt_Helper.
	 */
	public function __construct() {
		$this->robots_txt_user_agents = new User_Agent_List();
		$this->robots_txt_sitemaps    = [];
	}

	/**
	 * Add a disallow rule for a specific user agent if it does not exist yet.
	 *
	 * @param string $user_agent The user agent to add the disallow rule to.
	 * @param string $path       The path to add as a disallow rule.
	 *
	 * @return void
	 */
	public function add_disallow( $user_agent, $path ) {
		$user_agent_container = $this->robots_txt_user_agents->get_user_agent( $user_agent );
		$user_agent_container->add_disallow_directive( $path );
	}

	/**
	 * Add an allow rule for a specific user agent if it does not exist yet.
	 *
	 * @param string $user_agent The user agent to add the allow rule to.
	 * @param string $path       The path to add as a allow rule.
	 *
	 * @return void
	 */
	public function add_allow( $user_agent, $path ) {
		$user_agent_container = $this->robots_txt_user_agents->get_user_agent( $user_agent );
		$user_agent_container->add_allow_directive( $path );
	}

	/**
	 * Add sitemap to robots.txt if it does not exist yet.
	 *
	 * @param string $absolute_path The absolute path to the sitemap to add.
	 *
	 * @return void
	 */
	public function add_sitemap( $absolute_path ) {
		if ( ! \in_array( $absolute_path, $this->robots_txt_sitemaps, true ) ) {
			$this->robots_txt_sitemaps[] = $absolute_path;
		}
	}

	/**
	 * Get all registered disallow directives per user agent.
	 *
	 * @return array The registered disallow directives per user agent.
	 */
	public function get_disallow_directives() {
		return $this->robots_txt_user_agents->get_disallow_directives();
	}

	/**
	 * Get all registered allow directives per user agent.
	 *
	 * @return array The registered allow directives per user agent.
	 */
	public function get_allow_directives() {
		return $this->robots_txt_user_agents->get_allow_directives();
	}

	/**
	 * Get all registered sitemap rules.
	 *
	 * @return array The registered sitemap rules.
	 */
	public function get_sitemap_rules() {
		return $this->robots_txt_sitemaps;
	}

	/**
	 * Get all registered user agents
	 *
	 * @return array The registered user agents.
	 */
	public function get_robots_txt_user_agents() {
		return $this->robots_txt_user_agents->get_user_agents();
	}
}
                                                                                                                                                                                                                                                                                                                                                              plugins/wordpress-seo-extended/src/helpers/sanitization-helper.php                                  0000644                 00000002040 15122266560 0021573 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

use WPSEO_Utils;

/**
 * A helper object for sanitization.
 */
class Sanitization_Helper {

	/**
	 * Emulate the WP native sanitize_text_field function in a %%variable%% safe way.
	 *
	 * @codeCoverageIgnore We have to write test when this method contains own code.
	 *
	 * @param string $value String value to sanitize.
	 *
	 * @return string The sanitized string.
	 */
	public function sanitize_text_field( $value ) {
		return WPSEO_Utils::sanitize_text_field( $value );
	}

	/**
	 * Sanitize a url for saving to the database.
	 * Not to be confused with the old native WP function.
	 *
	 * @codeCoverageIgnore We have to write test when this method contains own code.
	 *
	 * @param string $value             String URL value to sanitize.
	 * @param array  $allowed_protocols Optional set of allowe