Yoast Metabox enabled.
	 *
	 * @param string $post_type_name The name of the post type to lookup.
	 *
	 * @return bool True if metabox is enabled.
	 */
	public function has_metabox( $post_type_name ) {
		return ( $this->options_helper->get( 'display-metabox-pt-' . $post_type_name, true ) === true );
	}

	/**
	 * Returns an array with the public post types.
	 *
	 * @codeCoverageIgnore It only wraps a WordPress function.
	 *
	 * @param string $output The output type to use.
	 *
	 * @return array Array with all the public post_types.
	 */
	public function get_public_post_types( $output = 'names' ) {
		return \get_post_types( [ 'public' => true ], $output );
	}

	/**
	 * Returns an array with