tring $language The language to check if inclusive language is supported.
	 *
	 * @return bool Whether the language has inclusive language support.
	 */
	public function has_inclusive_language_support( $language ) {
		return \in_array( $language, self::$languages_with_inclusive_language_support, true );
	}

	/**
	 * Checks whether we have a specific researcher for the current locale and returns that language.
	 * If there is no researcher for the current locale, returns default as the researcher.
	 *
	 * @return string The language to use to select a researcher.
	 */
	public function get_researcher_language() {
		$researcher_language = WPSEO_Language_Utils::get_language( \get_locale() );
		$supported_languages = Researcher_Languages::SUPPORTED_LANGUAGES;

		if ( ! \in_array( $researcher_language, $supported_languages, true ) ) {
			$researcher_language = 'default';
		}
		return $researcher_language;
	}

	/**
	 *