is ≤4% of the total amount of objects in the site, don't show configuration button.
		if ( $this->get_unindexed_percentage( $unindexed_count ) <= 4 ) {
			return false;
		}
		return true;
	}

	/**
	 * Returns the total number of unindexed objects and applies a filter for third party integrations.
	 *
	 * @return int The total number of unindexed objects.
	 */
	public function get_filtered_unindexed_count() {
		$unindexed_count = $this->get_unindexed_count();

		/**
		 * Filter: 'wpseo_indexing_get_unindexed_count' - Allow changing the amount of unindexed objects.
		 *
		 * @param int $unindexed_count The amount of unindexed objects.
		 */
		return \apply_filters( 'wpseo_indexing_get_unindexed_count', $unindexed_count );
	}

	/**
	 * Returns a limited number of unindexed objects.
	 *
	 * @param int                                                               $limit   Limit the number of unindexed objects that are counted.
	 * @param Indexation_Action_Interface[]|Limited_Indexing_Action_Interface[] $actions The actions whose counts will be calculated.
	 *
	 * @return int The total number of unindexed objects.
	 */
	public function get_limited_unindexed_count( $limit, $actions = [] ) {
		$unindexed_count = 0;

		if ( empty( $actions ) ) {
			$actions = $this->indexing_actions;
		}

		foreach ( $actions as $action ) {
			$unindexed_count += $action->get_limited_unindexed_count( $limit - $unindexed_count + 1 );
			if ( $unindexed_count > $limit ) {
				return $unindexed_count;
			}
		}

		return $unindexed_count;
	}

	/**
	 * Returns the total number of unindexed objects and applies a filter for third party integrations.
	 *
	 * @param int $limit Limit the number of unindexed objects that are counted.
	 *
	 * @return int The total number of unindexed objects.
	 */
	public function get_limited_filtered_unindexed_count( $limit ) {
		$unindexed_count = $this->get_limited_unindexed_count( $limit, $this->indexing_actions );

		if ( $unindexed_count > $limit ) {
			return $unindexed_count;
		}

		/**
		 * Filter: 'wpseo_indexing_get_limited_unindexed_count' - Allow changing the amount of unindexed objects,
		 * and allow for a maximum number of items counted to improve performance.
		 *
		 * @param int       $unindexed_count The amount of unindexed objects.
		 * @param int|false $limit           Limit the number of unindexed objects that need to be counted.
		 *                                   False if it doesn't need to be limited.
		 */
		return \apply_filters( 'wpseo_indexing_get_limited_unindexed_count', $unindexed_count, $limit );
	}

	/**
	 * Returns the total number of unindexed objects that can be indexed in the background and applies a filter for third party integrations.
	 *
	 * @param int $limit Limit the number of unindexed objects that are counted.
	 *
	 * @return int The total number of unindexed objects that can be indexed in the background.
	 */
	public function get_limited_filtered_unindexed_count_background( $limit ) {
		$unindexed_count = $this->get_limited_unindexed_count( $limit, $this->background_indexing_actions );

		if ( $unindexed_count > $limit ) {
			return $unindexed_coun