or the first time.
	 *
	 * @return bool Whether the site still has to be indexed for the first time.
	 */
	public function is_initial_indexing() {
		return $this->options_helper->get( 'indexing_first_time', true );
	}

	/**
	 * Gets a boolean that indicates whether or not the indexing of the indexables has completed.
	 *
	 * @return bool Whether the indexing of the indexables has completed.
	 */
	public function is_finished_indexables_indexing() {
		return $this->options_helper->get( 'indexables_indexing_completed', false );
	}

	/**
	 * Returns the total number of unindexed objects.
	 *
	 * @return int The total number of unindexed objects.
	 */
	public function get_unindexed_count() {
		$unindexed_count = 0;

		foreach ( $this->indexing_actions as $indexing_action ) {
			$unindexed_count += $indexing_action->get_total_unindexed();
		}

		return $unindexed_count;
	}

	/**
	 * Returns the amount of un-indexed posts expressed in percentage, which will be needed to set a threshold.
	 *
	 * @param int $unindexed_cou