e indexing process by setting several database options and removing the indexing notification.
	 *
	 * @return void
	 */
	public function prepare() {
		$this->set_first_time( false );
		$this->set_started( $this->date_helper->current_time() );
		$this->remove_indexing_notification();
		// Do not set_reason here; if the process is cancelled, the reason to start indexing is still valid.
	}

	/**
	 * Sets several database options when the indexing process is finished.
	 *
	 * @return void
	 */
	public function complete() {
		$this->set_reason( '' );
		$this->set_started( null );
	}

	/**
	 * Sets appropriate flags when the indexing process fails.
	 *
	 * @return void
	 */
	public function indexing_failed() {
		$this->set_reason( Indexing_Reasons::REASON_INDEXING_FAILED );
		$this->set_started( null );
	}

	/**
	 * Sets the indexing reason.
	 *
	 * @param string $reason The indexing reason.
	 *
	 * @return void
	 */
	public function set_reason( $reason )