 0 is also a possibility when no ID is available.
	 *
	 * @codeCoverageIgnore - We have to write test when this method contains own code.
	 *
	 * @param string $setting The setting the image is stored in.
	 *
	 * @return int|bool The attachment id, or false or 0 if no ID is available.
	 */
	public function get_attachment_id_from_settings( $setting ) {
		return WPSEO_Image_Utils::get_attachment_id_from_settings( $setting );
	}

	/**
	 * Based on and image ID return array with the best variation of that image. If it's not saved to the DB,  save it to an option.
	 *
	 * @param string $setting The setting name. Should be company or person.
	 *
	 * @return array|bool Array with image details when the image is found, boolean when it's not found.
	 */
	public function get_attachment_meta_from_settings( $setting ) {
		$image_meta = $this->options_helper->get( $setting . '_meta', false );
		if ( ! $image_meta ) {
			$image_id = $this->options_helper->get( $setting . '_id', false );
			if ( $image_id ) {
				// There is not an option to put a URL in an image field in the settings anymore, only to upload it through the media manager.
				// This means an attachment always exists, so doing this is only needed once.
				$image_meta = $this->get_best_attachment_variation( $image_id );
				if ( $image_meta ) {
					$this->options_helper->set( $setting . '_meta', $image_meta );
				}
			}
		}

		return $image_meta;
	}

	/**
	 * Retrieves the first usable content image for a post.
	 *
	 * @codeCoverageIgnore - We have to write test when this method contains own code.
	 *
	 * @param int $post_id The post id to extract the images from.
	 *
	 * @return string|null
	 */
	protected function get_first_usable_content_image_for_post( $post_id ) {
		return WPSEO_Image_Utils::get_first_usable_content_image_for_post( $post_id );
	}

	/**
	 * Gets the term's first usable content image. Null if none is available.
	 *
	 * @codeCoverageIgnore - We have to write test when this method contains own code.
	 *
	 * @param int $term_id The term id.
	 *
	 * @return string|null The image URL.
	 */
	protected function get_first_content_image_for_term( $term_id ) {
		return WPSEO_Image_Utils::get_first_content_image_for_term( $term_id );
	}
}
                                                                                                                                                                                                                                                                                                                                plugins/wordpress-seo-extended/src/helpers/import-cursor-helper.php                                 0000644                 00000002563 15122266560 0021716 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

/**
 * The Import Cursor Helper.
 */
class Import_Cursor_Helper {

	/**
	 * The Options_Helper.
	 *
	 * @var Options_Helper
	 */
	public $options;

	/**
	 * Class constructor.
	 *
	 * @param Options_Helper $options The options helper.
	 */
	public function __construct(
		Options_Helper $options
	) {
		$this->options = $options;
	}

	/**
	 * Returns the stored cursor value.
	 *
	 * @param string $cursor_id     The cursor id.
	 * @param mixed  $default_value The default value if no cursor has been set yet.
	 *
	 * @return int The stored cursor value.
	 */
	public function get_cursor( $cursor_id, $default_value = 0 ) {
		$import_cursors = $this->options->get( 'import_cursors', [] );

		return ( isset( $import_cursors[ $cursor_id ] ) ) ? $import_cursors[ $cursor_id ] : $default_value;
	}

	/**
	 * Stores the current cursor value.
	 *
	 * @param string $cursor_id        The cursor id.
	 * @param int    $last_imported_id The id of the lastly imported entry.
	 *
	 * @return void
	 */
	public function set_cursor( $cursor_id, $last_imported_id ) {
		$current_cursors = $this->options->get( 'import_cursors', [] );

		if ( ! isset( $current_cursors[ $cursor_id ] ) || $current_cursors[ $cursor_id ] < $last_imported_id ) {
			$current_cursors[ $cursor_id ] = $last_imported_id;
			$this->options->set( 'import_cursors', $current_cursors );
		}
	}
}
                                                                                                                                             plugins/wordpress-seo-extended/src/helpers/import-helper.php                                        0000644                 00000001314 15122266560 0020374 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

/**
 * The Import Helper.
 */
class Import_Helper {

	/**
	 * Flattens a multidimensional array of settings. Recursive.
	 *
	 * @param array  $array_to_flatten The array to be flattened.
	 * @param string $key_prefix       The key to be used as a prefix.
	 *
	 * @return array The flattened array.
	 */
	public function flatten_settings( $array_to_flatten, $key_prefix = '' ) {
		$result = [];
		foreach ( $array_to_flatten as $key => $value ) {
			if ( \is_array( $value ) ) {
				$result = \array_merge( $result, $this->flatten_settings( $value, $key_prefix . '/' . $key ) );
			}
			else {
				$result[ $key_prefix . '/' . $key ] = $value;
			}
		}

		return $result;
	}
}
                                                                                                                                                                                                                                                                                                                    plugins/wordpress-seo-extended/src/helpers/indexable-help