ate should be in.
	 *
	 * @return string The formatted and translated date.
	 */
	public function format_translated( $date, $format = \DATE_W3C ) {
		return \date_i18n( $format, $this->format( $date, 'U' ) );
	}

	/**
	 * Returns the current time measured in the number of seconds since the Unix Epoch (January 1 1970 00:00:00 GMT).
	 *
	 * @return int The current time measured in the number of seconds since the Unix Epoch (January 1 1970 00:00:00 GMT).
	 */
	public function current_time() {
		return \time();
	}

	/**
	 * Check if a string is a valid datetime.
	 *
	 * @param string $datetime String input to check as valid input for DateTime class.
	 *
	 * @return bool True when datetime is valid.
	 */
	public function is_valid_datetime( $datetime ) {
		if ( $datetime === null ) {
			/*
			 * While not "officially" supported, `null` will be handled as `"now"` until PHP 9.0.
			 * @link https://3v4l.org/tYp2k
			 */
			return true;
		}

		if ( \is_string( $datetime ) && \substr( $datetime, 0, 1 ) === '-' ) {
			return false;
		}

		try {
			return new DateTime( $datetime ) !== false;
		} catch ( Exception $exception ) {
			return false;
		}
	}
}
                                                                                                                                                                                                                                                                                                                                                                                        plugins/wordpress-seo-extended/src/helpers/environment-helper.php                                   0000644                 00000001431 15122266560 0021426 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

/**
 * A helper object for site environment.
 */
class Environment_Helper {

	/**
	 * Determines if the site is running on production.
	 *
	 * @return bool True if WordPress is currently running on production, false for all other environments.
	 */
	public function is_production_mode() {
		// phpcs:ignore Yoast.NamingConventions.ValidHookName.WrongPrefix -- existing hook.
		$override = \apply_filters( 'yoast_seo_development_mode', false );
		if ( $override ) {
			return true;
		}

		return $this->get_wp_environment() === 'production';
	}

	/**
	 * Determines on which environment WordPress is running.
	 *
	 * @return string The current WordPress environment.
	 */
	public function get_wp_environment() {
		return \wp_get_environment_type();
	}
}
                                                                                                                                                                                                                                       plugins/wordpress-seo-extended/src/helpers/first-time-configuration-notice-helper.php               0000644                 00000011407 15122266560 0025275 0                                                                                                    ustar 00                                                                                                                                                     