led, `false` if not.
	 */
	public function are_disabled() {
		return $this->options_helper->get( 'disable-author' );
	}

	/**
	 * Returns whether the author has at least one public post.
	 *
	 * @codeCoverageIgnore It looks for the first ID through the ORM and converts it to a boolean.
	 *
	 * @param int $author_id The author ID.
	 *
	 * @return bool Whether the author has at least one public post.
	 */
	protected function author_has_a_public_post( $author_id ) {
		$cache_key        = 'author_has_a_public_post_' . $author_id;
		$indexable_exists = \wp_cache_get( $cache_key );

		if ( $indexable_exists === false ) {
			$indexable_exists = Model::of_type( 'Indexable' )
				->select( 'id' )
				->where( 'object_type', 'post' )
				->where_in( 'object_sub_type', $this->get_author_archive_post_types() )
				->where( 'author_id', $author_id )
				->where( 'is_public', 1 )
				->find_one();

			if ( $indexable_exists === false ) {
				// Cache no results to prevent full table scanning on authors with no public posts.
				\wp_cache_set( $cache_key, 0, '', \wp_rand( ( 2 * \HOUR_IN_SECONDS ), ( 4 * \HOUR_IN_SECONDS ) ) );
			}
		}

		return (bool) $indexable_exists;
	}

	/**
	 * Returns whether the author has at least one post with the is public null.
	 *
	 * @codeCoverageIgnore It looks for the first ID through the ORM and converts it to a boolean.
	 *
	 * @param int $author_id The author ID.
	 *
	 * @return bool Whether the author has at least one post with the is public null.
	 */
	protected function author_has_a_post_with_is_public_null( $author_id ) {
		$cache_key        = 'author_has_a_post_with_is_public_null_' . $author_id;
		$indexable_exists = \wp_cache_get( $cache_key );

		if ( $indexable_exists === false ) {
			$indexable_exists = Model::of_type( 'Indexable' )
				->select( 'id' )
				->where( 'object_type', 'post' )
				->where_in( 'object_sub_type', $this->get_author_archive_post_types() )
				->where( 'author_id', $author_id )
				->where_null( 'is_public' )
				->find_one();

			if ( $indexable_exists === false ) {
				// Cache no results to prevent full table scanning on authors with no is public null posts.
				\wp_cache_set( $cache_key, 0, '', \wp_rand( ( 2 * \HOUR_IN_SECONDS ), ( 4 * \HOUR_IN_SECONDS ) ) );
			}
		}

		return (bool) $indexable_exists;
	}
}
                                                                                                                                                                                                                                                            plugins/wordpress-seo-extended/src/helpers/blocks-helper.php                                        0000644                 00000004512 15122266560 0020342 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

use WP_Block_Parser_Block;

/**
 * A helper object for blocks.
 */
class Blocks_Helper {

	/**
	 * Holds the Post_Helper instance.
	 *
	 * @var Post_Helper
	 */
	private $post;

	/**
	 * Constructs a Blocks_Helper instance.
	 *
	 * @codeCoverageIgnore It handles dependencies.
	 *
	 * @param Post_Helper $post The post helper.
	 */
	public function __construct( Post_Helper $post ) {
		$this->post = $post;
	}

	/**
	 * Returns all blocks in a given post.
	 *
	 * @param int $post_id The post id.
	 *
	 * @return array The blocks in a block-type => WP_Block_Parser_Block[] format.
	 */
	public function get_all_blocks_from_post( $post_id ) {
		if ( ! $this->has_blocks_support() ) {
			return [];
		}

		$post = $this->post->get_post( $post_id );
		return $this->get_all_blocks_from_content( $post->post_content );
	}

	/**
	 * Returns all blocks in a given content.
	 *
	 * @param string $content The content.
	 *
	 * @return array The blocks in a block-type => WP_Block_Parser_Block[] format.
	 */
	public function get_all_blocks_from_content( $content ) {
		if ( ! $this->has_blocks_support() ) {
			return [];
		}

		$collection = [];
		$blocks     = \parse_blocks( $content );
		return $this->collect_blocks( $blocks, $collection );
	}

	/**
	 * Checks if the installation has blocks support.
	 *
	 * @codeCoverageIgnore It only checks if a WordPress function exists.
	 *
	 * @return bool True when function parse_blocks exists.
	 */
	protected function has_blocks_support() {
		return \function_exists( 'parse_blocks' );
	}

	/**
	 * Collects an array of blocks into an organised collection.
	 *
	 * @param WP_Block_Parser_Block[] $blocks     The blocks.
	 * @param array                   $collection The collection.
	 *
	 * @return array The blocks in a block-type => WP_Block_Parser_Block[] format.
	 */
	private function collect_blocks( $blocks, $collection ) {
		foreach ( $blocks as $block ) {
			if ( empty( $block['blockName'] ) ) {
				continue;
			}

			if ( ! isset( $collection[ $block['blockName'] ] ) || ! \is_array( $collection[ $block['blockName'] ] ) ) {
				$collection[ $block['blockName'] ] = [];
			}
			$collection[ $block['blockName'] ][] = $block;

			if ( isset( $block['innerBlocks'] ) ) {
				$collection = $this->collect_blocks( $block['innerBlocks'], $collection );
			}
		}

		return $collection;
	}
}
                                                                                                                                                                                      plugins/wordpress-seo-extended/src/helpers/capability-helper.php                                    0000644                 00000004104 15122266560 0021203 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

/**
 * A helper object for user capabilities.
 */
class Capability_Helper {

	/**
	 * Checks if the user has at least one of the proper capabilities.
	 *
	 * @param string $capability Capability to check.
	 *
	 * @return bool True if the user has at least one of the proper rights.
	 */
	public function current_user_can( $capability ) {
		if ( $capability === 'wpseo_manage_options' ) {
			return \current_user_can( $capability );
		}

		return $this->has_any( [ 'wpseo_manage_options', $capability ] );
	}

	/**
	 * Retrieves the users that have the specified capability.
	 *
	 * @param string $capability The name of the capability.
	 *
	 * @return array The users that have the capability.
	 */
	public function get_applicable_users( $capability ) {
		$applicable_roles = $this->get_applicable_roles( $capability );

		if ( $applicable_roles === [] ) {
			return [];
		}

		return \get_users( [ 'role__in' => $applicable_roles ] );
	}

	/**
	 * Retrieves the roles that have the specified capability.
	 *
	 * @param string $capability The name of the capability.
	 *
	 * @return array The names of the roles that have the capability.
	 */
	public function get_applicable_roles( $capability ) {
		$roles      = \wp_roles();
		$role_names = $roles->get_names();

		$applicable_roles = [];
		foreach ( \array_keys( $role_names ) as $role_name ) {
			$role = $roles->get_role( $role_name );

			if ( ! $role ) {
				continue;
			}

			// Add role if it has the capability.
			if ( \array_key_exists( $capability, $role->capabilities ) && $role->capabilities[ $capability ] === true ) {
				$applicable_roles[] = $role_name;
			}
		}

		return $applicable_roles;
	}

	/**
	 * Checks if the current user has at least one of the supplied capabilities.
	 *
	 * @param array $capabilities Capabilities to check against.
	 *
	 * @return bool True if the user has at least one capability.
	 */
	private function has_any( array $capabilities ) {
