.
	 *
	 * @param string $handle The handle of the asset.
	 *
	 * @return string|false The URL of the asset or false if the asset does not exist.
	 */
	public function get_asset_url( $handle ) {
		$scripts = \wp_scripts();

		if ( ! isset( $scripts->registered[ $handle ] ) ) {
			return false;
		}

		$obj = $scripts->registered[ $handle ];

		if ( $obj->ver === null ) {
			$ver = '';
		}
		else {
			$ver = ( $obj->ver ) ? $obj->ver : $scripts->default_version;
		}
		if ( isset( $scripts->args[ $handle ] ) ) {
			$ver = ( $ver ) ? $ver . '&amp;' . $scripts->args[ $handle ] : $scripts->args[ $handle ];
		}

		$src = $obj->src;

		if ( ! \preg_match( '|^(https?:)?//|', $src ) && ! ( $scripts->content_url && \strpos( $src, $scripts->content_url ) === 0 ) ) {
			$src = $scripts->base_url . $src;
		}

		if ( ! empty( $ver ) ) {
			$src = \add_query_arg( 'ver', $ver, $src );
		}

		/** This filter is documented in wp-includes/class.wp-scripts.php */
		return \esc_url( \apply_filters( 'script_loader_src', $src, $handle ) );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    plugins/wordpress-seo-extended/src/helpers/attachment-cleanup-helper.php                            0000644                 00000004366 15122266560 0022651 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

use Yoast\WP\Lib\Model;

/**
 * A helper object for the cleanup of attachments.
 */
class Attachment_Cleanup_Helper {

	/**
	 * Removes all indexables for attachments.
	 *
	 * @param bool $suppress_errors Whether to suppress db errors when running the cleanup query.
	 *
	 * @return void
	 */
	public function remove_attachment_indexables( $suppress_errors ) {
		global $wpdb;

		if ( $suppress_errors ) {
			// If migrations haven't been completed successfully the following may give false errors. So suppress them.
			$show_errors       = $wpdb->show_errors;
			$wpdb->show_errors = false;
		}

		$indexable_table = Model::get_table_name( 'Indexable' );

		$delete_query = "DELETE FROM $indexable_table WHERE object_type = 'post' AND object_sub_type = 'attachment'";

		// phpcs:disable WordPress.DB.DirectDatabaseQuery.NoCaching -- Reason: No relevant caches.
		// phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery -- Reason: Most performant way.
		// phpcs:disable WordPress.DB.PreparedSQL.NotPrepared -- Reason: Is it prepared already.
		$wpdb->query( $delete_query );
		// phpcs:enable

		if ( $suppress_errors ) {
			$wpdb->show_errors = $show_errors;
		}
	}

	/**
	 * Cleans all attachment links in the links table from target indexable ids.
	 *
	 * @param bool $suppress_errors Whether to suppress db errors when running the cleanup query.
	 *
	 * @return void
	 */
	public function clean_attachment_links_from_target_indexable_ids( $suppress_errors ) {
		global $wpdb;

		if ( $suppress_errors ) {
			// If migrations haven't been completed successfully the following may give false errors. So suppress them.
			$show_errors       = $wpdb->show_errors;
			$wpdb->show_errors = false;
		}

		$links_table = Model::get_table_name( 'SEO_Links' );

		$query = "UPDATE $links_table SET target_indexable_id = NULL WHERE type = 'image-in'";

		// phpcs:disable WordPress.DB.DirectDatabaseQuery.NoCaching -- Reason: No relevant caches.
		// phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery -- Reason: Most performant way.
		// phpcs:disable WordPress.DB.PreparedSQL.NotPrepared -- Reason: Is it prepared already.
		$wpdb->query( $query );
		// phpcs:enable

		if ( $suppress_errors ) {
			$wpdb->show_errors = $show_errors;
		}
	}
}
                                                                                                                                                                                                                                                                          plugins/wordpress-seo-extended/src/helpers/author-archive-helper.php                                0000644                 00000012404 15122266560 0022005 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Helpers;

use WP_Query;
use Yoast\WP\Lib\Model;

/**
 * A helper object for author archives.
 */
class Author_Archive_Helper {

	/**
	 * The options helper.
	 *
	 * @var Options_Helper
	 */
	private $options_helper;

	/**
	 * The post type helper.
	 *
	 * @var Post_Type_Helper
	 */
	private $post_type_helper;

	/**
	 * Creates a new author archive helper.
	 *
	 * @param Options_Helper   $options_helper   The options helper.
	 * @param Post_Type_Helper $post_type_helper The post type helper.
	 */
	public function __construct(
		Options_Helper $options_helper,
		Post_Type_Helper $post_type_helper
	) {
		$this->options_helper   = $options_helper;
		$this->post_type_helper = $post_type_helper;
	}

	/**
	 * Gets the array of post types that are shown on an author's archive.
	 *
	 * @return array The post types that are shown on an author's archive.
	 */
	public function get_autho