<?php

namespace Yoast\WP\SEO\Helpers;

/**
 * A helper object for author archives.
 */
class Asset_Helper {

	/**
	 * Recursively retrieves all dependency urls of a given handle.
	 *
	 * @param string $handle The handle.
	 *
	 * @return string[] All dependency urls of the given handle.
	 */
	public function get_dependency_urls_by_handle( $handle ) {
		$urls = [];

		foreach ( $this->get_dependency_handles( $handle ) as $other_handle ) {
			$urls[ $other_handle ] = $this->get_asset_url( $other_handle );
		}

		return $urls;
	}

	/