$data, $schema_id, $add_hash, $user_data );
		if ( ! isset( $data['image'] ) ) {
			$data = $this->set_image_from_avatar( $data, $user_data, $schema_id, $add_hash );
		}

		if ( \is_array( $this->type ) && \in_array( 'Organization', $this->type, true ) ) {
			$data_logo    = ( $data['image']['@id'] ?? $schema_id );
			$data['logo'] = [ '@id' => $data_logo ];
		}

		return $data;
	}

	/**
	 * Generate the person image from our settings.
	 *
	 * @param array<string|string[]> $data      The Person schema.
	 * @param string                 $schema_id The string used in the `@id` for the schema.
	 * @param bool                   $add_hash  Whether or not the person's image url hash should be added to the image id.
	 * @param WP_User                $user_data User data.
	 *
	 * @return array<string|string[]> The Person schema.
	 */
	protected function set_image_from_options( $data, $schema_id, $add_hash = false, $user_data = null ) {
		if ( $this->context->site_represents !== 'person' ) {
			return $data;
		}
		if ( \is_array( $this->context->person_logo_meta ) ) {
			$data['image'] = $this->helpers->schema->image->generate_from_attachment_meta( $schema_id, $this->context->person_logo_meta, $data['name'], $add_hash );
		}

		return $data;
	}

	/**
	 * Generate the person logo from gravatar.
	 *
	 * @param array<string|string[]> $data      The Person schema.
	 * @param WP_User                $user_data User data.
	 * @param string                 $schema_id The string used in the `@id` for the schema.
	 * @param bool                   $add_hash  Wether or not the person's image url hash should be added to the image id.
	 *
	 * @return array<string|string[]> The Person schema.
	 */
	protected function set_image_from_avatar( $data, $user_data, $schema_id, $add_hash = false ) {
		// If we don't have an image in our settings, fall back to an avatar, if we're allowed to.
		$show_avatars = \get_option( 'show_avatars' );
		if ( ! $show_avatars ) {
			return $data;
		}

		$url = \get_avatar_url( $user_data->user_email );
		if ( empty( $url ) ) {
			return $data;
		}

		$data['image'] = $this->helpers->schema->image->simple_image_object( $schema_id, $url, $user_data->display_name, $add_hash );

		return $data;
	}

	/**
	 * Returns an author's social site URL.
	 *
	 * @param string    $social_site The social site to retrieve the URL for.
	 * @param int|false $user_id     The user ID to use function outside of the loop.
	 *
	 * @return string
	 */
	protected function url_social_site( $social_site, $user_id = false ) {
		$url = \get_the_author_meta( $social_site, $user_id );

		if ( ! empty( $url ) && $social_site === 'twitter' ) {
			$url = 'https://x.com/' . $url;
		}

		return $url;
	}

	/**
	 * Checks the site is represented by the same person as this indexable.
	 *
	 * @param WP_User $user_data User data.
	 *
	 * @return bool True when the site is represented by the same person as this indexable.
	 */
	protected function site_represents_current_author( $user_data = null ) {
		// Can only be the case when the site represents a user.
		if ( $this->context->site_represents !== 'person' ) {
			return false;
		}

		// Article post from the same user as the site represents.
		if (
			$this->context->indexable->object_type === 'post'
