s() ) {
			return $image_container->get_images();
		}

		return $this->generate( $context );
	}

	/**
	 * Adds an image based on the given indexable.
	 *
	 * @param Indexable $indexable       The indexable.
	 * @param Images    $image_container The image container.
	 *
	 * @return void
	 */
	protected function add_from_indexable( Indexable $indexable, Images $image_container ) {
		if ( $indexable->open_graph_image_meta ) {
			$image_container->add_image_by_meta( $indexable->open_graph_image_meta );
			return;
		}

		if ( $indexable->open_graph_image_id ) {
			$image_container->add_image_by_id( $indexable->open_graph_image_id );
			return;
		}

		if ( $indexable->open_graph_image ) {
			$meta_data = [];
			if ( $indexable->open_graph_image_meta && \is_string( $indexable->open_graph_image_meta ) ) {
				$meta_data = \json_decode( $indexable->open_graph_image_meta, true );
			}

			$image_container->add_image(
				\array_merge(
					(array) $meta_data,
					[
						'url' => $indexable->open_graph_image,
					]
				)
			);
		}
	}

	/**
	 * Retrieves the default Open Graph image.
	 *
	 * @param Images $image_container The image container.
	 *
	 * @return void
	 */
	protected function add_from_default( Images $image_container ) {
		if ( $image_container->has_images() ) {
			return;
		}

		$default_image_id = $this->options->get( 'og_default_image_id', '' );
		if ( $default_image_id ) {
			$image_container->add_image_by_id( $default_image_id );

			return;
		}

		$default_image_url = $this->options->get( 'og_default_image', '' );
		if ( $default_image_url ) {
			$image_container->add_image_by_url( $default_image_url );
		}
	}

	/**
	 * Retrieves the default Open Graph image.
	 *
	 * @param Meta_Tags_Context $context         The context.
	 * @param Images            $image_container The image container.
	 *
	 * @return void
	 */
	protected function add_from_templates( Meta_Tags_Context $context, Images $image_container ) {
		if ( $image_container->has_images() ) {
			return;
		}

		if ( $context->presentation->open_graph_image_id ) {
			$image_container->add_image_by_id( $context->presentation->open_graph_image_id );
			return;
		}

		if ( $context->presentation->open_graph_image ) {
			$image_container->add_image_by_url( $context->presentation->open_graph_image );
		}
	}

	/**
	 * Retrieves an instance of the image container.
	 *
	 * @codeCoverageIgnore
	 *
	 * @return Images The image container.
	 */
	protected function get_image_container() {
		$image_container = new Images( $this->image, $this->url );
		$image_container->