cestor The indexable.
	 *
	 * @return string[] The crumb.
	 */
	private function get_system_page_crumb( $crumb, $ancestor ) {
		if ( $ancestor->object_sub_type === 'search-result' ) {
			$crumb['text'] = $this->options->get( 'breadcrumbs-searchprefix' ) . ' ' . \esc_html( \get_search_query() );
			$crumb['url']  = \get_search_link();
		}
		elseif ( $ancestor->object_sub_type === '404' ) {
			$crumb['text'] = $this->options->get( 'breadcrumbs-404crumb' );
		}

		return $crumb;
	}

	/**
	 * Returns the modified user crumb.
	 *
	 * @param string[]  $crumb    The crumb.
	 * @param Indexable $ancestor The indexable.
	 *
	 * @return string[] The crumb.
	 */
	private function get_user_crumb( $crumb, $ancestor ) {
		$display_name  = \get_the_author_meta( 'display_name', $ancestor->object_id );
		$crumb['text'] = $this->options->get( 'breadcrumbs-archiveprefix' ) . ' ' . $display_name;

		return $crumb;
	}

	/**
	 * Returns the modified date archive crumb.
	 *
	 * @param string[] $crumb The crumb.
	 *
	 * @return string[] The crumb.
	 */
	protected function get_date_archive_crumb( $crumb ) {
		$home_url = $this->url_helper->home();
		$prefix   = $this->options->get( 'breadcrumbs-archiveprefix' );

		if ( \is_day() ) {
			$day           = \esc_html( \get_the_date() );
			$crumb['url']  = $home_url . \get_the_date( 'Y/m/d' ) . '/';
			$crumb['text'] = $prefix . ' ' . $day;
		}
		elseif ( \is_month() ) {
			$month         = \esc_html( \trim( \single_month_title( ' ', false ) ) );
			$crumb['url']  = $home_url . \get_the_date( 'Y/m' ) . '/';
			$crumb['text'] = $prefix . ' ' . $month;
		}
		elseif ( \is_year() ) {
			$year          = \get_the_date( 'Y' );
			$crumb['url']  = $home_url . $year . '/';
			$crumb['text'] = $prefix . ' ' . $year;
		}

		return $crumb;
	}

	/**
	 * Returns whether or not a blog crumb should be added.
	 *
	 * @param int               $page_for_posts The page for posts ID.
	 * @param Meta_Tags_Context $context        The meta tags context.
	 *
	 * @return bool Whether or not a blog crumb should be added.
	 */
	protected function should_have_blog_crumb( $page_for_posts, $context ) {
		// When there is no page configured as blog page.
		if ( \get_option( 'show_on_front' ) !== 'page' || ! $page_for_posts ) {
			return false;
		}

		if ( $context->indexable->object_type === 'term' ) {
			$parent = $this->get_taxonomy_post_type_parent( $context->indexable->object_sub_type );
			return $parent === 'post';
		}

		if ( $this->options->get( 'breadcrumbs-display-blog-page' ) !== true ) {
			return false;
		}

		// When the current page is the home page, searchpage or isn't a singular post.
		if ( \is_home() || \is_search() || ! \is_singular( 'post' ) ) {
			return false;
		}

		return true;
	}

	/**
	 * Returns the post type parent of a given taxonomy.
	 *
	 * @param string $taxonomy The taxonomy.
	 *
	 * @return string|false The parent if it exists, false otherwise.
	 */
	protected function get_taxonomy_post_type_parent( $taxonomy ) {
		$parent = $this->options->get( 'taxonomy-' . $taxonomy . '-ptparent' );

		if ( empty( $parent ) || (string) $parent === '0' ) {
			return false;
		}

		return $parent;
	}

	/**
	 * Adds a crumb for the current page, if we're on an archive page or paginated post.
	 *
	 * @param string[]  $crumbs            The array of breadcrumbs.
	 * @param Indexable $current_indexable The current indexable.
	 *
	 * @return string[] The breadcrumbs.
	 */
	protected function add_paged_crumb( array $crumbs, $current_indexable ) {
		$is_simple_page = $this->current_page_helper->is_simple_page();

		// If we're not on a paged page do nothing.
		if ( ! $is_simple_page && ! $this->current_page_helper->is_paged() ) {
			return $crumbs;
		}

		// If we're not on a paginated post do nothing.
		if ( $is_simple_page && $current_indexable->number_of_pages === null ) {
			return $crumbs;
		}

		$current_page_number = $this->pagination_helper->get_current_page_number();
		if ( $current_page_number <= 1 ) {
			return $crumbs;
		}

		$crumbs[] = [
			'text' => \sprintf(
				/* translators: %s expands to the current page number */
				\__( 'Page %s', 'wordpress-seo' ),
				$current_page_number
			),
		];

		return $crumbs;
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                             plugins/wordpress-seo-extended/src/generators/generator-interface.php                               0000644                 00000000544 15122266560 0022244 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Generators;

use Yoast\WP\SEO\Context\Meta_Tags_Context;

interface Generator_Interface {

	/**
	 * Returns a string, or other Thing that the associated presenter can handle.
	 *
	 * @param Meta_Tags_Context $context The meta tags context.
	 *
	 * @return mixed
	 */
	public function generate( Meta_Tags_Context $context );
}
                                                                                                                                                            plugins/wordpress-seo-extended/src/generators/open-graph-image-generator.php                        0000644                 00000014114 15122266560 0023422 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Generators;

use Error;
use Yoast\WP\SEO\Context\Meta_Tags_Context;
use Yoast\WP\SEO\Helpers\Image_Helper;
use Yoast\WP\SEO\Helpers\Open_Graph\Image_Helper as Open_Graph_Image_Helper;
use Yoast\WP\SEO\Helpers\Options_Helper;
use Yoast\WP\SEO\Helpers\Url_Helper;
use Yoast\WP\SEO\Models\Indexable;
use Yoast\WP\SEO\Values\Open_Graph\Images;

/**
 * Represents the generator class for the Open Graph images.
 */
class Open_Graph_Image_Generator implements Generator_Interface {

	/**
	 * The Open Graph image helper.
	 *
	 * @var Open_Graph_Image_Helper
	 */
	protected $open_graph_image;

	/**
	 * The image helper.
	 *
	 * @var Image_Helper
	 */
	protected $image;

	/**
	 * The URL helper.
	 *
	 * @var Url_Helper
	 */
	protected $url;

	/**
	 * The options helper.
	 *
	 * @var Options_Helper
	 */
	private $options;

	/**
	 * Images constructor.
	 *
	 * @codeCoverageIgnore
	 *
	 * @param Open_Graph_Image_Helper $open_graph_image Image helper for Open Graph.
	 * @param Image_Helper            $image      