text->indexable->object_sub_type );
			if ( $parent && $parent !== 'post' && $this->post_type_helper->has_archive( $parent ) ) {
				$static_ancestor = $this->repository->find_for_post_type_archive( $parent );
				if ( \is_a( $static_ancestor, Indexable::class ) ) {
					$static_ancestors[] = $static_ancestor;
				}
			}
		}
		$indexables = [];
		if ( ! \in_array( $this->current_page_helper->get_page_type(), [ 'Home_Page', 'Static_Home_Page' ], true ) ) {
			// Get all ancestors of the indexable and append itself to get all indexables in the full crumb.
			$indexables = $this->repository->get_ancestors( $context->indexable );
		}
		$indexables[] = $context->indexable;

		if ( ! empty( $static_ancestors ) ) {
			\array_unshift( $indexables, ...$static_ancestors );
		}

		$indexables = \apply_filters( 'wpseo_breadcrumb_indexables', $indexables, $context );
		$indexables = \is_array( $indexables ) ? $indexables : [];
		$indexables = \array_filter(
			$indexables,
			static function ( $indexable ) {
				return \is_a( $indexable, Indexable::class );
			}
		);

		$crumbs = \array_map( [ $this,'get_post_type_crumb' ], $indexables );

		if ( $breadcrumbs_home !== '' ) {
			$crumbs[0]['text'] = $breadcrumbs_home;
		}

		$crumbs = $this->add_paged_crumb( $crumbs, $context->indexable );

		/**
		 * Filter: 'wpseo_breadcrumb_links' - Allow the developer to filter the Yoast SEO breadcrumb links, add to them, change order, etc.
		 *
		 * @param array $crumbs The crumbs array.
		 */
		$filtered_crumbs = \apply_filters( 'wpseo_breadcrumb_links', $crumbs );

		// Basic check to make sure the filtered crumbs are in an array.
		if ( ! \is_array( $filtered_crumbs ) ) {
			\_doing_it_wrong(
				'Filter: \'wpseo_breadcrumb_links\'',
				'The `wpseo_breadcrumb_links` filter should return a multi-dimensional array.',
				'YoastSEO v20.0'
			);
		}
		else {
			$crumbs = $filtered_crumbs;
		}

		$filter_callback = static function ( $link_info, $index ) use ( $crumbs ) {
			/**
			 * Filter: 'wpseo_breadcrumb_single_link_info' - Allow developers to filter the Yoast SEO Breadcrumb link information.
			 *
			 * @param array $link_info The breadcrumb link information.
			 * @param int   $index     The index of the breadcrumb in the list.
			 * @param array $crumbs    The complete list of breadcrumbs.
			 */
			return \apply_filters( 'wpseo_breadcrumb_single_link_info', $link_info, $index, $crumbs );
		};
		return \array_map( $filter_callback, $crumbs, \array_keys( $crumbs ) );
	}

	/**
	 * Returns the modified post crumb.
	 *
	 * @param string[]  $crumb    The crumb.
	 * @param Indexable $ancestor The indexable.
	 *
	 * @return array<int,string> The crumb.
	 */
	private function get_post_crumb( $crumb, $ancestor ) {
		$crumb['id'] = $ancestor->object_id;

		return $crumb;
	}

	/**
	 * Adds the correct ID to the crumb array based on the ancestor provided.
	 *
	 * @param Indexable $ancestor The ancestor indexable.
	 *
	 * @return string[]
	 */
	private function get_post_type_crumb( Indexable $ancestor ) {
		$crumb = [
			'url'  => $ancestor->permalink,
			'text' => $ancestor->breadcrumb_title,
		];

		switch ( $ancestor->object_type ) {
			case 'post':
				$crumb = $this->get_post_crumb( $crumb, $ancestor );
				break;
			case 'post-type-archive':
				$crumb = $this->get_post_type_archive_crumb( $crumb, $ancestor );
				break;
			case 'term':
				$crumb = $this->get_term_crumb( $crumb, $ancestor );
				break;
			case 'system-page':
				$crumb = $this->get_system_page_crumb( $crumb, $ancestor );
				break;
			case 'user':
				$crumb = $this->get_user_crumb( $crumb, $ancestor );
				break;
			case 'date-archive':
				$crumb = $this->get_date_archive_crumb( $crumb );
				break;
			default:
				// Handle unknown object types (optional).
				break;
		}

		return $crumb;
	}

	/**
	 * Returns the modified post type crumb.
	 *
	 * @param string[]  $crumb    The crumb.
	 * @param Indexable $ancest