plugins/wordpress-seo-extended/src/conditionals/wincher-enabled-conditional.php                     0000644                 00000001343 15122266560 0024163 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

use Yoast\WP\SEO\Helpers\Options_Helper;

/**
 * Conditional that is only met when the Wincher integration is enabled.
 */
class Wincher_Enabled_Conditional implements Conditional {

	/**
	 * The options helper.
	 *
	 * @var Options_Helper
	 */
	private $options;

	/**
	 * Wincher_Enabled_Conditional constructor.
	 *
	 * @param Options_Helper $options The options helper.
	 */
	public function __construct( Options_Helper $options ) {
		$this->options = $options;
	}

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		return $this->options->get( 'wincher_integration_active', false );
	}
}
                                                                                                                                                                                                                                                                                             plugins/wordpress-seo-extended/src/conditionals/wincher-token-conditional.php                       0000644                 00000001250 15122266560 0023706 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

use Yoast\WP\SEO\Config\Wincher_Client;

/**
 * Conditional that is only met when the Wincher token is set.
 */
class Wincher_Token_Conditional implements Conditional {

	/**
	 * The Wincher client.
	 *
	 * @var Wincher_Client
	 */
	private $client;

	/**
	 * Wincher_Token_Conditional constructor.
	 *
	 * @param Wincher_Client $client The Wincher client.
	 */
	public function __construct( Wincher_Client $client ) {
		$this->client = $client;
	}

	/**
	 * Returns whether this conditional is met.
	 *
	 * @return bool Whether the conditional is met.
	 */
	public function is_met() {
		return $this->client->has_valid_tokens();
	}
}
                                                                                                                                                                                                                                                                                                                                                        plugins/wordpress-seo-extended/src/conditionals/woocommerce-conditional.php                         0000644                 00000000634 15122266560 0023455 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when WooCommerce is active.
 */
class WooCommerce_Conditional implements Conditional {

	/**
	 * Returns `true` when the WooCommerce plugin is installed and activated.
	 *
	 * @return bool `true` when the WooCommerce plugin is installed and activated.
	 */
	public function is_met() {
		return \class_exists( 'WooCommerce' );
	}
}
                                                                                                    plugins/wordpress-seo-extended/src/conditionals/wp-cron-enabled-conditional.php                     0000644                 00000000537 15122266560 0024115 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Class that checks if WP_CRON is enabled.
 */
class WP_CRON_Enabled_Conditional implements Conditional {

	/**
	 * Checks if WP_CRON is enabled.
	 *
	 * @return bool True when WP_CRON is enabled.
	 */
	public function is_met() {
		return ! ( \defined( 'DISABLE_WP_CRON' ) && \DISABLE_WP_CRON );
	}
}
                                                                                                                                                                 plugins/wordpress-seo-extended/src/conditionals/wp-robots-conditional.php                           0000644                 00000000525 15122266560 0023071 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Class that checks if wp_robots exists.
 */
class WP_Robots_Conditional implements Conditional {

	/**
	 * Checks if the wp_robots function exists.
	 *
	 * @return bool True when the wp_robots function exists.
	 */
	public function is_met() {
		return \function_exists( 'wp_robots' );
	}
}
                                                                                                                                                                           plugins/wordpress-seo-extended/src/conditionals/xmlrpc-conditional.php                              0000644                 00000000667 15122266560 0022451 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is met when the current request is an XML-RPC request.
 */
class XMLRPC_Conditional implements Conditional {

	/**
	 * Returns whether the current request is an XML-RPC request.
	 *
	 * @return bool `true` when the current request is an XML-RPC request, `false` if not.
	 */
	public function is_met() {
		return ( \defined( 'XMLRPC_REQUEST' ) && \XMLRPC_REQUEST );
	}
}
                                                                         plugins/wordpress-seo-extended/src/conditionals/yoast-admin-and-dashboard-conditional.php           0000644                 00000003170 15122266560 0026046 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php // phpcs:ignore Yoast.Files.FileName.InvalidClassFileName -- Reason: this explicitly concerns the Yoast admin and dashboard.

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when in the admin dashboard, update or Yoast SEO pages.
 */
class Yoast_Admin_And_Dashboard_Conditional implements Conditional {

	/**
	 * Returns `true` when on the admin dashboard, update or Yoast SEO pages.
	 *
	 * @return bool `true` when on the admin dashboard, update or Yoast SEO pages.
	 */
	public function is_met() {
		global $pagenow;

		// Bail out early if we're not on the front-end.
		if ( ! \is_admin() ) {
			return false;
		}

		// Do not output on plugin / theme upgrade pages or when WordPress is upgrading.
		if ( ( \defined( 'IFRAME_REQUEST' ) && \IFRAME_REQUEST ) || $this->on_upgrade_page() || \wp_installing() ) {
			return false;
		}

		if ( $pagenow === 'admin.php' && isset( $_GET['page'] ) && \strpos( $_GET['page'], 'wpseo' ) === 0 ) {
			return true;
		}

		$target_pages = [
			'index.php',
			'plugins.php',
			'update-core.php',
			'options-permalink.php',
		];

		return \in_array( $pagenow, $target_pages, true );
	}

	/**
	 * Checks if we are on a theme or plugin upgrade page.
	 *
	 * @return bool Whether we are on a theme or plugin upgrade page.
	 */
	private function on_upgrade_page() {
		/*
		 * IFRAME_REQUEST is not defined on these pages,
		 * though these action pages do show when upgrading themes or plugins.
		 */
		$actions = [ 'do-theme-upgrade', 'do-plugin-upgrade', 'do-core-upgrade', 'do-core-reinstall' ];
		return isset( $_GET['action'] ) && \in_array( $_GET['action'], $actions, true );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                        plugins/wordpress-seo-extended/src/conditionals/yoast-tools-page-conditional.php                    0000644                 00000001176 15122266560 0024347 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php // phpcs:ignore Yoast.Files.FileName.InvalidClassFileName -- Reason: this explicitly concerns the Yoast tools page.

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when current page is the tools page.
 */
class Yoast_Tools_Page_Conditional implements Conditional {

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		global $pagenow;

		if ( $pagenow !== 'admin.php' ) {
			return false;
		}

		if ( isset( $_GET['page'] ) && $_GET['page'] === 'wpseo_tools' ) {
			return true;
		}

		return false;
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                  plugins/wordpress-seo-extended/src/config/badge-group-names.php                                     0000644                 00000002771 15122266560 0020715 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Config;

/**
 * Class Badge_Group_Names.
 *
 * This class defines groups for "new" badges, with the version in which those groups are no longer considered
 * to be "new".
 */
class Badge_Group_Names {

	public const GROUP_GLOBAL_TEMPLATES = 'global-templates';

	/**
	 * Constant describing when certain groups of new badges will no longer be shown.
	 */
	public const GROUP_NAMES = [
		self::GROUP_GLOBAL_TEMPLATES => '16.7-beta0',
	];

	/**
	 * The current plugin version.
	 *
	 * @var string
	 */
	protected $version;

	/**
	 * Badge_Group_Names constructor.
	 *
	 * @param string|null $version Optional: the current plugin version.
	 */
	public function __construct( $version = null ) {
		if ( ! $version ) {
			$version = \WPSEO_VERSION;
		}
		$this->version = $version;
	}

	/**
	 * Check whether a group of badges is still eligible for a "new" badge.
	 *
	 * @param string      $group           One of the GROUP_* constants.
	 * @param string|null $current_version The current version of the plugin that's being checked.
	 *
	 * @return bool Whether a group of badges is still eligible for a "new" badge.
	 */
	public function is_still_eligible_for_new_badge( $group, $current_version = null ) {
		if ( ! \array_key_exists( $group, $this::GROUP_NAMES ) ) {
			return false;
		}

		$group_version = $this::GROUP_NAMES[ $group ];

		if ( \is_null( $current_version ) ) {
			$current_version = $this->version;
		}

		return (bool) \version_compare( $group_version, $current_version, '>' );
	}
}
       plugins/wordpress-seo-extended/src/config/conflicting-plugins.php                                   0000644                 00000012443 15122266560 0021373 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Config;

/**
 * Conflicting_Plugins class that holds all known conflicting plugins.
 */
class Conflicting_Plugins {

	public const OPEN_GRAPH_PLUGINS = [
		'2-click-socialmedia-buttons/2-click-socialmedia-buttons.php',
		// 2 Click Social Media Buttons.
		'add-link-to-facebook/add-link-to-facebook.php',         // Add Link to Facebook.
		'add-meta-tags/add-meta-tags.php',                       // Add Meta Tags.
		'easy-facebook-share-thumbnails/esft.php',               // Easy Facebook Share Thumbnail.
		'facebook/facebook.php',                                 // Facebook (official plugin).
		'facebook-awd/AWD_facebook.php',                         // Facebook AWD All in one.
		'facebook-featured-image-and-open-graph-meta-tags/fb-featured-image.php',
		// Facebook Featured Image & OG Meta Tags.
		'facebook-meta-tags/facebook-metatags.php',              // Facebook Meta Tags.
		'wonderm00ns-simple-facebook-open-graph-tags/wonderm00n-open-graph.php',
		// Facebook Open Graph Meta Tags for WordPress.
		'facebook-revised-open-graph-meta-tag/index.php',        // Facebook Revised Open Graph Meta Tag.
		'facebook-thumb-fixer/_facebook-thumb-fixer.php',        // Facebook Thumb Fixer.
		'facebook-and-digg-thumbnail-generator/facebook-and-digg-thumbnail-generator.php',
		// Fedmich's Facebook Open Graph Meta.
		'network-publisher/networkpub.php',                      // Network Publisher.
		'nextgen-facebook/nextgen-facebook.php',                 // NextGEN Facebook OG.
		'opengraph/opengraph.php',                               // Open Graph.
		'open-graph-protocol-framework/open-graph-protocol-framework.php',
		// Open Graph Protocol Framework.
		'seo-facebook-comments/seofacebook.php',                 // SEO Facebook Comments.
		'sexybookmarks/sexy-bookmarks.php',                      // Shareaholic.
		'shareaholic/sexy-bookmarks.php',                        // Shareaholic.
		'sharepress/sharepress.php',                             // SharePress.
		'simple-facebook-connect/sfc.php',                       // Simple Facebook Connect.
		'social-discussions/social-discussions.php',             // Social Discussions.
		'social-sharing-toolkit/social_sharing_toolkit.php',     // Social Sharing Toolkit.
		'socialize/socialize.php',                               // Socialize.
		'only-tweet-like-share-and-google-1/tweet-like-plusone.php',
		// Tweet, Like, Google +1 and Share.
		'wordbooker/wordbooker.php',                             // Wordbooker.
		'wpsso/wpsso.php',                                       // WordPress Social Sharing Optimization.
		'wp-caregiver/wp-caregiver.php',                         // WP Caregiver.
		'wp-facebook-like-send-open-graph-meta/wp-facebook-like-send-open-graph-meta.php',
		// WP Facebook Like Send & Open Graph Meta.
		'wp-facebook-open-graph-protocol/wp-facebook-ogp.php',   // WP Facebook Open Graph protocol.
		'wp-ogp/wp-ogp.php',                                     // WP-OGP.
		'zoltonorg-social-plugin/zosp.php',                      // Zolton.org Social Plugin.
	];

	public const XML_SITEMAPS_PLUGINS = [
		'google-sitemap-plugin/google-sitemap-plugin.php',
		// Google Sitemap (BestWebSoft).
		'xml-sitemaps/xml-sitemaps.php',
		// XML Sitemaps (Denis de Bernardy and Mike Koepke).
		'bwp-google-xml-sitemaps/bwp-simple-gxs.php',
		// Better WordPress Google XML Sitemaps (Khang Minh).
		'google-sitemap-generator/sitemap.php',
		// Google XML Sitemaps (Arne Brachhold).
		'xml-sitemap-feed/xml-sitemap.php',
		// XML Sitemap & Google News feeds (RavanH).
		'google-monthly-xml-sitemap/monthly-xml-sitemap.php',
		// Google Monthly XML Sitemap (Andrea Pernici).
		'simple-google-sitemap-xml/simple-google-sitemap-xml.php',
		// Simple Google Sitemap XML (iTx Technologies).
		'another-simple-xml-sitemap/another-simple-xml-sitemap.php',
		// Another Simple XML Sitemap.
		'xml-maps/google-sitemap.php',
		// Xml Sitemap (Jason Martens).
		'google-xml-sitemap-generator-by-anton-dachauer/adachauer-google-xml-sitemap.php',
		// Google XML Sitemap Generator by Anton Dachauer (Anton Dachauer).
		'wp-xml-sitemap/wp-xml-sitemap.php',
		// WP XML Sitemap (Team Vivacity).
		'sitemap-generator-for-webmasters/sitemap.php',
		// Sitemap Generator for Webmasters (iwebslogtech).
		'xml-sitemap-xml-sitemapcouk/xmls.php',
		// XML Sitemap - XML-Sitemap.co.uk (Simon Hancox).
		'sewn-in-xml-sitemap/sewn-xml-sitemap.php',
		// Sewn In XML Sitemap (jcow).
		'rps-sitemap-generator/rps-sitemap-generator.php',
		// RPS Sitemap Generator (redpixelstudios).
	];

	public const CLOAKING_PLUGINS = [
		'rs-head-cleaner/rs-head-cleaner.php',
		// RS Head Cleaner Plus https://wordpress.org/plugins/rs-head-cleaner/.
		'rs-head-cleaner-lite/rs-head-cleaner-lite.php',
		// RS Head Cleaner Lite https://wordpress.org/plugins/rs-head-cleaner-lite/.
	];

	public const SEO_PLUGINS = [
		'all-in-one-seo-pack/all_in_one_seo_pack.php',           // All in One SEO Pack.
		'seo-ultimate/seo-ultimate.php',                         // SEO Ultimate.
		'seo-by-rank-math/rank-math.php',                        // Rank Math.
	];

	/**
	 * Returns the list of all conflicting plugins.
	 *
	 * @return array The list of all conflicting plugins.
	 */
	public static function all_plugins() {
		return \array_merge(
			self::OPEN_GRAPH_PLUGINS,
			self::XML_SITEMAPS_PLUGINS,
			self::CLOAKING_PLUGINS,
			self::SEO_PLUGINS
		);
	}
}
                                                                                                                                                                                                                             plugins/wordpress-seo-extended/src/config/indexing-reasons.php                                      0000644                 00000002443 15122266560 0020671 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Config;

/**
 * Class Indexing_Reasons. Contains constants that aren't context specific.
 */
class Indexing_Reasons {

	/**
	 * Represents the reason that the indexing process failed and should be tried again.
	 */
	public const REASON_INDEXING_FAILED = 'indexing_failed';

	/**
	 * Represents the reason that the permalink settings are changed.
	 */
	public const REASON_PERMALINK_SETTINGS = 'permalink_settings_changed';

	/**
	 * Represents the reason that the category base is changed.
	 */
	public const REASON_CATEGORY_BASE_PREFIX = 'category_base_changed';

	/**
	 * Represents the reason that the tag base is changed.
	 */
	public const REASON_TAG_BASE_PREFIX = 'tag_base_changed';

	/**
	 * Represents the reason that the home url option is changed.
	 */
	public const REASON_HOME_URL_OPTION = 'home_url_option_changed';

	/**
	 * Represents the reason that a post type has been made public.
	 */
	public const REASON_POST_TYPE_MADE_PUBLIC = 'post_type_made_public';

	/**
	 * Represents the reason that a post type has been made viewable.
	 */
	public const REASON_TAXONOMY_MADE_PUBLIC = 'taxonomy_made_public';

	/**
	 * Represents the reason that attachments have stopped being redirected.
	 */
	public const REASON_ATTACHMENTS_MADE_ENABLED = 'attachments_made_enabled';
}
                                                                                                                                                                                                                             plugins/wordpress-seo-extended/src/config/migrations/20171228151840_WpYoastIndexable.php            0000644                 00000014256 15122266560 0024470 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Config\Migrations;

use Yoast\WP\Lib\Migrations\Migration;
use Yoast\WP\Lib\Model;

/**
 * Indexable migration.
 */
class WpYoastIndexable extends Migration {

	/**
	 * The plugin this migration belongs to.
	 *
	 * @var string
	 */
	public static $plugin = 'free';

	/**
	 * Migration up.
	 *
	 * @return void
	 */
	public function up() {
		$this->add_table();
	}

	/**
	 * Migration down.
	 *
	 * @return void
	 */
	public function down() {
		$this->drop_table( $this->get_table_name() );
	}

	/**
	 * Creates the indexable table.
	 *
	 * @return void
	 */
	private function add_table() {
		$table_name = $this->get_table_name();

		$indexable_table = $this->create_table( $table_name );

		// Permalink.
		$indexable_table->column( 'permalink', 'mediumtext', [ 'null' => true ] );
		$indexable_table->column(
			'permalink_hash',
			'string',
			[
				'null'  => true,
				'limit' => 191,
			]
		);

		// Object information.
		$indexable_table->column(
			'object_id',
			'integer',
			[
				'unsigned' => true,
				'null'     => true,
				'limit'    => 11,
			]
		);
		$indexable_table->column(
			'object_type',
			'string',
			[
				'null'  => false,
				'limit' => 32,
			]
		);
		$indexable_table->column(
			'object_sub_type',
			'string',
			[
				'null'  => true,
				'limit' => 32,
			]
		);

		// Owner