<?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when the current user has the `wpseo_manage_options` capability.
 *
 * @phpcs:disable Yoast.NamingConventions.ObjectNameDepth.MaxExceeded
 */
class User_Can_Manage_Wpseo_Options_Conditional implements Conditional {

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		return \current_user_can( 'wpseo_manage_options' );
	}
}
      plugins/wordpress-seo-extended/src/conditionals/user-can-publish-posts-and-pages-conditional.php    0000644                 00000001036 15122266557 0027325 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when the current user has the `wpseo_manage_options` capability.
 *
 * @phpcs:disable Yoast.NamingConventions.ObjectNameDepth.MaxExceeded
 */
class User_Can_Publish_Posts_And_Pages_Conditional implements Conditional {

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		return \current_user_can( 'publish_posts' ) && \current_user_can( 'publish_pages' );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  plugins/wordpress-seo-extended/src/conditionals/user-profile-conditional.php                        0000644                 00000001041 15122266560 0023543 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php // phpcs:ignore Yoast.Files.FileName.InvalidClassFileName -- Reason: this explicitly concerns the Yoast tools page.

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when current page is the tools page.
 */
class User_Profile_Conditional implements Conditional {

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		global $pagenow;

		if ( $pagenow !== 'profile.php' ) {
			return false;
		}

		return true;
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               plugins/wordpress-seo-extended/src/conditionals/web-stories-conditional.php                         0000644                 00000000670 15122266560 0023401 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when Web Stories are active.
 */
class Web_Stories_Conditional implements Conditional {

	/**
	 * Returns `true` when the Web Stories plugins is installed and active.
	 *
	 * @return bool `true` when the Web Stories plugins is installed and active.
	 */
	public function is_met() {
		return \function_exists( '\Google\Web_Stories\get_plugin_instance' );
	}
}
                                                                        plugins/wordpress-seo-extended/src/conditionals/wincher-automatically-track-conditional.php         0000644                 00000001367 15122266560 0026551 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

use Yoast\WP\SEO\Helpers\Options_Helper;

/**
 * Conditional that is only met when the Wincher automatic tracking is enabled.
 */
class Wincher_Automatically_Track_Conditional implements Conditional {

	/**
	 * The options helper.
	 *
	 * @var Options_Helper
	 */
	private $options;

	/**
	 * Wincher_Automatically_Track_Conditional constructor.
	 *
	 * @param Options_Helper $options The options helper.
	 */
	public function __construct( Options_Helper $options ) {
		$this->options = $options;
	}

	/**
	 * Returns whether this conditional is met.
	 *
	 * @return bool Whether the conditional is met.
	 */
	public function is_met() {
		return $this->options->get( 'wincher_automatically_add_keyphrases' );
	}
}
                                                                                                                                                                                                                                                                         plugins/wordpress