<?php

namespace Yoast\WP\SEO\Conditionals\Third_Party;

use Yoast\WP\SEO\Conditionals\Conditional;
use Yoast\WP\SEO\Helpers\Wordproof_Helper;

/**
 * Conditional that is met when the WordProof integration is toggled on.
 */
class Wordproof_Integration_Active_Conditional implements Conditional {

	/**
	 * The WordProof helper.
	 *
	 * @var Wordproof_Helper
	 */
	private $wordproof;

	/**
	 * WordProof integration active constructor.
	 *
	 * @param Wordproof_Helper $wordproof The options helper.
	 */
	public function __construct( Wordproof_Helper $wordproof ) {
		$this->wordproof = $wordproof;
	}

	/**
	 * Returns whether or not the WordProof Timestamp plugin is active.
	 *
	 * @return bool Whether or not the WordProof Timestamp plugin is active.
	 */
	public function is_met() {
		return $this->wordproof->integration_is_active();
	}
}
                                                                                                                                                                                  wordpress-seo-extended/src/conditionals/third-party/wordproof-plugin-inactive-conditional.php       0000644                 00000000751 15122266557 0030451 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace Yoast\WP\SEO\Conditionals\Third_Party;

use Yoast\WP\SEO\Conditionals\Conditional;

/**
 * Conditional that is met when the WordProof Timestamp plugin is inactive.
 */
class Wordproof_Plugin_Inactive_Conditional implements Conditional {

	/**
	 * Returns whether or not the WordProof Timestamp plugin is active.
	 *
	 * @return bool Whether or not the WordProof Timestamp plugin is active.
	 */
	public function is_met() {
		return ! \defined( 'WORDPROOF_VERSION' );
	}
}
                       plugins/wordpress-seo-extended/src/conditionals/third-party/wpml-conditional.php                    0000644                 00000000627 15122266557 0024374 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals\Third_Party;

use Yoast\WP\SEO\Conditionals\Conditional;

/**
 * Conditional that is only met when WPML is active.
 */
class WPML_Conditional implements Conditional {

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		return \defined( 'WPML_PLUGIN_FILE' );
	}
}
                                                                                                         plugins/wordpress-seo-extended/src/conditionals/third-party/wpml-wpseo-conditional.php              0000644                 00000001310 15122266557 0025515 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals\Third_Party;

use Yoast\WP\SEO\Conditionals\Conditional;

/**
 * Conditional that is met when the Yoast SEO Multilingual plugin,
 * a glue plugin developed by and for WPML, is active.
 */
class WPML_WPSEO_Conditional implements Conditional {

	/**
	 * Path to the Yoast SEO Multilingual plugin file.
	 *
	 * @internal
	 */
	public const PATH_TO_WPML_WPSEO_PLUGIN_FILE = 'wp-seo-multilingual/plugin.php';

	/**
	 * Returns whether or not the Yoast SEO Multilingual plugin is active.
	 *
	 * @return bool Whether or not the Yoast SEO Multilingual plugin is active.
	 */
	public function is_met() {
		return \is_plugin_active( self::PATH_TO_WPML_WPSEO_PLUGIN_FILE );
	}
}
                                                                                                                                                                                                                                                                                                                        plugins/wordpress-seo-extended/src/conditionals/traits/admin-conditional-trait.php                  0000644                 00000000733 15122266557 0024663 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals\Traits;

use Yoast\WP\SEO\Conditionals\Admin_Conditional;

/**
 * Trait for all integration that rely on the Admin-conditional
 */
trait Admin_Conditional_Trait {

	/**
	 * Returns an empty array, meaning no conditionals are required to load whatever uses this trait.
	 *
	 * @return array The conditionals that must be met to load this.
	 */
	public static function get_conditionals() {
		return [ Admin_Conditional::class ];
	}
}
                                     plugins/wordpress-seo-extended/src/conditionals/updated-importer-framework-conditional.php          0000644                 00000000637 15122266557 0026427 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Feature flag conditional for the updated importer framework.
 */
class Updated_Importer_Framework_Conditional extends Feature_Flag_Conditional {

	/**
	 * Returns the name of the updat