<?php

namespace Yoast\WP\SEO\Conditionals;

use Yoast\WP\SEO\Config\Migration_Status;

/**
 * Class for integrations that depend on having all migrations run.
 */
class Migrations_Conditional implements Conditional {

	/**
	 * The migration status.
	 *
	 * @var Migration_Status
	 */
	protected $migration_status;

	/**
	 * Migrations_Conditional constructor.
	 *
	 * @param Migration_Status $migration_status The migration status object.
	 */
	public function __construct( Migration_Status $migration_status ) {
		$this->migration_status = $migration_status;
	}

	/**
	 * Returns `true` when all database migrations have been run.
	 *
	 * @return bool `true` when all database migrations have been run.
	 */
	public function is_met() {
		return $this->migration_status->is_version( 'free', \WPSEO_VERSION );
	}
}
                                                                                                                                                                                                                 plugins/wordpress-seo-extended/src/conditionals/news-conditional.php                                0000644                 00000000550 15122266557 0022115 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when news SEO is activated.
 */
class News_Conditional implements Conditional {

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		return \defined( 'WPSEO_NEWS_VERSION' );
	}
}
                                                                                                                                                        plugins/wordpress-seo-extended/src/conditionals/new-settings-ui-conditional.php                     0000644                 00000000543 15122266557 0024205 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Feature flag conditional for the new settings UI.
 */
class New_Settings_Ui_Conditional extends Feature_Flag_Conditional {

	/**
	 * Returns the name of the feature flag.
	 *
	 * @return string The name of the feature flag.
	 */
	protected function get_feature_flag() {
		return 'NEW_SETTINGS_UI';
	}
}
                                                                                                                                                             plugins/wordpress-seo-extended/src/conditionals/no-conditionals-trait.php                           0000644                 00000000575 15122266557 0023070 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Trait for integrations that do not have any conditionals.
 */
trait No_Conditionals {

	/**
	 * Returns an empty array, meaning no conditionals are required to load whatever uses this trait.
	 *
	 * @return array The conditionals that must be met to load this.
	 */
	public static function get_conditionals() {
		return [];
	}
}
                                                                                                                                   plugins/wordpress-seo-extended/src/conditionals/non-multisite-conditional.php                       0000644                 00000000564 15122266557 0023755 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when we aren't in a multisite setup.
 */
class Non_Multisite_Conditional implements Conditional {

	/**
	 * Returns `true` when we aren't in a multisite setup.
	 *
	 * @return bool `true` when we aren't in a multisite setup.
	 */
	public function is_met() {
		return ! \is_multisite();
	}
}
                                                                                                                                            plugins/wordpress-seo-extended/src/conditionals/not-admin-ajax-conditional.php                      0000644                 00000000556 15122266557 0023756 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when not in a admin-ajax request.
 */
class Not_Admin_Ajax_Conditional implements Conditional {

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		return ( ! \wp_doing_ajax() );
	}
}
                                                                                                                                                  plugins/wordpress-seo-extended/src/conditionals/no-tool-selected-conditional.php                    0000644                 00000000775 15122266557 0024327 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when current page is not a specific tool's page.
 */
class No_Tool_Selected_Conditional implements Conditional {

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- We just check whether a URL parameter does not exist.
		return ! isset( $_GET['tool'] );
	}
}
   plugins/wordpress-seo-extended/src/conditionals/open-graph-conditional.php                          0000644                 00000001330 15122266557 0023176 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

use Yoast\WP\SEO\Helpers\Options_Helper;

/**
 * Conditional that is only met when the Open Graph feature is enabled.
 */
class Open_Graph_Conditional implements Conditional {

	/**
	 * The options helper.
	 *
	 * @var Options_Helper
	 */
	private $options;

	/**
	 * Open_Graph_Conditional constructor.
	 *
	 * @param Options_Helper $options The options helper.
	 */
	public function __construct( Options_Helper $options ) {
		$this->options = $options;
	}

	/**
	 * Returns `true` when the Open Graph feature is enabled.
	 *
	 * @return bool `true` when the Open Graph feature is enabled.
	 */
	public function is_met() {
		return $this->options->get( 'opengraph' ) === true;
	}
}
                                                                                                                                                                                                                                                                                                        plugins/wordpress-seo-extended/src/conditionals/premium-active-conditional.php                      0000644                 00000000546 15122266557 0024075 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Class Premium_Active_Conditional.
 */
class Premium_Active_Conditional implements Conditional {

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		return \YoastSEO()->helpers->product->is_premium();
	}
}
                                                                                                                                                          plugins/wordpress-seo-extended/src/conditionals/premium-inactive-conditional.php                    0000644                 00000000611 15122266557 0024415 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Abstract class for creating conditionals based on feature flags.
 */
class Premium_Inactive_Conditional implements Conditional {

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		return ! \YoastSEO()->helpers->product->is_premium();
	}
}
                                                                                                                       plugins/wordpress-seo-extended/src/conditionals/primary-category-conditional.php                    0000644                 00000002621 15122266557 0024440 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

use Yoast\WP\SEO\Helpers\Current_Page_Helper;

/**
 * Conditional that is only met when in frontend or page is a post overview or post add/edit form.
 */
class Primary_Category_Conditional implements Conditional {

	/**
	 * The current page helper.
	 *
	 * @var Current_Page_Helper
	 */
	private $current_page;

	/**
	 * Primary_Category_Conditional constructor.
	 *
	 * @param Current_Page_Helper $current_page The current page helper.
	 */
	public function __construct( Current_Page_Helper $current_page ) {
		$this->current_page = $current_page;
	}

	/**
	 * Returns `true` when on the frontend,
	 * or when on the post overview, post edit or new post admin page,
	 * or when on additional admin pages, allowed by filter.
	 *
	 * @return bool `true` when on the frontend, or when on the post overview,
	 *          post edit, new post admin page or additional admin pages, allowed by filter.
	 */
	public function is_met() {
		if ( ! \is_admin() ) {
			return true;
		}

		/**
		 * Filter: Adds the possibility to use primary category at additional admin pages.
		 *
		 * @param array $admin_pages List of additional admin pages.
		 */
		$additional_pages = \apply_filters( 'wpseo_primary_category_admin_pages', [] );
		return \in_array( $this->current_page->get_current_admin_page(), \array_merge( [ 'edit.php', 'post.php', 'post-new.php' ], $additional_pages ), true );
	}
}
                                                                                                               plugins/wordpress-seo-extended/src/conditionals/robots-txt-conditional.php                          0000644                 00000003312 15122266557 0023265 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when on the front end or Yoast file editor page.
 */
class Robots_Txt_Conditional implements Conditional {

	/**
	 * Holds the Front_End_Conditional instance.
	 *
	 * @var Front_End_Conditional
	 */
	protected $front_end_conditional;

	/**
	 * Constructs the class.
	 *
	 * @param Front_End_Conditional $front_end_conditional The front end conditional.
	 */
	public function __construct( Front_End_Conditional $front_end_conditional ) {
		$this->front_end_conditional = $front_end_conditional;
	}

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		return $this->front_end_conditional->is_met() || $this->is_file_editor_page();
	}

	/**
	 * Returns whether the current page is the file editor page.
	 *
	 * This checks for two locations:
	 * - Multisite network admin file editor page
	 * - Single site file editor page (under tools)
	 *
	 * @return bool
	 */
	protected function is_file_editor_page() {
		global $pagenow;

		if ( $pagenow !== 'admin.php' ) {
			return false;
		}

		// phpcs:ignore WordPress.Security.NonceVerification -- This is not a form.
		if ( isset( $_GET['page'] ) && $_GET['page'] === 'wpseo_files' && \is_multisite() && \is_network_admin() ) {
			return true;
		}

		// phpcs:ignore WordPress.Security.NonceVerification -- This is not a form.
		if ( ! ( isset( $_GET['page'] ) && $_GET['page'] === 'wpseo_tools' ) ) {
			return false;
		}

		// phpcs:ignore WordPress.Security.NonceVerification -- This is not a form.
		if ( isset( $_GET['tool'] ) && $_GET['tool'] === 'file-editor' ) {
			return true;
		}

		return false;
	}
}
                                                                                                                                                                                                                                                                                                                      plugins/wordpress-seo-extended/src/conditionals/semrush-enabled-conditional.php                     0000644                 00000001343 15122266557 0024220 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

use Yoast\WP\SEO\Helpers\Options_Helper;

/**
 * Conditional that is only met when the SEMrush integration is enabled.
 */
class SEMrush_Enabled_Conditional implements Conditional {

	/**
	 * The options helper.
	 *
	 * @var Options_Helper
	 */
	private $options;

	/**
	 * SEMrush_Enabled_Conditional constructor.
	 *
	 * @param Options_Helper $options The options helper.
	 */
	public function __construct( Options_Helper $options ) {
		$this->options = $options;
	}

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		return $this->options->get( 'semrush_integration_active', false );
	}
}
                                                                                                                                                                                                                                                                                             plugins/wordpress-seo-extended/src/conditionals/settings-conditional.php                            0000644                 00000001740 15122266557 0023003 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Class Settings_Conditional.
 */
class Settings_Conditional implements Conditional {

	/**
	 * Holds User_Can_Manage_Wpseo_Options_Conditional.
	 *
	 * @var User_Can_Manage_Wpseo_Options_Conditional
	 */
	protected $user_can_manage_wpseo_options_conditional;

	/**
	 * Constructs Settings_Conditional.
	 *
	 * @param User_Can_Manage_Wpseo_Options_Conditional $user_can_manage_wpseo_options_conditional The User_Can_Manage_Wpseo_Options_Conditional.
	 */
	public function __construct(
		User_Can_Manage_Wpseo_Options_Conditional $user_can_manage_wpseo_options_conditional
	) {
		$this->user_can_manage_wpseo_options_conditional = $user_can_manage_wpseo_options_conditional;
	}

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		if ( ! $this->user_can_manage_wpseo_options_conditional->is_met() ) {
			return false;
		}

		return true;
	}
}
                                plugins/wordpress-seo-extended/src/conditionals/should-index-links-conditional.php                  0000644                 00000002026 15122266557 0024662 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

use Yoast\WP\SEO\Helpers\Options_Helper;

/**
 * Should_Index_Links_Conditional class.
 */
class Should_Index_Links_Conditional implements Conditional {

	/**
	 * The options helper.
	 *
	 * @var Options_Helper
	 */
	protected $options_helper;

	/**
	 * Should_Index_Links_Conditional constructor.
	 *
	 * @param Options_Helper $options_helper The options helper.
	 */
	public function __construct( Options_Helper $options_helper ) {
		$this->options_helper = $options_helper;
	}

	/**
	 * Returns `true` when the links on this website should be indexed.
	 *
	 * @return bool `true` when the links on this website should be indexed.
	 */
	public function is_met() {
		$should_index_links = $this->options_helper->get( 'enable_text_link_counter' );

		/**
		 * Filter: 'wpseo_should_index_links' - Allows disabling of Yoast's links indexation.
		 *
		 * @param bool $enable To disable the indexation, return false.
		 */
		return \apply_filters( 'wpseo_should_index_links', $should_index_links );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          plugins/wordpress-seo-extended/src/conditionals/text-formality-conditional.php                      0000644                 00000000661 15122266557 0024134 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Checks if the YOAST_SEO_TEXT_FORMALITY constant is set.
 */
class Text_Formality_Conditional extends Feature_Flag_Conditional {

	/**
	 * Returns the name of the feature flag.
	 * 'YOAST_SEO_' is automatically prepended to it and it will be uppercased.
	 *
	 * @return string the name of the feature flag.
	 */
	public function get_feature_flag() {
		return 'TEXT_FORMALITY';
	}
}
                                                                               plugins/wordpress-seo-extended/src/conditionals/third-party/elementor-activated-conditional.php     0000644                 00000000745 15122266557 0027352 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals\Third_Party;

use Yoast\WP\SEO\Conditionals\Conditional;

/**
 * Conditional that is met when the Elementor plugin is installed and activated.
 */
class Elementor_Activated_Conditional implements Conditional {

	/**
	 * Checks if the Elementor plugins is installed and activated.
	 *
	 * @return bool `true` when the Elementor plugin is installed and activated.
	 */
	public function is_met() {
		return \defined( 'ELEMENTOR__FILE__' );
	}
}
                           plugins/wordpress-seo-extended/src/conditionals/third-party/elementor-edit-conditional.php          0000644                 00000003017 15122266557 0026326 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals\Third_Party;

use Yoast\WP\SEO\Conditionals\Conditional;

/**
 * Conditional that is only met when on an Elementor edit page or when the current
 * request is an ajax request for saving our post meta data.
 */
class Elementor_Edit_Conditional implements Conditional {

	/**
	 * Returns whether this conditional is met.
	 *
	 * @return bool Whether the conditional is met.
	 */
	public function is_met() {
		global $pagenow;

		// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Reason: We are not processing form information.
		if ( isset( $_GET['action'] ) && \is_string( $_GET['action'] ) ) {
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended,WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Reason: We are not processing form information, We are only strictly comparing.
			$get_action = \wp_unslash( $_GET['action'] );
			if ( $pagenow === 'post.php' && $get_action === 'elementor' ) {
				return true;
			}
		}

		// phpcs:ignore WordPress.Security.NonceVerification.Missing -- Reason: We are not processing form information.
		if ( isset( $_POST['action'] ) && \is_string( $_POST['action'] ) ) {
			// phpcs:ignore WordPress.Security.NonceVerification.Missing,WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Reason: We are not processing form information, We are only strictly comparing.
			$post_action = \wp_unslash( $_POST['action'] );
			return \wp_doing_ajax() && $post_action === 'wpseo_elementor_save';
		}

		return false;
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 plugins/wordpress-seo-extended/src/conditionals/third-party/jetpack-boost-active-conditional.php    0000644                 00000001037 15122266557 0027427 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals\Third_Party;

use Yoast\WP\SEO\Conditionals\Conditional;

/**
 * Conditional that is only met when Jetpack_Boost exists.
 */
class Jetpack_Boost_Active_Conditional implements Conditional {

	/**
	 * Returns `true` when the Jetpack_Boost class exists within this WordPress installation.
	 *
	 * @return bool `true` when the Jetpack_Boost class exists within this WordPress installation.
	 */
	public function is_met() {
		return \class_exists( '\Automattic\Jetpack_Boost\Jetpack_Boost', false );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 wordpress-seo-extended/src/conditionals/third-party/jetpack-boost-not-premium-conditional.php       0000644                 00000001537 15122266557 0030356 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                 