plugins/wordpress-seo-extended/src/conditionals/feature-flag-conditional.php                        0000644                 00000001617 15122266557 0023510 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Abstract class for creating conditionals based on feature flags.
 */
abstract class Feature_Flag_Conditional implements Conditional {

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		$feature_flag = \strtoupper( $this->get_feature_flag() );

		return \defined( 'YOAST_SEO_' . $feature_flag ) && \constant( 'YOAST_SEO_' . $feature_flag ) === true;
	}

	/**
	 * Returns the name of the feature flag.
	 * 'YOAST_SEO_' is automatically prepended to it and it will be uppercased.
	 *
	 * @return string the name of the feature flag.
	 */
	abstract protected function get_feature_flag();

	/**
	 * Returns the feature name.
	 *
	 * @return string the name of the feature flag.
	 */
	public function get_feature_name() {
		return $this->get_feature_flag();
	}
}
                                                                                                                 plugins/wordpress-seo-extended/src/conditionals/front-end-conditional.php                           0000644                 00000000512 15122266557 0023033 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when NOT in the admin.
 */
class Front_End_Conditional implements Conditional {

	/**
	 * Returns `true` when NOT on an admin page.
	 *
	 * @return bool `true` when NOT on an admin page.
	 */
	public function is_met() {
		return ! \is_admin();
	}
}
                                                                                                                                                                                      plugins/wordpress-seo-extended/src/conditionals/get-request-conditional.php                         0000644                 00000000722 15122266557 0023407 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

/**
 * Conditional that is only met when the current request uses the GET method.
 */
class Get_Request_Conditional implements Conditional {

	/**
	 * Returns whether or not this conditional is met.
	 *
	 * @return bool Whether or not the conditional is met.
	 */
	public function is_met() {
		if ( isset( $_SERVER['REQUEST_METHOD'] ) && $_SERVER['REQUEST_METHOD'] === 'GET' ) {
			return true;
		}

		return false;
	}
}
                                              plugins/wordpress-seo-extended/src/conditionals/headless-rest-endpoints-enabled-conditional.php     0000644                 00000001457 15122266557 0027304 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Conditionals;

use Yoast\WP\SEO\Helpers\Options_Helper;

/**
 * Conditional that is only met when the headless rest endpoints are enabled.
 */
class Headless_Rest_Endpoints_Enabled_Conditional implements Conditional {

	/**
	 * The options helper.
	 *
