plugins/wordpress-seo-extended/inc/class-wpseo-admin-bar-menu.php                                   0000644                 00000064450 15122266556 0021176 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO
 */

use Yoast\WP\SEO\Helpers\Product_Helper;
use Yoast\WP\SEO\Helpers\Score_Icon_Helper;
use Yoast\WP\SEO\Integrations\Support_Integration;
use Yoast\WP\SEO\Models\Indexable;
use Yoast\WP\SEO\Presenters\Admin\Premium_Badge_Presenter;
use Yoast\WP\SEO\Promotions\Application\Promotion_Manager;
use Yoast\WP\SEO\Repositories\Indexable_Repository;

/**
 * Class for the Yoast SEO admin bar menu.
 */
class WPSEO_Admin_Bar_Menu implements WPSEO_WordPress_Integration {

	/**
	 * The identifier used for the menu.
	 *
	 * @var string
	 */
	public const MENU_IDENTIFIER = 'wpseo-menu';

	/**
	 * The identifier used for the Keyword Research submenu.
	 *
	 * @var string
	 */
	public const KEYWORD_RESEARCH_SUBMENU_IDENTIFIER = 'wpseo-kwresearch';

	/**
	 * The identifier used for the Analysis submenu.
	 *
	 * @var string
	 */
	public const ANALYSIS_SUBMENU_IDENTIFIER = 'wpseo-analysis';

	/**
	 * The identifier used for the Settings submenu.
	 *
	 * @var string
	 */
	public const SETTINGS_SUBMENU_IDENTIFIER = 'wpseo-settings';

	/**
	 * The identifier used for the Network Settings submenu.
	 *
	 * @var string
	 */
	public const NETWORK_SETTINGS_SUBMENU_IDENTIFIER = 'wpseo-network-settings';

	/**
	 * Asset manager instance.
	 *
	 * @var WPSEO_Admin_Asset_Manager
	 */
	protected $asset_manager;

	/**
	 * Holds the Score_Icon_Helper instance.
	 *
	 * @var Score_Icon_Helper
	 */
	protected $indexable_repository;

	/**
	 * Holds the Score_Icon_Helper instance.
	 *
	 * @var Score_Icon_Helper
	 */
	protected $score_icon_helper;

	/**
	 * Holds the Product_Helper instance.
	 *
	 * @var Product_Helper
	 */
	protected $product_helper;

	/**
	 * Holds the shortlinker instance.
	 *
	 * @var WPSEO_Shortlinker
	 */
	protected $shortlinker;

	/**
	 * Whether SEO Score is enabled.
	 *
	 * @var bool
	 */
	protected $is_seo_enabled = null;

	/**
	 * Whether readability is enabled.
	 *
	 * @var bool
	 */
	protected $is_readability_enabled = null;

	/**
	 * The indexable for the current WordPress page, if found.
	 *
	 * @var bool|Indexable
	 */
	protected $current_indexable = null;

	/**
	 * Constructs the WPSEO_Admin_Bar_Menu.
	 *
	 * @param WPSEO_Admin_Asset_Manager|null $asset_manager        Optional. Asset manager to use.
	 * @param Indexable_Repository|null      $indexable_repository Optional. The Indexable_Repository.
	 * @param Score_Icon_Helper|null         $score_icon_helper    Optional. The Score_Icon_Helper.
	 * @param Product_Helper|null            $product_helper       Optional. The product helper.
	 * @param WPSEO_Shortlinker|null         $shortlinker          The shortlinker.
	 */
	public function __construct(
		?WPSEO_Admin_Asset_Manager $asset_manager = null,
		?Indexable_Repository $indexable_repository = null,
		?Score_Icon_Helper $score_icon_helper = null,
		?Product_Helper $product_helper = null,
		?WPSEO_Shortlinker $shortlinker = null
	) {
		if ( ! $asset_manager ) {
			$asset_manager = new WPSEO_Admin_Asset_Manager();
		}
		if ( ! $indexable_repository ) {
			$indexable_repository = YoastSEO()->classes->get( Indexable_Repository::class );
		}
		if ( ! $score_icon_helper ) {
			$score_icon_helper = YoastSEO()->helpers->score_icon;
		}
		if ( ! $product_helper ) {
			$product_helper = YoastSEO()->helpers->product;
		}
		if ( ! $shortlinker ) {
			$shortlinker = new WPSEO_Shortlinker();
		}

		$this->product_helper       = $product_helper;
		$this->asset_manager        = $asset_manager;
		$this->indexable_repository = $indexable_repository;
		$this->score_icon_helper    = $score_icon_helper;
		$this->shortlinker          = $shortlinker;
	}

	/**
	 * Get