 WPSEO_Bulk_List_Table $table The table to render.
 * @param string                $id    The id for the tab.
 *
 * @return void
 */
function wpseo_get_rendered_tab( $table, $id ) {
	?>
	<div id="<?php echo esc_attr( $id ); ?>" class="wpseotab">
		<?php
		$table->show_page();
		?>
	</div>
	<?php
}

?>
<script>
	<?php /* phpcs:ignore WordPress.Security.EscapeOutput -- WPSEO_Utils::format_json_encode is safe. */ ?>
	var wpseoBulkEditorNonce = <?php echo WPSEO_Utils::format_json_encode( wp_create_nonce( 'wpseo-bulk-editor' ) ); ?>;

	// eslint-disable-next-line
	var wpseo_bulk_editor_nonce = wpseoBulkEditorNonce;
</script>

<br/><br/>

<div class="wpseo_table_page">

	<h2 class="nav-tab-wrapper" id="wpseo-tabs">
		<a class="nav-tab" id="title-tab" href="#top#title"><?php esc_html_e( 'Title', 'wordpress-seo' ); ?></a>
		<a class="nav-tab" id="description-tab"
			href="#top#description"><?php esc_html_e( 'Description', 'wordpress-seo' ); ?></a>
	</h2>

	<div class="tabwrapper">
		<?php wpseo_get_rendered_tab( $wpseo_bulk_titles_table, 'title' ); ?>
		<?php wpseo_get_rendered_tab( $wpseo_bulk_description_table, 'description' ); ?>
	</div>
</div>
                                                                                                                                                                                                                                                                                                                                                                                          plugins/wordpress-seo-extended/admin/views/tool-file-editor.php                                     0000644                 00000015356 15122266555 0020776 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 */

if ( ! defined( 'WPSEO_VERSION' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

$yform     = Yoast_Form::get_instance();
$home_path = get_home_path();

if ( ! is_writable( $home_path ) && ! empty( $_SERVER['DOCUMENT_ROOT'] ) ) {
	$home_path = $_SERVER['DOCUMENT_ROOT'] . DIRECTORY_SEPARATOR;
}

$robots_file    = $home_path . 'robots.txt';
$ht_access_file = $home_path . '.htaccess';

if ( isset( $_POST['create_robots'] ) ) {
	if ( ! current_user_can( 'edit_files' ) ) {
		$die_msg = sprintf(
			/* translators: %s expands to robots.txt. */
			__( 'You cannot create a %s file.', 'wordpress-seo' ),
			'robots.txt'
		);
		die( esc_html( $die_msg ) );
	}

	check_admin_referer( 'wpseo_create_robots' );

	ob_start();
	error_reporting( 0 );
	do_robots();
	$robots_content = ob_get_clean();

	$f = fopen( $robots_file, 'x' );
	fwrite( $f, $robots_content );
}

if ( isset( $_POST['submitrobots'] ) ) {
	if ( ! current_user_can( 'edit_files' ) ) {
		$die_msg = sprintf(
			/* translators: %s expands to robots.txt. */
			__( 'You cannot edit the %s file.', 'wordpress-seo' ),
			'robots.txt'
		);
		die( esc_html( $die_msg ) );
	}

	check_admin_referer( 'wpseo-robotstxt' );

	if ( isset( $_POST['robotsnew'] ) && file_exists( $robots_file ) ) {
		$robotsnew = sanitize_textarea_field( wp_unslash( $_POST['robotsnew'] ) );
		if ( is_writable( $robots_file ) ) {
			$f = fopen( $robots_file, 'w+' );
			fwrite( $f, $robotsnew );
			fclose( $f );
			$msg = sprintf(
				/* translators: %s expands to robots.txt. */
				__( 'Updated %s', 'wordpress-seo' ),
				'robots.txt'
			);
		}
	}
}

if ( isset( $_POST['submithtaccess'] ) ) {
	if ( ! current_user_can( 'edit_files' ) ) {
		$die_msg = sprintf(
			/* translators: %s expands to ".htaccess". */
			__( 'You cannot edit the %s file.', 'wordpress-seo' ),
			'.htaccess'
		);
		die( esc_html( $die_msg ) );
	}

	check_admin_referer( 'wpseo-htaccess' );

	if ( isset( $_POST['htaccessnew'] ) && file_exists( $ht_access_file ) ) {
		$ht_access_new = wp_unslash( $_POST['htaccessnew'] );
		if ( is_writable( $ht_access_file ) ) {
			$f = fopen( $ht_access_file, 'w+' );
			fwrite( $f, $ht_access_new );
			fclose( $f );
		}
	}
}

if ( is_multisite() ) {
	$action_url = network_admin_url( 'admin.php?page=wpseo_files' );
	$yform->admin_header( false, 'wpseo_ms' );
}
else {
	$action_url = admin_url( 'admin.php?page=wpseo_tools&tool=file-editor' );
}

if ( isset( $msg ) && ! empty( $msg ) ) {
	echo '<div id="message" class="notice notice-success"><p>', esc_html( $msg ), '</p></div>';
}

// N.B.: "robots.txt" is a fixed file name and should not be translatable.
echo '<h2>robots.txt</h2>';

if ( ! file_exists( $robots_file ) ) {
	if ( is_writable( $home_path ) ) {
		echo '<form action="', esc_url( $action_url ), '" method="post" id="robotstxtcreateform">';
		wp_nonce_field( 'wpseo_create_robots', '_wpnonce', true, true );
		echo '<p>';
		printf(
			/* translators: %s expands to robots.txt. */
			esc_html__( 'You don\'t have a %s file, create one here:', 'wordpress-seo' ),
			'robots.txt'
		);
		echo '</p>';

		printf(
			'<input type="submit" class="button" name="create_robots" value="%s">',
			sprintf(
				/* translators: %s expands to robots.txt. */
				esc_attr__( 'Create %s file', 'wordpress-seo' ),
				'robots.txt'
			)
		);
		echo '</form>';
	}
	else {
		echo '<p>';
		printf(
			/* translators: %s expands to robots.txt. */
			esc_html__( 'If you had a %s file and it was editable, you could edit it from here.', 'wordpress-seo' ),
			'robots.txt'
		);
		echo '</p>';
	}
}
else {
	$f = fopen( $robots_file, 'r' );

	$content = '';
	if ( filesize( $robots_file ) > 0 ) {
		$content = fread( $f, filesize( $robots_file ) );
	}

	if ( ! is_writable( $robots_file ) ) {
		echo '<p><em>';
		printf(
			/* translators: %s expands to robots.txt. */
			esc_html__( 'If your %s were writable, you could edit it from here.', 'wordpress-seo' ),
			'robots.txt'
		);
		echo '</em></p>';
		echo '<textarea class="large-text code" disabled="disabled" rows="15" name="robotsnew">', esc_textarea( $content ), '</textarea><br/>';
	}
	else {
		echo '<form action="', esc_url( $action_url ), '" method="post" id="robotstxtform">';
		wp_nonce_field( 'wpseo-robotstxt', '_wpnonce', true, true );
		echo '<label for="robotsnew" class="yoast-inline-label">';
		printf(
			/* translators: %s expands to robots.txt. */
			esc_html__( 'Edit the content of your %s:', 'wordpress-seo' ),
			'robots.txt'
		);
		echo '</label>';
		echo '<textarea class="large-text code" rows="15" name="robotsnew" id="robotsnew">', esc_textarea( $content ), '</textarea><br/>';
		printf(
			'<div class="submit"><input class="button" type="submit" name="submitrobots" value="%s" /></div>',
			sprintf(
				/* translators: %s expands to robots.txt. */
				esc_attr__( 'Save changes to %s', 'wordpress-seo' ),
				'robots.txt'
			)
		);
		echo '</form>';
	}
}
if ( ! WPSEO_Utils::is_nginx() ) {

	echo '<h2>';
	printf(
		/* translators: %s expands to ".htaccess". */
		esc_html__( '%s file', 'wordpress-seo' ),
		'.htaccess'
	);
	echo '</h2>';

	if ( file_exists( $ht_access_file ) ) {
		$f = fopen( $ht_access_file, 'r' );

		$contentht = '';
		if ( filesize( $ht_access_file ) > 0 ) {
			$contentht = fread( $f, filesize( $ht_access_file ) );
		}

		if ( ! is_writable( $ht_access_file ) ) {
			echo '<p><em>';
			printf(
				/* translators: %s expands to ".htaccess". */
				esc_html__( 'If your %s were writable, you could edit it from here.', 'wordpress-seo' ),
				'.htaccess'
			);
			echo '</em></p>';
			echo '<textarea class="large-text code" disabled="disabled" rows="15" name="robotsnew">', esc_textarea( $contentht ), '</textarea><br/>';
		}
		else {
			echo '<form action="', esc_url( $action_url ), '" method="post" id="htaccessform">';
			wp_nonce_field( 'wpseo-htaccess', '_wpnonce', true, true );
			echo '<label for="htaccessnew" class="yoast-inline-label">';
			printf(
				/* translators: %s expands to ".htaccess". */
				esc_html__( 'Edit the content of your %s:', 'wordpress-seo' ),
				'.htaccess'
			);
			echo '</label>';
			echo '<textarea class="large-text code" rows="15" name="htaccessnew" id="htaccessnew">', esc_textarea( $contentht ), '</textarea><br/>';
			printf(
				'<div class="submit"><input class="button" type="submit" name="submithtaccess" value="%s" /></div>',
				sprintf(
					/* translators: %s expands to ".htaccess". */
					esc_attr__( 'Save changes to %s', 'wordpress-seo' ),
					'.htaccess'
				)
			);
			echo '</form>';
		}
	}
	else {
		echo '<p>';
		printf(
			/* translators: %s expands to ".htaccess". */
			esc_html__( 'If you had a %s file and it was editable, you could edit it from here.', 'wordpress-seo' ),
			'.htaccess'
		);
		echo '</p>';
	}
}

if ( is_multisite() ) {
	$yform->admin_footer( false );
}
                                                                                                                                                                                                                                                                                  plugins/wordpress-seo-extended/admin/views/tool-import-export.php                                   0000644                 00000010236 15122266555 0021414 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 */

if ( ! defined( 'WPSEO_VERSION' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

$yform            = Yoast_Form::get_instance();
$yoast_seo_import = false;

/**
 * The import method is used to determine if there should be something imported.
 *
 * In case of POST the user is on the Yoast SEO import page and in case of the GET the user sees a notice from
 * Yoast SEO that we can import stuff for that plugin.
 */
// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Reason: We are only comparing the variable so no need to sanitize.
if ( isset( $_POST['import_external'] ) && wp_unslash( $_POST['import_external'] ) === 'Import' ) {
	check_admin_referer( 'wpseo-import-plugins' );
	if ( isset( $_POST['import_external_plugin'] ) && is_string( $_POST['import_external_plugin'] ) ) {
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Reason: We are using the variable as a class name.
		$yoast_seo_class = wp_unslash( $_POST['import_external_plugin'] );
		if ( class_exists( $yoast_seo_class ) ) {
			$yoast_seo_import = new WPSEO_Import_Plugin( new $yoast_seo_class(), 'import' );
		}
	}
}
// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Reason: We are only comparing the variable so no need to sanitize.
elseif ( isset( $_POST['clean_external'] ) && wp_unslash( $_POST['clean_external'] ) === 'Clean up' ) {
	check_admin_referer( 'wpseo-clean-plugins' );
	if ( isset( $_POST['clean_external_plugin'] ) && is_string( $_POST['clean_external_plugin'] ) ) {
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Reason: We are using the variable as a class name.
		$yoast_seo_class = wp_unslash( $_POST['clean_external_plugin'] );
		if ( class_exists( $yoast_seo_class ) ) {
			$yoast_seo_import = new WPSEO_Import_Plugin( new $yoast_seo_class(), 'cleanup' );
		}
	}
}
// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Reason: We are only comparing to an empty string.
elseif ( isset( $_POST['settings_import'] ) && wp_unslash( $_POST['settings_import'] ) !== '' ) {
	$yoast_seo_import = new WPSEO_Import_Settings();
	$yoast_seo_import->import();
}

/**
 * Allow custom import actions.
 *
 * @param WPSEO_Import_Status $yoast_seo_import Contains info about the handled import.
 */
$yoast_seo_import = apply_filters( 'wpseo_handle_import', $yoast_seo_import );

if ( $yoast_seo_import ) {

	$yoast_seo_message = '';
	if ( $yoast_seo_import->status instanceof WPSEO_Import_Status ) {
		$yoast_seo_message = $yoast_seo_import->status->get_msg();
	}

	/**
	 * Allow customization of import/export message.
	 *
	 * @param string $yoast_seo_msg The message.
	 */
	$yoast_seo_msg = apply_filters( 'wpseo_import_message', $yoast_seo_message );

	if ( ! empty( $yoast_seo_msg ) ) {
		$yoast_seo_status = 'error';
		if ( $yoast_seo_import->status->status ) {
			$yoast_seo_status = 'updated';
		}

		$yoast_seo_class = 'message ' . $yoast_seo_status;

		echo '<div id="message" class="', esc_attr( $yoast_seo_status ), '"><p>', esc_html( $yoast_seo_msg ), '</p></div>';
	}
}

$yoast_seo_tabs = [
	'wpseo-import' => [
		'label' => __( 'Import settings', 'wordpress-seo' ),
	],
	'wpseo-export' => [
		'label' => __( 'Export settings', 'wordpress-seo' ),
	],
	'import-seo'   => [
		'label' => __( 'Import from other SEO plugins', 'wordpress-seo' ),
	],
];

?>
	<br/><br/>

	<h2 class="nav-tab-wrapper" id="wpseo-tabs">
		<?php foreach ( $yoast_seo_tabs as $identifier => $tab ) : ?>
			<a class="nav-tab" id="<?php echo esc_attr( $identifier . '-tab' ); ?>" href="<?php echo esc_url( '#top#' . $identifier ); ?>"><?php echo esc_html( $tab['label'] ); ?></a>
		<?php endforeach; ?>

		<?php
		/**
		 * Allow adding a custom import tab header.
		 */
		do_action( 'wpseo_import_tab_header' );
		?>
	</h2>

<?php

foreach ( $yoast_seo_tabs as $identifier => $tab ) {
	printf( '<div id="%s" class="wpseotab">', esc_attr( $identifier ) );
	require_once WPSEO_PATH . 'admin/views/tabs/tool/' . $identifier . '.php';
	echo '</div>';
}

/**
 * Allow adding a custom import tab.
 */
do_action( 'wpseo_import_tab_content' );
                                                                                                                                                                                                                                                                                                                                                                  plugins/wordpress-seo-extended/admin/views/user-profile.php                                         0000644                 00000010322 15122266555 0020220 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 *
 * @uses object $user
 */

/* translators: %1$s expands to Yoast SEO */
$wpseo_up_settings_header    = sprintf( __( '%1$s settings', 'wordpress-seo' ), 'Yoast SEO' );
$wpseo_no_index_author_label = sprintf(
	/* translators: %s expands to "this author's archives". */
	__( 'Do not allow search engines to show %s in search results.', 'wordpress-seo' ),
	__( 'this author\'s archives', 'wordpress-seo' )
);
?>

<div class="yoast yoast-settings">

	<h2 id="wordpress-seo"><?php echo esc_html( $wpseo_up_settings_header ); ?></h2>

	<?php if ( ! WPSEO_Options::get( 'disable-author' ) ) : ?>
	<label for="wpseo_author_title"><?php esc_html_e( 'Title to use for Author page', 'wordpress-seo' ); ?></label>
	<input class="yoast-settings__text regular-text" type="text" id="wpseo_author_title" name="wpseo_author_title"
		value="<?php echo esc_attr( get_the_author_meta( 'wpseo_title', $user->ID ) ); ?>"/><br>

	<label for="wpseo_author_metadesc"><?php esc_html_e( 'Meta description to use for Author page', 'wordpress-seo' ); ?></label>
	<textarea rows="5" cols="30" id="wpseo_author_metadesc"
		class="yoast-settings__textarea yoast-settings__textarea--medium"
		name="wpseo_author_metadesc"><?php echo esc_textarea( get_the_author_meta( 'wpseo_metadesc', $user->ID ) ); ?></textarea><br>

	<input class="yoast-settings__checkbox double" type="checkbox" id="wpseo_noindex_author"
		name="wpseo_noindex_author"
		value="on" <?php echo ( get_the_author_meta( 'wpseo_noindex_author', $user->ID ) === 'on' ) ? 'checked' : ''; ?> />
	<label class="yoast-label-strong"
		for="wpseo_noindex_author"><?php echo esc_html( $wpseo_no_index_author_label ); ?></label><br>
	<?php endif; ?>

	<?php if ( WPSEO_Options::get( 'keyword_analysis_active', false ) ) : ?>
		<input class="yoast-settings__checkbox double" type="checkbox" id="wpseo_keyword_analysis_disable"
			name="wpseo_keyword_analysis_disable" aria-describedby="wpseo_keyword_analysis_disable_desc"
			value="on" <?php echo ( get_the_author_meta( 'wpseo_keyword_analysis_disable', $user->ID ) === 'on' ) ? 'checked' : ''; ?> />
		<label class="yoast-label-strong"
			for="wpseo_keyword_analysis_disable"><?php esc_html_e( 'Disable SEO analysis', 'wordpress-seo' ); ?></label>
		<br>
		<p class="description" id="wpseo_keyword_analysis_disable_desc">
			<?php esc_html_e( 'Removes the focus keyphrase section from the metabox and disables all SEO-related suggestions.', 'wordpress-seo' ); ?>
		</p>
	<?php endif; ?>

	<?php if ( WPSEO_Options::get( 'content_analysis_active', false ) ) : ?>
		<input class="yoast-settings__checkbox double" type="checkbox" id="wpseo_content_analysis_disable"
			name="wpseo_content_analysis_disable" aria-describedby="wpseo_content_analysis_disable_desc"
			value="on" <?php echo ( get_the_author_meta( 'wpseo_content_analysis_disable', $user->ID ) === 'on' ) ? 'checked' : ''; ?> />
		<label class="yoast-label-strong"
			for="wpseo_content_analysis_disable"><?php esc_html_e( 'Disable readability analysis', 'wordpress-seo' ); ?></label>
		<br>
		<p class="description" id="wpseo_content_analysis_disable_desc">
			<?php esc_html_e( 'Removes the readability analysis section from the metabox and disables all readability-related suggestions.', 'wordpress-seo' ); ?>
		</p>
	<?php endif; ?>

	<?php if ( WPSEO_Options::get( 'inclusive_language_analysis_active', false ) ) : ?>
		<input class="yoast-settings__checkbox double" type="checkbox" id="wpseo_inclusive_language_analysis_disable"
			name="wpseo_inclusive_language_analysis_disable" aria-describedby="wpseo_inclusive_language_analysis_disable_desc"
			value="on" <?php echo ( get_the_author_meta( 'wpseo_inclusive_language_analysis_disable', $user->ID ) === 'on' ) ? 'checked' : ''; ?> />
		<label class="yoast-label-strong"
			for="wpseo_inclusive_language_analysis_disable"><?php esc_html_e( 'Disable inclusive language analysis', 'wordpress-seo' ); ?></label>
		<br>
		<p class="description" id="wpseo_inclusive_language_analysis_disable_desc">
			<?php esc_html_e( 'Removes the inclusive language analysis section from the metabox and disables all inclusive language-related suggestions.', 'wordpress-seo' ); ?>
		</p>
	<?php endif; ?>

	<?php do_action( 'wpseo_render_user_profile', $user ); ?>
</div>
                                                                                                                                                                                                                                                                                                              plugins/wordpress-seo-extended/admin/watchers/class-slug-change-watcher.php                         0000644                 00000017023 15122266555 0023227 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin\Watchers
 */

/**
 * Class WPSEO_Slug_Change_Watcher.
 */
class WPSEO_Slug_Change_Watcher implements WPSEO_WordPress_Integration {

	/**
	 * Registers all hooks to WordPress.
	 *
	 * @return void
	 */
	public function register_hooks() {
		// If the current plugin is Yoast SEO Premium, stop registering.
		if ( YoastSEO()->helpers->product->is_premium() ) {
			return;
		}

		add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_assets' ] );

		// Detect a post trash.
		add_action( 'wp_trash_post', [ $this, 'detect_post_trash' ] );

		// Detect a post delete.
		add_action( 'before_delete_post', [ $this, 'detect_post_delete' ] );

		// Detects deletion of a term.
		add_action( 'delete_term_taxonomy', [ $this, 'detect_term_delete' ] );
	}

	/**
	 * Enqueues the quick edit handler.
	 *
	 * @return void
	 */
	public function enqueue_assets() {
		global $pagenow;

		if ( ! in_array( $pagenow, [ 'edit.php', 'edit-tags.php' ], true ) ) {
			return;
		}

		$asset_manager = new WPSEO_Admin_Asset_Manager();
		$asset_manager->enqueue_script( 'quick-edit-handler' );
	}

	/**
	 * Shows a message when a post is about to get trashed.
	 *
	 * @param int $post_id The current post ID.
	 *
	 * @return void
	 */
	public function detect_post_trash( $post_id ) {
		if ( ! $this->is_post_viewable( $post_id ) ) {
			return;
		}

		$post_label = $this->get_post_type_label( get_post_type( $post_id ) );

		/* translators: %1$s expands to the translated name of the post type. */
		$first_sentence  = sprintf( __( 'You just trashed a %1$s.', 'wordpress-seo' ), $post_label );
		$second_sentence = __( 'Search engines and other websites can still send traffic to your trashed content.', 'wordpress-seo' );
		$message         = $this->get_message( $first_sentence, $second_sentence );

		$this->add_notification( $message );
	}

	/**
	 * Shows a message when a post is about to get trashed.
	 *
	 * @param int $post_id The current post ID.
	 *
	 * @return void
	 */
	public function detect_post_delete( $post_id ) {
		if ( ! $this->is_post_viewable( $post_id ) ) {
			return;
		}

		$post_label = $this->get_post_type_label( get_post_type( $post_id ) );

		/* translators: %1$s expands to the translated name of the post type. */
		$first_sentence  = sprintf( __( 'You just deleted a %1$s.', 'wordpress-seo' ), $post_label );
		$second_sentence = __( 'Search engines and other websites can still send traffic to your deleted content.', 'wordpress-seo' );
		$message         = $this->get_message( $first_sentence, $second_sentence );

		$this->add_notification( $message );
	}

	/**
	 * Shows a message when a term is about to get deleted.
	 *
	 * @param int $term_taxonomy_id The term taxonomy ID that will be deleted.
	 *
	 * @return void
	 */
	public function detect_term_delete( $term_taxonomy_id ) {
		if ( ! $this->is_term_viewable( $term_taxonomy_id ) ) {
			return;
		}

		$term       = get_term_by( 'term_taxonomy_id', (int) $term_taxonomy_id );
		$term_label = $this->get_taxonomy_label_for_term( $term->term_id );

		/* translators: %1$s expands to the translated name of the term. */
		$first_sentence  = sprintf( __( 'You just deleted a %1$s.', 'wordpress-seo' ), $term_label );
		$second_sentence = __( 'Search engines and other websites can still send traffic to your deleted content.', 'wordpress-seo' );
		$message         = $this->get_message( $first_sentence, $second_sentence );

		$this->add_notification( $message );
	}

	/**
	 * Checks if the post is viewable.
	 *
	 * @param string $post_id The post id to check.
	 *
	 * @return bool Whether the post is viewable or not.
	 */
	protected function is_post_viewable( $post_id ) {
		$post_type = get_post_type( $post_id );
		if ( ! WPSEO_Post_Type::is_post_type_accessible( $post_type ) ) {
			return false;
		}

		$post_status = get_post_status( $post_id );
		if ( ! $this->check_visible_post_status( $post_status ) ) {
			return false;
		}

		return true;
	}

	/**
	 * Checks if the term is viewable.
	 *
	 * @param int $term_taxonomy_id The term taxonomy ID to check.
	 *
	 * @return bool Whether the term is viewable or not.
	 */
	protected function is_term_viewable( $term_taxonomy_id ) {
		$term = get_term_by( 'term_taxonomy_id', (int) $term_taxonomy_id );

		if ( ! $term || is_wp_error( $term ) ) {
			return false;
		}

		$taxonomy = get_taxonomy( $term->taxonomy );
		if ( ! $taxonomy ) {
			return false;
		}

		return $taxonomy->publicly_queryable || $taxonomy->public;
	}

	/**
	 * Gets the taxonomy label to use for a term.
	 *
	 * @param int $term_id The term ID.
	 *
	 * @return string The taxonomy's singular label.
	 */
	protected function get_taxonomy_label_for_term( $term_id ) {
		$term     = get_term( $term_id );
		$taxonomy = get_taxonomy( $term->taxonomy );

		return $taxonomy->labels->singular_name;
	}

	/**
	 * Retrieves the singular post type label.
	 *
	 * @param string $post_type Post type to retrieve label from.
	 *
	 * @return string The singular post type name.
	 */
	protected function get_post_type_label( $post_type ) {
		$post_type_object = get_post_type_object( $post_type );

		// If the post type of this post wasn't registered default back to post.
		if ( $post_type_object === null ) {
			$post_type_object = get_post_type_object( 'post' );
		}

		return $post_type_object->labels->singular_name;
	}

	/**
	 * Checks whether the given post status is visible or not.
	 *
	 * @param string $post_status The post status to check.
	 *
	 * @return bool Whether or not the post is visible.
	 */
	protected function check_visible_post_status( $post_status ) {
		$visible_post_statuses = [
			'publish',
			'static',
			'private',
		];

		return in_array( $post_status, $visible_post_statuses, true );
	}

	/**
	 * Returns the message around changed URLs.
	 *
	 * @param string $first_sentence  The first sentence of the notification.
	 * @param string $second_sentence The second sentence of the notification.
	 *
	 * @return string The full notification.
	 */
	protected function get_message( $first_sentence, $second_sentence ) {
		return '<h2>' . __( 'Make sure you don\'t miss out on traffic!', 'wordpress-seo' ) . '</h2>'
			. '<p>'
			. $first_sentence
			. ' ' . $second_sentence
			. ' ' . __( 'You should create a redirect to ensure your visitors do not get a 404 error when they click on the no longer working URL.', 'wordpress-seo' )
			/* translators: %s expands to Yoast SEO Premium */
			. ' ' . sprintf( __( 'With %s, you can easily create such redirects.', 'wordpress-seo' ), 'Yoast SEO Premium' )
			. '</p>'
			. '<p><a class="yoast-button-upsell" data-action="load-nfd-ctb" data-ctb-id="f6a84663-465f-4cb5-8ba5-f7a6d72224b2" href="' . WPSEO_Shortlinker::get( 'https://yoa.st/1d0' ) . '" target="_blank">'
			/* translators: %s expands to Yoast SEO Premium */
			. sprintf( __( 'Get %s', 'wordpress-seo' ), 'Yoast SEO Premium' )
			/* translators: Hidden accessibility text. */
			. '<span class="screen-reader-text">' . __( '(Opens in a new browser tab)', 'wordpress-seo' ) . '</span>'
			. '<span aria-hidden="true" class="yoast-button-upsell__caret"></span>'
			. '</a></p>';
	}

	/**
	 * Adds a notification to be shown on the next page request since posts are updated in an ajax request.
	 *
	 * @param string $message The message to add to the notification.
	 *
	 * @return void
	 */
	protected function add_notification( $message ) {
		$notification = new Yoast_Notification(
			$message,
			[
				'type'           => 'notice-warning is-dismissible',
				'yoast_branding' => true,
			]
		);

		$notification_center = Yoast_Notification_Center::get();
		$notification_center->add_notification( $notification );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             plugins/wordpress-seo-extended/css/dist/academy-2250.css                                            0000644                 00000000676 15122266555 0017117 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       .seo_page_wpseo_page_academy{--tw-bg-opacity:1;background-color:rgb(241 245 249/var(--tw-bg-opacity));z-index:-1}.seo_page_wpseo_page_academy #wpcontent{padding-left:0!important}.seo_page_wpseo_page_academy #wpfooter{padding-right:1rem}@media (min-width:768px){.seo_page_wpseo_page_academy #wpfooter{padding-left:17rem;padding-right:2rem}}@media screen and (max-width:782px){.seo_page_wpseo_page_academy .wp-responsive-open #wpbody{right:-190px}}                                                                  plugins/wordpress-seo-extended/css/dist/academy-2250-rtl.css                                        0000644                 00000000675 15122266555 0017715 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       .seo_page_wpseo_page_academy{--tw-bg-opacity:1;background-color:rgb(241 245 249/var(--tw-bg-opacity));z-index:-1}.seo_page_wpseo_page_academy #wpcontent{padding-right:0!important}.seo_page_wpseo_page_academy #wpfooter{padding-left:1rem}@media (min-width:768px){.seo_page_wpseo_page_academy #wpfooter{padding-right:17rem;padding-left:2rem}}@media screen and (max-width:782px){.seo_page_wpseo_page_academy .wp-r