<?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 *
 * @uses    string $yoast_seo_type
 * @uses    string $yoast_seo_dashicon
 * @uses    string $yoast_seo_i18n_title
 * @uses    string $yoast_seo_i18n_issues
 * @uses    string $yoast_seo_i18n_no_issues
 * @uses    string $yoast_seo_i18n_muted_issues_title
 * @uses    int    $yoast_seo_active_total
 * @uses    int    $yoast_seo_dismissed_total
 * @uses    int    $yoast_seo_total
 * @uses    array  $yoast_seo_active
 * @uses    array  $yoast_seo_dismissed
 */

if ( ! function_exists( '_yoast_display_notifications' ) ) {
	/**
	 * Create the notifications HTML with restore/dismiss button.
	 *
	 * @param array  $notifications_list List of notifications.
	 * @param string $status             Status of the notifications (active/dismissed).
	 *
	 * @return string The output to render.
	 */
	function _yoast_display_notifications( $notifications_list, $status ) {
		$notifications = '';

		foreach ( $notifications_list as $notification ) {

			switch ( $status ) {
				case 'active':
					$button = sprintf(
						'<button type="button" class="button dismiss"><span class="screen-reader-text">%1$s</span><span class="dashicons dashicons-hidden"></span></button>',
						/* translators: Hidden accessibility text. */
						esc_html__( 'Hide this item.', 'wordpress-seo' )
					);
					break;

				case 'dismissed':
					$button = sprintf(
						'<button type="button" class="button restore"><span class="screen-reader-text">%1$s</span><span class="dashicons yoast-svg-icon-eye"></span></button>',
						/* translators: Hidden accessibility text. */
						esc_html__( 'Show this item.', 'wordpress-seo' )
					);
					break;
			}

			$notifications .= sprintf(
				'<div class="yoast-notification-holder" id="%1$s" data-nonce="%2$s" data-json="%3$s">%4$s%5$s</div>',
				esc_attr( $notification->get_id() ),
				esc_attr( $notification->get_nonce() ),
				esc_attr( $notification->get_json() ),
				// This needs to be fixed in https://github.com/Yoast/wordpress-seo-premium/issues/2548.
				$notification,
				// Note: $button is properly escaped above.
				$button
			);
		}

		return $notifications;
	}
}

$wpseo_i18n_summary = $yoast_seo_i18n_issues;
if ( ! $yoast_seo_active ) {
	$yoast_seo_dashicon = 'yes';
	$wpseo_i18n_summary = $yoast_seo_i18n_no_issues;
}

?>
<h3 class="yoast-notifications-header" id="<?php echo esc_attr( 'yoast-' . $yoast_seo_type . '-header' ); ?>">
	<span class="dashicons <?php echo esc_attr( 'dashicons-' . $yoast_seo_dashicon ); ?>"></span>
	<?php echo esc_html( $yoast_seo_i18n_title ); ?> (<?php echo (int) $yoast_seo_active_total; ?>)
</h3>

<div id="<?php echo esc_attr( 'yoast-' . $yoast_seo_type ); ?>">

	<?php if ( $yoast_seo_total ) : ?>
		<p><?php echo esc_html( $wpseo_i18n_summary ); ?></p>

		<div class="container yoast-notifications-active" id="<?php echo esc_attr( 'yoast-' . $yoast_seo_type . '-active' ); ?>">
			<?php
			// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Reason: _yoast_display_notifications() as declared above is safe.
			echo _yoast_display_notifications( $yoast_seo_active, 'active' );
			?>
		</div>

		<?php
		if ( $yoast_seo_dismissed ) {
			$dismissed_paper = new WPSEO_Paper_Presenter(
				esc_html( $yoast_seo_i18n_muted_issues_title ),
				null,
				[
					'paper_id'                 => esc_attr( $yoast_seo_type . '-dismissed' ),
					'paper_id_prefix'          => 'yoast-',
					'class'                    => 'yoast-notifications-dismissed',
					'content'                  => _yoast_display_notifications( $yoast_seo_dismissed, 'dismissed' ),
					'collapsible'              => true,
					'collapsible_header_class' => 'yoast-notification',
				]
			);
			// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Reason: get_output() output is properly escaped.
			echo $dismissed_paper->get_output();
		}
		?>

	<?php else : ?>

		<p><?php echo esc_html( $yoast_seo_i18n_no_issues ); ?></p>

	<?php endif; ?>
</div>
                                                                                                       plugins/wordpress-seo-extended/admin/views/partial-notifications-warnings.php                       0000644                 00000002101 15122266555 0023731 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 *
 * @uses    array $notifications_data
 */

$yoast_seo_type     = 'warnings';
$yoast_seo_dashicon = 'flag';

$yoast_seo_active    = $notifications_data['warnings']['active'];
$yoast_seo_dismissed = $notifications_data['warnings']['dismissed'];

$yoast_seo_active_total    = count( $notifications_data['warnings']['active'] );
$yoast_seo_dismissed_total = count( $notifications_data['warnings']['dismissed'] );
$yoast_seo_total           = $notifications_data['metrics']['warnings'];

$yoast_seo_i18n_title              = __( 'Notifications', 'wordpress-seo' );
$yoast_seo_i18n_issues             = '';
$yoast_seo_i18n_no_issues          = __( 'No new notifications.', 'wordpress-seo' );
$yoast_seo_i18n_muted_issues_title = sprintf(
	/* translators: %d expands the amount of hidden notifications. */
	_n( 'You have %d hidden notification:', 'You have %d hidden notifications:', $yoast_seo_dismissed_total, 'wordpress-seo' ),
	$yoast_seo_dismissed_total
);

require WPSEO_PATH . 'admin/views/partial-notifications-template.php';
                                                                                                                                                                                                                                                                                                                                                                                                                                                               plugins/wordpress-seo-extended/admin/views/redirects.php                                            0000644                 00000020712 15122266555 0017574 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 * @since   19.0
 */

if ( ! defined( 'WPSEO_VERSION' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

?>
<div class="wrap yoast wpseo-admin-page page-wpseo_redirects">
	<h1 id="wpseo-title"><?php echo esc_html( get_admin_page_title() ); ?></h1>
	<div class="wpseo_content_wrapper" style="position: relative;">
		<div style="position: absolute;top: 0;bottom: 0;left: 0;right: 0;z-index: 100; display: flex;justify-content: center;align-items: center;background: radial-gradient(#ffffffcf 20%, #ffffff00 50%);">
			<a class="yoast-button-upsell" data-action="load-nfd-ctb" data-ctb-id="f6a84663-465f-4cb5-8ba5-f7a6d72224b2" href="<?php echo esc_url( WPSEO_Shortlinker::get( 'https://yoa.st/redirect-manager-upsell' ) ); ?>" target="_blank">
				<?php
				echo esc_html__( 'Unlock with Premium', 'wordpress-seo' )
					// phpcs:ignore WordPress.Security.EscapeOutput -- Already escapes correctly.
					. WPSEO_Admin_Utils::get_new_tab_message();
				?>
				<span aria-hidden="true" class="yoast-button-upsell__caret"></span></a>
		</div>
		<div class="wpseo_content_cell" id="wpseo_content_top" style="opacity: 0.5;">
			<h2 class="nav-tab-wrapper" id="wpseo-tabs">
				<a class="nav-tab nav-tab-active" id="tab-url-tab" href="#" tabindex="-1">
					<?php
					esc_html_e( 'Redirects', 'wordpress-seo' )
					?>
				</a>
				<a class="nav-tab" id="tab-url-tab" href="" tabindex="-1">
					<?php
					esc_html_e( 'Regex Redirects', 'wordpress-seo' )
					?>
				</a>
				<a class="nav-tab" id="tab-url-tab" href="#" tabindex="-1">
					<?php
					esc_html_e( 'Settings', 'wordpress-seo' )
					?>
					</a>
			</h2>

			<div id="table-plain" class="tab-url redirect-table-tab">
				<h2>
					<?php
					esc_html_e( 'Plain redirects', 'wordpress-seo' )
					?>
				</h2>
				<form class="wpseo-new-redirect-form" method="post">
					<div class="wpseo_redirect_form">
						<div class="redirect_form_row" id="row-wpseo_redirects_type">
							<label class="textinput" for="wpseo_redirects_type">
								<span class="title">
									<?php
									esc_html_e( 'Type', 'wordpress-seo' )
									?>
								</span>
							</label>
							<select name="wpseo_redirects_type" id="wpseo_redirects_type" class="select select2-hidden-accessible" data-select2-id="wpseo_redirects_type" tabindex="-1" aria-hidden="true">
								<option value="301" data-select2-id="2">
									<?php
									esc_html_e( '301 Moved Permanently', 'wordpress-seo' )
									?>
								</option>
							</select>
							<span class="select2 select2-container select2-container--default" dir="ltr" data-select2-id="1" style="width: 400px;">
								<span class="selection">
									<span class="select2-selection select2-selection--single" role="combobox" aria-haspopup="true" aria-expanded="false" tabindex="-1" aria-disabled="false" aria-labelledby="select2-wpseo_redirects_type-container">
										<span class="select2-selection__rendered" id="select2-wpseo_redirects_type-container" role="textbox" aria-readonly="true" title="301 Moved Permanently">
											<?php
											esc_html_e( '301 Moved Permanently', 'wordpress-seo' )
											?>
										</span>
										<span class="select2-selection__arrow" role="presentation">
											<b role="presentation"></b>
										</span>
									</span>
								</span>
								<span class="dropdown-wrapper" aria-hidden="true"></span>
							</span>
						</div>

						<p class="label desc description wpseo-redirect-clear">
							<?php
							printf(
								/* translators: 1: opens a link. 2: closes the link. */
								esc_html__( 'The redirect type is the HTTP response code sent to the browser telling the browser what type of redirect is served. %1$sLearn more about redirect types%2$s.', 'wordpress-seo' ),
								'<a href="#" target="_blank">',
								'</a>'
							);
							?>
						<div class="redirect_form_row" id="row-wpseo_redirects_origin">
							<label class="textinput" for="wpseo_redirects_origin">
								<span class="title">
									<?php
									esc_html_e( 'Old URL', 'wordpress-seo' )
									?>
								</span>
							</label>
							<input type="text" class="textinput" name="wpseo_redirects_origin" id="wpseo_redirects_origin" va