;

		$this->output_html();

		$rendered_output = ob_get_contents();
		ob_end_clean();

		return $rendered_output;
	}

	/**
	 * Add an attribute to the attributes property.
	 *
	 * @param string $attribute The name of the attribute to add.
	 * @param string $value     The value of the attribute.
	 *
	 * @return void
	 */
	public function add_attribute( $attribute, $value ) {
		$this->select_attributes[ $attribute ] = $value;
	}

	/**
	 * Return the set fields for the select.
	 *
	 * @return array
	 */
	private function get_select_values() {
		return [
			'id'         => $this->select_id,
			'name'       => $this->select_name,
			'attributes' => $this->get_attributes(),
			'options'    => $this->select_options,
			'selected'   => $this->selected_option,
		];
	}

	/**
	 * Return the attribute string, when there are attributes set.
	 *
	 * @return string
	 */
	private function get_attributes() {
		$attributes = $this->select_attributes;

		if ( ! empty( $attributes ) ) {
			array_walk( $attributes, [ $this, 'parse_attribute' ] );

			return implode( ' ', $attributes ) . ' ';
		}

		return '';
	}

	/**
	 * Get an attribute from the attributes.
	 *
	 * @param string $value     The value of the attribute.
	 * @param string $attribute The attribute to look for.
	 *
	 * @return void
	 */
	private function parse_attribute( &$value, $attribute ) {
		$value = sprintf( '%s="%s"', sanitize_key( $attribute ), esc_attr( $value ) );
	}
}
                                                                                           plugins/wordpress-seo-extended/admin/views/class-yoast-integration-toggles.php                      0000644                 00000010606 15122266555 0024036 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 */

/**
 * Class for managing integration toggles.
 */
class Yoast_Integration_Toggles {

	/**
	 * Available integration toggles.
	 *
	 * @var array
	 */
	protected $toggles;

	/**
	 * Instance holder.
	 *
	 * @var self|null
	 */
	protected static $instance = null;

	/**
	 * Gets the main integration toggles manager instance used.
	 *
	 * This essentially works like a Singleton, but for its drawbacks does not restrict
	 * instantiation otherwise.
	 *
	 * @return self Main instance.
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Gets all available integration toggles.
	 *
	 * @return array List of sorted Yoast_Feature_Toggle instances.
	 */
	public function get_all() {
		if ( $this->toggles === null ) {
			$this->toggles = $this->load_toggles();
		}

		return $this->toggles;
	}

	/**
	 * Loads the available integration toggles.
	 *
	 * Also ensures that the toggles are all Yoast_Feature_Toggle instances and sorted by their order value.
	 *
	 * @return array List of sorted Yoast_Feature_Toggle instances.
	 */
	protected function load_toggles() {
		$integration_toggles = [
			(object) [
				/* translators: %s: 'Semrush' */
				'name'            => sprintf( __( '%s integration', 'wordpress-seo' ), 'Semrush' ),
				'setting'         => 'semrush_integration_active',
				'label'           => sprintf(
					/* translators: %s: 'Semrush' */
					__( 'The %s integration offers suggestions and insights for keywords related to the entered focus keyphrase.', 'wordpress-seo' ),
					'Semrush'
				),
				'order'           => 10,
			],
			(object) [
				/* translators: %s: Algolia. */
				'name'               => sprintf( esc_html__( '%s integration', 'wordpress-seo' ), 'Algolia' ),
				'premium'            => true,
				'setting'            => 'algolia_integration_active',
				'label'              => __( 'Improve the quality of your site search! Automatically helps your users find your cornerstone and most important content in your internal search results. It also removes noindexed posts & pages from your site’s search results.', 'wordpress-seo' ),
				/* translators: %s: Algolia. */
				'read_more_label'    => sprintf( __( 'Find out more about our %s integration.', 'wordpress-seo' ), 'Algolia' ),
				'read_more_url'      => 'https://yoa.st/4eu',
				'premium_url'        => 'https://yoa.st/4ex',
				'premium_upsell_url' => 'https://yoa.st/get-algolia-integration',
				'order'              => 25,
			],
		];

		/**
		 * Filter to add integration toggles from add-ons.
		 *
		 * @param array $integration_toggles Array with integration toggle objects where each object
		 *                                   should have a `name`, `setting` and `label` property.
		 */
		$integration_toggles = apply_filters( 'wpseo_integration_toggles', $integration_toggles );

		$integration_toggles = array_map( [ $this, 'ensure_toggle' ], $integration_toggles );
		usort( $integration_toggles, [ $this, 'sort_toggles_callback' ] );

		return $integration_toggles;
	}

	/**
	 * Ensures that the passed value is a Yoast_Feature_Toggle.
	 *
	 * @param Yoast_Feature_Toggle|object|array $toggle_data Feature toggle instance, or raw object or array
	 *                                                       containing integration toggle data.
	 * @return Yoast_Feature_Toggle Feature toggle instance based on $toggle_data.
	 */
	protected function ensure_toggle( $toggle_data ) {
		if ( $toggle_data instanceof Yoast_Feature_Toggle ) {
			return $toggle_data;
		}

		if ( is_object( $toggle_data ) ) {
			$toggle_data = get_object_vars( $toggle_data );
		}

		return new Yoast_Feature_Toggle( $toggle_data );
	}

	/**
	 * Callback for sorting integration toggles by their order.
	 *
	 * {@internal Once the minimum PHP version goes up to PHP 7.0, the logic in the function
	 * can be replaced with the spaceship operator `<=>`.}
	 *
	 * @param Yoast_Feature_Toggle $feature_a Feature A.
	 * @param Yoast_Feature_Toggle $feature_b Feature B.
	 *
	 * @return int An integer less than, equal to, or greater than zero indicating respectively
	 *             that feature A is considered to be less than, equal to, or greater than feature B.
	 */
	protected function sort_toggles_callback( Yoast_Feature_Toggle $feature_a, Yoast_Feature_Toggle $feature_b ) {
		return ( $feature_a->order - $feature_b->order );
	}
}
                                                                                                                          plugins/wordpress-seo-extended/admin/views/form/select.php                                          0000644                 00000002115 15122266555 0020027 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 *
 * @uses string $attributes Additional attributes for the select.
 * @uses string $name       Value for the select name attribute.
 * @uses string $id         ID attribute for the select.
 * @uses array  $options    Array with the options to show.
 * @uses string $selected   The current set options.
 */

if ( ! defined( 'WPSEO_VERSION' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

?>
<?php /* phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Reason: $attributes is properly escaped in parse_attribute via get_attributes in class-yoast-input-select.php. */ ?>
<select <?php echo $attributes; ?>name="<?php echo esc_attr( $name ); ?>" id="<?php echo esc_attr( $id ); ?>">
	<?php foreach ( $options as $option_attribute_value => $option_html_value ) : ?>
	<option value="<?php echo esc_attr( $option_attribute_value ); ?>"<?php echo selected( $selected, $option_attribute_value, false ); ?>><?php echo esc_html( $option_html_value ); ?></option>
	<?php endforeach; ?>
</select>
                                                                                                                                                                                                                                                                                                                                                                                                                                                   plugins/wordpress-seo-extended/admin/views/interface-yoast-form-element.php                         0000644                 00000000373 15122266555 0023276 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 */

/**
 * Generate the HTML for a form element.
 */
interface Yoast_Form_Element {

	/**
	 * Return the HTML for the form element.
	 *
	 * @return string
	 */
	public function get_html();
}
                                                                                                                                                                                                                                                                     plugins/wordpress-seo-extended/admin/views/js-templates-primary-term.php                            0000644                 00000002526 15122266555 0022651 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 */

if ( ! defined( 'WPSEO_VERSION' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}
?>

<script type="text/html" id="tmpl-primary-term-ui">
	<?php
	/* translators: Hidden accessibility text; %1$s expands to the term title, %2$s to the taxonomy title. */
	$yoast_free_js_button_label = __( 'Make %1$s primary %2$s', 'wordpress-seo' );
	$yoast_free_js_button_label = sprintf(
		$yoast_free_js_button_label,
		'{{data.term}}',
		'{{data.taxonomy.title}}'
	);

	printf(
		'<button type="button" class="wpseo-make-primary-term" aria-label="%1$s">%2$s</button>',
		esc_attr( $yoast_free_js_button_label ),
		esc_html__( 'Make primary', 'wordpress-seo' )
	);
	?>

	<span class="wpseo-is-primary-term" aria-hidden="true"><?php esc_html_e( 'Primary', 'wordpress-seo' ); ?></span>
</script>

<script type="text/html" id="tmpl-primary-term-screen-reader">
	<?php
	/* translators: %s is the taxonomy title. This will be shown to screenreaders */
	$yoast_free_js_taxonomy_title = __( 'Primary %s', 'wordpress-seo' );
	$yoast_free_js_taxonomy_title = sprintf(
		'(' . $yoast_free_js_taxonomy_title . ')',
		'{{data.taxonomy.title}}'
	);
	?>
	<span class="screen-reader-text wpseo-primary-category-label"><?php echo esc_html( $yoast_free_js_taxonomy_title ); ?></span>
</script>
                                                                                                                                                                          plugins/wordpress-seo-extended/admin/views/licenses.php                                             0000644                 00000043677 15122266555 0017434 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 * @since   5.1
 */

use Yoast\WP\SEO\Promotions\Application\Promotion_Manager;

if ( ! defined( 'WPSEO_VERSION' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

do_action( 'wpseo_install_and_activate_addons' );

$premium_extension = [
	'buyUrl'   => WPSEO_Shortlinker::get( 'https://yoa.st/zz' ),
	'infoUrl'  => WPSEO_Shortlinker::get( 'https://yoa.st/zy' ),
	'title'    => 'Yoast SEO Premium',
	/* translators: %1$s expands to Yoast SEO */
	'desc'     => sprintf( __( 'The premium version of %1$s with more features & support.', 'wordpress-seo' ), 'Yoast SEO' ),
	'image'    => plugin_dir_url( WPSEO_FILE ) . 'packages/js/images/Yoast_SEO_Icon.svg',
	'benefits' => [],
];

$extensions = [
	WPSEO_Addon_Manager::LOCAL_SLUG => [
		'buyUrl'        => WPSEO_Shortlinker::get( 'https://yoa.st/zt' ),
		'infoUrl'       => WPSEO_Shortlinker::get( 'https://yoa.st/zs' ),
		'title'         => 'Local SEO',
		'display_title' => __( 'Stand out for local searches', 'wordpress-seo' ),
		'desc'          => __( 'Rank better locally and in Google Maps, without breaking a sweat!', 'wordpress-seo' ),
		'image'         => plugins_url( 'images/local_plugin_assistant.svg?v=' . WPSEO_VERSION, WPSEO_FILE ),
		'benefits'      => [
			__( 'Attract more customers to your site and physical store', 'wordpress-seo' ),
			__( 'Automatically get technical SEO best practices for local businesses', 'wordpress-seo' ),
			__( 'Easily add maps, address finders, and opening hours to your content', 'wordpress-seo' ),
			__( 'Optimize your business for multiple locations', 'wordpress-seo' ),
		],
	],
	WPSEO_Addon_Manager::VIDEO_SLUG => [
		'buyUrl'        => WPSEO_Shortlinker::get( 'https://yoa.st/zx/' ),
		'infoUrl'       => WPSEO_Shortlinker::get( 'https://yoa.st/zw/' ),
		'title'         => 'Video SEO',
		'display_title' => __( 'Drive more views to your videos', 'wordpress-seo' ),
		'desc'          => __( 'Optimize your videos to show them off in search results and get more clicks!', 'wordpress-seo' ),
		'image'         => plugins_url( 'images/video_plugin_assistant.svg?v=' . WPSEO_VERSION, WPSEO_FILE ),
		'benefits'      => [
			__( 'Automatically get technical SEO best practices for video content', 'wordpress-seo' ),
			__( 'Make sure your videos load quickly for users', 'wordpress-seo' ),
			__( 'Make your videos responsive for all screen sizes', 'wordpress-seo' ),
			__( 'Optimize your video previews & thumbnails', 'wordpress-seo' ),
		],
	],
	WPSEO_Addon_Manager::NEWS_SLUG  => [
		'buyUrl'        => WPSEO_Shortlinker::get( 'https://yoa.st/zv/' ),
		'infoUrl'       => WPSEO_Shortlinker::get( 'https://yoa.st/zu/' ),
		'title'         => 'News SEO',
		'display_title' => __( 'Rank higher in Google\'s news carousel', 'wordpress-seo' ),
		'desc'          => __( 'Are you in Google News? Increase your traffic from Google News by optimizing for it!', 'wordpress-seo' ),
		'image'         => plugins_url( 'images/news_plugin_assistant.svg?v=' . WPSEO_VERSION, WPSEO_FILE ),
		'benefits'      => [
			__( 'Optimize your site for Google News', 'wordpress-seo' ),
			__( 'Ping Google on the publication of a new post', 'wordpress-seo' ),
			__( 'Add all necessary schema.org markup', 'wordpress-seo' ),
			__( 'Get XML sitemaps', 'wordpress-seo' ),
		],
	],
];

// Add Yoast WooCommerce SEO when WooCommerce is active.
if ( YoastSEO()->helpers->woocommerce->is_active() ) {
	$extensions[ WPSEO_Addon_Manager::WOOCOMMERCE_SLUG ] = [
		'buyUrl'        => WPSEO_Shortlinker::get( 'https://yoa.st/zr' ),
		'infoUrl'       => WPSEO_Shortlinker::get( 'https://yoa.st/zq' ),
		'title'         => 'Yoast WooCommerce SEO',
		'display_title' => __( 'Drive more traffic to your online store', 'wordpress-seo' ),
		/* translators: %1$s expands to Yoast SEO */
		'desc'          => sprintf( __( 'Seamlessly integrate WooCommerce with %1$s and get extra features!', 'wordpress-seo' ), 'Yoast SEO' ),
		'image'         => plugins_url( 'images/woo_plugin_assistant.svg?v=' . WPSEO_VERSION, WPSEO_FILE ),
		'benefits'      => [
			__( 'Write product pages that rank using the SEO analysis', 'wordpress-seo' ),
			__( 'Increase Google clicks with rich results', 'wordpress-seo' ),
			__( 'Add global identifiers for variable products', 'wordpress-seo' ),
			/* translators: %1$s expands to Yoast SEO, %2$s expands to WooCommerce */
			sprintf( __( 'Seamless integration between %1$s and %2$s', 'wordpress-seo' ), 'Yoast SEO', 'WooCommerce' ),
			__( 'Turn more visitors into customers!', 'wordpress-seo' ),
		],
		'buy_button'    => 'WooCommerce SEO',
	];
}

// The total number of plugins to consider is the length of the array + 1 for Premium.
// @phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$number_plugins_total = ( count( $extensions ) + 1 );
// @phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$number_plugins_active = 0;

$extensions['yoast-seo-plugin-subscription'] = [
	'buyUrl'        => WPSEO_Shortlinker::get( 'https://yoa.st/premium-page-bundle-buy' ),
	'infoUrl'       => WPSEO_Shortlinker::get( 'https://yoa.st/premium-page-bundle-info' ),
	/* translators: used in phrases such as "More information about all the Yoast plugins" */
	'title'         => __( 'all the Yoast plugins', 'wordpress-seo' ),
	'display_title' => __( 'Cover all your SEO bases', 'wordpress-seo' ),
	'desc'          => '',
	'image'         => plugins_url( 'images/plugin_subscription.svg?v=' . WPSEO_VERSION, WPSEO_FILE ),
	'benefits'      => [
		__( 'Get all 5 Yoast plugins for WordPress at a big discount', 'wordpress-seo' ),
		__( 'Reach new customers who live near your business', 'wordpress-seo' ),
		__( 'Drive more views to your videos', 'wordpress-seo' ),
		__( 'Rank higher in Google\'s news carousel', 'wordpress-seo' ),
		__( 'Drive more traffic to your online store', 'wordpress-seo' ),

	],
	/* translators: used in phrases such as "Buy all the Yoast plugins" */
	'buy_button'    => __( 'all the Yoast plugins', 'wordpress-seo' ),
];

$addon_manager                  = new WPSEO_Addon_Manager();
$has_valid_premium_subscription = YoastSEO()->helpers->product->is_premium() && $addon_manager->has_valid_subscription( WPSEO_Addon_Manager::PREMIUM_SLUG );

/* translators: %1$s expands to Yoast SEO. */
$wpseo_extensions_header = sprintf( __( '%1$s Extensions', 'wordpress-seo' ), 'Yoast SEO' );
$new_tab_message         = sprintf(
	'<span class="screen-reader-text">%1$s</span>',
	/* translators: Hidden accessibility text. */
	esc_html__( '(Opens in a new browser tab)', 'wordpress-seo' )
);

$sale_badge         = '';
$premium_sale_badge = '';

if ( YoastSEO()->classes->get( Promotion_Manager::class )->is( 'black-friday-2023-promotion' ) ) {
	/* translators: %1$s expands to opening span, %2$s expands to closing span */
	$sale_badge_span = sprintf( esc_html__( '%1$sSALE 30%% OFF!%2$s', 'wordpress-seo' ), '<span>', '</span>' );

	$