 string.
	 *     @type string $read_more_label     Label for the learn more link. Default empty string.
	 *     @type string $extra               Additional help content for the feature. Default empty string.
	 *     @type int    $order               Value to specify the feature toggle order. A lower value indicates
	 *                                       a higher priority. Default 100.
	 *     @type bool   $disabled            Disable the integration toggle. Default false.
	 *     @type string $new                 Whether the feature is new or not.
	 *     @type bool   $in_beta             Whether the feature is in beta or not.
	 *     @type array  $supported_languages The languages that this feature supports.
	 *     @type string $premium_version     The Premium version in which this feature was added.
	 * }
	 *
	 * @throws InvalidArgumentException Thrown when a required argument is missing.
	 */
	public function __construct( array $args ) {
		$required_keys = [ 'name', 'setting' ];

		foreach ( $required_keys as $key ) {
			if ( empty( $args[ $key ] ) ) {
				/* translators: %s: argument name */
				throw new InvalidArgumentException( sprintf( __( '%s is a required feature toggle argument.', 'wordpress-seo' ), $key ) );
			}
		}

		foreach ( $args as $key => $value ) {
			if ( property_exists( $this, $key ) ) {
				$this->$key = $value;
			}
		}
	}

	/**
	 * Magic isset-er.
	 *
	 * @param string $key Key to check whether a value for it is set.
	 *
	 * @return bool True if set, false otherwise.
	 */
	public function __isset( $key ) {
		return isset( $this->$key );
	}

	/**
	 * Magic getter.
	 *
	 * @param string $key Key to get the value for.
	 *
	 * @return mixed Value for the key, or null if not set.
	 */
	public function __get( $key ) {
		if ( isset( $this->$key ) ) {
			return $this->$key;
		}

		return null;
	}

	/**
	 * Checks whether the feature for this toggle is enabled.
	 *
	 * @return bool True if the fe