e = $this->indexable_repository->find_by_id_and_type( (int) $term_id, 'term' );

		return $this->score_icon_helper->for_seo( $indexable, '', __( 'Term is set to noindex.', 'wordpress-seo' ) );
	}

	/**
	 * Parses the value for the readability score column.
	 *
	 * @param int $term_id ID of the requested term.
	 *
	 * @return string The HTML for the readability score indicator.
	 */
	private function get_score_readability_value( $term_id ) {
		$score = (int) WPSEO_Taxonomy_Meta::get_term_meta( $term_id, $this->taxonomy, 'content_score' );

		return $this->score_icon_helper->for_readability( $score );
	}

	/**
	 * Check if the taxonomy is indexable.
	 *
	 * @param mixed $term The current term.
	 *
	 * @return bool Whether the term is indexable.
	 */
	private function is_indexable( $term ) {
		// When the no_index value is not empty and not default, check if its value is index.
		$no_index = WPSEO_Taxonomy_Meta::get_term_meta( $term->term_id, $this->taxonomy, 'noindex' );

		// Check if the default for taxonomy is empty (this will be index).
		if ( ! empty( $no_index ) && $no_index !== 'default' ) {
			return ( $no_index === 'index' );
		}

		if ( is_object( $term ) ) {
			$no_index_key = 'noindex-tax-' . $term->taxonomy;

			// If the option is false, this means we want to index it.
			return WPSEO_Options::get( $no_index_key, false ) === false;
		}

		return true;
	}

	/**
	 * Wraps the WPSEO_Metabox check to determine whether the metabox should be displayed either by
	 * choice of the admin or because the taxonomy is not public.
	 *
	 * @since 7.0
	 *
	 * @param string|null $taxonomy Optional. The taxonomy to test, defaults to the current taxonomy.
	 *
	 * @return bool Whether the meta box (and associated columns etc) should be hidden.
	 */
	private function display_metabox( $taxonomy = null ) {
		$current_taxonomy = $this->get_current_taxonomy();

		if ( ! isset( $taxonomy ) && ! empty( $current_taxonomy ) ) {
			$taxonomy = $current_taxonomy;
		}

		return WPSEO_Utils::is_metabox_active( $taxonomy, 'taxonomy' );
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         plugins/wordpress-seo-extended/admin/taxonomy/class-taxonomy-fields.php                             0000644                 00000012037 15122266555 0022557 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 */

/**
 * Class WPSEO_Taxonomy_Tab.
 *
 * Contains the basics for each class extending this one.
 */
class WPSEO_Taxonomy_Fields {

	/**
	 * Returns the taxonomy fields.
	 *
	 * @param string $field_group The field group.
	 *
	 * @return array
	 */
	public function get( $field_group ) {
		$fields = [];

		switch ( $field_group ) {
			case 'content':
				$fields = $this->get_content_fields();
				break;
			case 'settings':
				$fields = $this->get_settings_fields();
				break;
			case 'social':
				$fields = $this->get_social_fields();
				break;
		}

		return $this->filter_hidden_fields( $fields );
	}

	/**
	 * Returns array with the fields for the general tab.
	 *
	 * @return array
	 */
	protected function get_content_fields() {
		$fields = [
			'title' => [
				'label'       => '',
				'description' => '',
				'type'        => 'hidden',
				'options'     => '',
				'hide'        => false,
			],
			'desc' => [
				'label'       => '',
				'description' => '',
				'type'        => 'hidden',
				'options'     => '',
				'hide'        => false,
			],
			'linkdex' => [
				'label'       => '',
				'description' => '',
				'type'        => 'hidden',
				'options'     => '',
				'hide'        => false,
			],
			'content_score' => [
				'label'       => '',
				'description' => '',
				'type'        => 'hidden',
				'options'     => '',
				'hide'        => false,
			],
			'inclusive_language_score' => [
				'label'       => '',
				'description' => '',
				'type'        => 'hidden',
				'options'     => '',
				'hide'        => false,
			],
			'focuskw' => [
				'label'       => '',
				'description' => '',
				'type'        => 'hidden',
				'options'     => '',
				'hide'        => false,
			],
			'is_cornerstone' => [
				'label'       => '',
				'description' => '',
				'type'        => 'hidden',
				'options'     => '',
				'hide'        => false,
			],
		];

		/**
		 * Filter: 'wpseo_taxonomy_content_fields' - Adds the possibility to register additional content fields.
		 *
		 * @param array $additional_fields The additional fields.
		 */
		$additional_fields = apply_filters( 'wpseo_taxonomy_content_fields', [] );

		return array_merge( $fields, $additional_fields );
	}

	/**
	 * Returns array with the fields for the settings tab.
	 *
	 * @return array
	 */
	protected function get_settings_fields() {
		return [
			'noindex' => [
				'label'       => '',
				'description' => '',
				'type'        => 'hidden',
				'options'     => '',
				'hide'        => false,
			],
			'bctitle' => [
				'label'       => '',
				'description' => '',
				'type'        => 'hidden',
				'options'     => '',
				'hide'        => ( WPSEO_Options::get( 'breadcrumbs-enable' ) !== true ),
			],
			'canonical' => [
				'label'       => '',
				'description' => '',
				'type'        => 'hidden',
				'options'     => '',
				'hide'        => false,
			],
		];
	}

	/**
	 * Returning the fields for the social media tab.
	 *
	 * @return array
	 */
	protected function get_social_fields() {
		$fields = [];

		if ( WPSEO_Options::get( 'opengraph', false ) === true ) {
			$fields = [
				'opengraph-title'       => [
					'label'       => '',
					'description' => '',
					'type'        => 'hidden',
					'options'     => '',
					'hide'        => false,
				],
				'opengraph-description' => [
					'label'       => '',
					'description' => '',
					'type'        => 'hidden',
					'options'     => '',
					'hide'        => false,
				],
				'opengraph-image'       => [
					'label'       => '',
					'description' => '',
					'type'        => 'hidden',
					'options'     => '',
					'hide'        => false,
				],
				'opengraph-image-id'    => [
					'label'       => '',
					'description' => '',
					'type'        => 'hidden',
					'options'     => '',
					'hide'        => false,
				],
			];
		}

		if ( WPSEO_Options::get( 'twitter', false ) === true ) {
			$fields = array_merge(
				$fields,
				[
					'twitter-title'       => [
						'label'       => '',
						'description' => '',
						'type'        => 'hidden',
						'options'     => '',
						'hide'        => false,
					],
					'twitter-description' => [
						'label'       => '',
						'description' => '',
						'type'        => 'hidden',
						'options'     => '',
						'hide'        => false,
					],
					'twitter-image'       => [
						'label'       => '',
						'description' => '',
						'type'        => 'hidden',
						'options'     => '',
						'hide'        => false,
					],
					'twitter-image-id'    => [
						'label'       => '',
						'description' => '',
						'type'        => 'hidden',
						'options'     => '',
						'hide'        => false,
					],
				]
			);
		}

		return $fields;
	}

	/**
	 * Filter the hidden fields.
	 *
	 * @param array $fields Array with the form fields that has will be filtered.
	 *
	 * @return array
	 */
	protected function filter_hidden_fields( array $fields ) {
		foreach ( $fields as $field_name => $field_options ) {
			if ( ! empty( $field_options['hide'] ) ) {
				unset( $fields[ $field_name ] );
			}
		}

		return $fields;
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 plugins/wordpress-seo-extended/admin/taxonomy/class-taxonomy-fields-presenter.php                   0000644                 00000015664 15122266555 0024575 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 */

/**
 * Class WPSEO_Taxonomy_Presenter.
 */
class WPSEO_Taxonomy_Fields_Presenter {

	/**
	 * The taxonomy meta data for the current term.
	 *
	 * @var array
	 */
	private $tax_meta;

	/**
	 * Constructs the WPSEO_Taxonomy_Fields_Presenter class.
	 *
	 * @param stdClass $term The current term.
	 */
	public function __construct( $term ) {
		$this->tax_meta = WPSEO_Taxonomy_Meta::get_term_meta( (int) $term->term_id, $term->taxonomy );
	}

	/**
	 * Displaying the form fields.
	 *
	 * @param array $fields Array with the fields that will be displayed.
	 *
	 * @return string
	 */
	public function html( array $fields ) {
		$content = '';
		foreach ( $fields as $field_name => $field_configuration ) {
			$content .= $this->form_row( 'wpseo_' . $field_name, $field_configuration );
		}
		return $content;
	}

	/**
	 * Create a row in the form table.
	 *
	 * @param string $field_name          Variable the row controls.
	 * @param array  $field_configuration Array with the field configuration.
	 *
	 * @return string
	 */
	private function form_row( $field_name, array $field_configuration ) {
		$esc_field_name = esc_attr( $field_name );

		$options = (array) $field_configuration['options'];

		if ( ! empty( $field_configuration['description'] ) ) {
			$options['description'] = $field_configuration['description'];
		}

		$label            = $this->get_label( $field_configuration['label'], $esc_field_name );
		$field            = $this->get_field( $field_configuration['type'], $esc_field_name, $this->get_field_value( $field_name ), $options );
		$help_content     = ( $field_configuration['options']['help'] ?? '' );
		$help_button_text = ( $field_configuration['options']['help-button'] ?? '' );
		$help             = new WPSEO_Admin_Help_Panel( $field_name, $help_button_text, $help_content );

		return $this->parse_row( $label, $help, $field );
	}

	/**
	 * Generates the html for the given field config.
	 *
	 * @param string $field_type  The fieldtype, e.g: text, checkbox, etc.
	 * @param string $field_name  The name of the field.
	 * @param string $field_value The value of the field.
	 * @param array  $options     Array with additional options.
	 *
	 * @return string
	 */
	private function get_field( $field_type, $field_name, $field_value, array $options ) {

		$class            = $this->get_class( $options );
		$field            = '';
		$description      = '';
		$aria_describedby = '';

		if ( ! empty( $options['description'] ) ) {
			$aria_describedby = ' aria-describedby="' . $field_name . '-desc"';
			$description      = '<p id="' . $field_name . '-desc" class="yoast-metabox__description">' . $options['description'] . '</p>';
		}

		switch ( $field_type ) {
			case 'div':
				$field .= '<div id="' . $field_name . '"></div>';
				break;
			case 'url':
				$field .= '<input name="' . $field_name . '" id="' . $field_name . '" ' . $class . ' type="url" value="' . esc_attr( urldecode( $field_value ) ) . '" size="40"' . $aria_describedby . '/>';
				break;
			case 'text':
				$field .= '<input name="' . $field_name . '" id="' . $field_name . '" ' . $class . ' type="text" value="' . esc_attr( $field_value ) . '" size="40"' . $aria_describedby . '/>';
				break;
			case 'checkbox':
				$field .= '<input name="' . $field_name . '" id="' . $field_name . '" type="checkbox" ' . checked( $field_value ) . $aria_describedby . '/>';
				break;
			case 'textarea':
				$rows = 3;
				if ( ! empty( $options['rows'] ) ) {
					$rows = $options['rows'];
				}
				$field .= '<textarea class="large-text" rows="' . esc_attr( $rows ) . '" id="' . $field_name . '" name="' . $field_name . '"' . $aria_describedby . '>' . esc_textarea( $field_value ) . '</textarea>';
				break;
			case 'upload':
				$field .= '<input'
					. ' id="' . $field_name . '"'
					. ' type="text"'
					. ' size="36"'
					. ' name="' . $field_name . '"'
					. ' value="' . esc_attr( $field_value ) . '"' . $aria_describedby . ''
					. ' readonly="readonly"'
					. ' /> ';
				$field .= '<input'
					. ' id="' . esc_attr( $field_name ) . '_button"'
					. ' class="wpseo_image_upload_button button"'
					. ' data-target="' . esc_attr( $field_name ) . '"'
					. ' data-target-id="hidden_' . esc_attr( $field_name ) . '-id"'
					. ' type="button"'
					. ' value="' . esc_attr__( 'Upload Image', 'wordpress-seo' ) . '"'
					. ' /> ';
				$field .= '<input'
					. ' id="' . esc_attr( $field_name ) . '_button"'
					. ' class="wpseo_image_remove_button button"'
					. ' type="button"'
					. ' value="' . esc_attr__( 'Clear Image', 'wordpress-seo' ) . '"'
					. ' />';
				break;
			case 'select':
				if ( is_array( $options ) && $options !== [] ) {
					$field .= '<select name="' . $field_name . '" id="' . $field_name . '"' . $aria_describedby . '>';

					$select_options = ( array_key_exists( 'options', $options ) ) ? $options['options'] : $options;

					foreach ( $select_options as $option => $option_label ) {
						$selected = selected( $option, $field_value, false );
						$field   .= '<option ' . $selected . ' value="' . esc_attr( $option ) . '">' . esc_html( $option_label ) . '</option>';
					}
					unset( $option, $option_label, $selected );

					$field .= '</select>';
				}
				break;
			case 'hidden':
				$field .= '<input name="' . $field_name . '" id="hidden_' . $field_name . '" type="hidden" value="' . esc_attr( $field_value ) . '" />';
				break;
		}

		return $field . $description;
	}

	/**
	 * Getting the value for given field_name.
	 *
	 * @param string $field_name The fieldname to get the value for.
	 *
	 * @return string
	 */
	private function get_field_value( $field_name ) {
		if ( isset( $this->tax_meta[ $field_name ] ) && $this->tax_meta[ $field_name ] !== '' ) {
			return $this->tax_meta[ $field_name ];
		}

		return '';
	}

	/**
	 * Getting the class attributes if $options contains a class key.
	 *
	 * @param array $options The array with field options.
	 *
	 * @return string
	 */
	private function get_class( array $options ) {
		if ( ! empty( $options['class'] ) ) {
			return ' class="' . esc_attr( $options['class'] ) . '"';
		}

		return '';
	}

	/**
	 * Getting the label HTML.
	 *
	 * @param string $label      The label value.
	 * @param string $field_name The target field.
	 *
	 * @return string
	 */
	private function get_label( $label, $field_name ) {
		if ( $label !== '' ) {
			return '<label for="' . $field_name . '">' . esc_html( $label ) . '</label>';
		}

		return '';
	}

	/**
	 * Returns the HTML for the row which contains label, help and the field.
	 *
	 * @param string                 $label The html for the label if there was a label set.
	 * @param WPSEO_Admin_Help_Panel $help  The help panel to render in this row.
	 * @param string                 $field The html for the field.
	 *
	 * @return string
	 */
	private function parse_row( $label, WPSEO_Admin_Help_Panel $help, $field ) {
		if ( $label !== '' || $help !== '' ) {
			return $label . $help->get_button_html() . $help->get_panel_html() . $field;
		}

		return $field;
	}
}
                                                                            plugins/wordpress-seo-extended/admin/taxonomy/class-taxonomy-metabox.php                            0000644                 00000014060 15122266555 0022746 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 */

/**
 * This class generates the metabox on the edit term page.
 */
class WPSEO_Taxonomy_Metabox {

	/**
	 * The term currently being edited.
	 *
	 * @var WP_Term
	 */
	private $term;

	/**
	 * The term's taxonomy.
	 *
	 * @var string
	 */
	private $taxonomy;

	/**
	 * Whether or not the social tab is enabled for this metabox.
	 *
	 * @var bool
	 */
	private $is_social_enabled;

	/**
	 * Helper to determine whether or not the SEO analysis is enabled.
	 *
	 * @var WPSEO_Metabox_Analysis_SEO
	 */
	protected $seo_analysis;

	/**
	 * Helper to determine whether or not the readability analysis is enabled.
	 *
	 * @var WPSEO_Metabox_Analysis_Readability
	 */
	protected $readability_analysis;

	/**
	 * Helper to determine whether or not the inclusive language analysis is enabled.
	 *
	 * @var WPSEO_Metabox_Analysis_Inclusive_Language
	 */
	protected $inclusive_language_analysis;

	/**
	 * The constructor.
	 *
	 * @param string   $taxonomy The taxonomy.
	 * @param stdClass $term     The term.
	 */
	public function __construct( $taxonomy, $term ) {
		$this->term              = $term;
		$this->taxonomy          = $taxonomy;
		$this->is_social_enabled = WPSEO_Options::get( 'opengraph', false ) || WPSEO_Options::get( 'twitter', false );

		$this->seo_analysis                = new WPSEO_Metabox_Analysis_SEO();
		$this->readability_analysis        = new WPSEO_Metabox_Analysis_Readability();
		$this->inclusive_language_analysis = new WPSEO_Metabox_Analysis_Inclusive_Language();
	}

	/**
	 * Shows the Yoast SEO metabox for the term.
	 *
	 * @return void
	 */
	public function display() {
		// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Reason: $this->get_product_title() returns a hard-coded string.
		printf( '<div id="wpseo_meta" class="postbox yoast wpseo-taxonomy-metabox-postbox"><h2><span>%1$s</span></h2>', $this->get_product_title() );

		echo '<div class="inside">';
		echo '<div id="taxonomy_overall"></div>';

		$this->render_hidden_fields();
		$this->render_tabs();

		echo '</div>';
		echo '</di